/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.compiler.processor.roomcompanion.typeelementprocessor;

import androidx.annotation.NonNull;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import com.dailystudio.devbricksx.annotations.OverrideProperty;
import com.dailystudio.devbricksx.annotations.RoomCompanion;
import com.dailystudio.devbricksx.compiler.processor.AbsSingleTypeElementProcessor;
import com.dailystudio.devbricksx.compiler.processor.AbsTypeElementProcessor;
import com.dailystudio.devbricksx.compiler.processor.roomcompanion.GeneratedNames;
import com.dailystudio.devbricksx.compiler.processor.roomcompanion.TypeNamesUtils;
import com.dailystudio.devbricksx.compiler.utils.AnnotationsUtils;
import com.dailystudio.devbricksx.compiler.utils.NameUtils;
import com.dailystudio.devbricksx.compiler.utils.TextUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class RoomCompanionClassProcessor
extends AbsSingleTypeElementProcessor {
    @Override
    protected List<AbsTypeElementProcessor.GeneratedResult> onProcess(TypeElement typeElement, String packageName, String typeName, RoundEnvironment roundEnv, Object preResults) {
        String indicesStrings;
        String foreignKeyStrings;
        String[] primaryKeys;
        ClassName generatedClassName = ClassName.get((String)packageName, (String)GeneratedNames.getRoomCompanionName(typeName), (String[])new String[0]);
        this.debug("generated class = [%s]", generatedClassName);
        RoomCompanion companionAnnotation = typeElement.getAnnotation(RoomCompanion.class);
        if (companionAnnotation == null) {
            return null;
        }
        ClassName superType = null;
        RoomCompanion superRoomCompanion = null;
        TypeMirror superClass = typeElement.getSuperclass();
        if (superClass != null) {
            Element superElement = this.mTypesUtils.asElement(superClass);
            superRoomCompanion = superElement.getAnnotation(RoomCompanion.class);
            this.debug("super class annotation: %s", superRoomCompanion);
            if (superRoomCompanion != null) {
                String superTypePackage = this.getPackageNameOfTypeElement((TypeElement)superElement);
                String string = this.getTypeNameOfTypeElement((TypeElement)superElement);
                superType = ClassName.get((String)superTypePackage, (String)GeneratedNames.getRoomCompanionName(string), (String[])new String[0]);
            }
        }
        if ((primaryKeys = companionAnnotation.primaryKeys()) == null || primaryKeys.length <= 0) {
            this.error("primary keys are not specified for [%s]", typeName);
            return null;
        }
        HashSet<String> primaryKeySet = new HashSet<String>();
        for (String key : primaryKeys) {
            primaryKeySet.add(key);
        }
        String string = this.buildPrimaryKeysString(primaryKeys);
        AnnotationSpec.Builder entityAnnotationBuilder = AnnotationSpec.builder(Entity.class).addMember("tableName", "$S", new Object[]{GeneratedNames.getTableName(typeName)});
        if (primaryKeySet.size() > 1) {
            entityAnnotationBuilder.addMember("primaryKeys", "$L", new Object[]{string});
        }
        if (!TextUtils.isEmpty(foreignKeyStrings = this.buildForeignKeysString(typeElement))) {
            entityAnnotationBuilder.addMember("foreignKeys", "$N", new Object[]{foreignKeyStrings});
        }
        if (!TextUtils.isEmpty(indicesStrings = this.buildIndicesString(typeElement))) {
            entityAnnotationBuilder.addMember("indices", "$N", new Object[]{indicesStrings});
        }
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)generatedClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(entityAnnotationBuilder.build());
        if (superType != null) {
            classBuilder.superclass((TypeName)superType);
        }
        List<? extends Element> subElements = typeElement.getEnclosedElements();
        ExecutableElement constructorElement = null;
        ArrayList<FieldSpec> fieldSpecs = new ArrayList<FieldSpec>();
        HashSet<String> fields = new HashSet<String>();
        HashSet<String> fieldsOutsideConstructor = new HashSet<String>();
        for (Element element : subElements) {
            int oldParamsCount;
            if (element instanceof VariableElement) {
                this.debug("processing field: %s", element);
                VariableElement varElement = (VariableElement)element;
                String varName = varElement.getSimpleName().toString();
                if ("Companion".equals(varName)) {
                    this.warn("skip [Companion] field ...", new Object[0]);
                    continue;
                }
                if (varElement.getAnnotation(Ignore.class) != null) {
                    this.warn("skip [Ignore] field ...", new Object[0]);
                    continue;
                }
                if (varElement.getAnnotation(OverrideProperty.class) != null) {
                    this.warn("skip [OverrideProperty] field ...", new Object[0]);
                    continue;
                }
                TypeMirror fieldType = varElement.asType();
                FieldSpec.Builder fieldSpecBuilder = FieldSpec.builder((TypeName)TypeName.get((TypeMirror)fieldType), (String)varName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC});
                fieldSpecBuilder.addAnnotation(AnnotationSpec.builder(ColumnInfo.class).addMember("name", "$S", new Object[]{NameUtils.underscoreCaseName(varName)}).build());
                if (primaryKeySet.contains(varName)) {
                    fieldSpecBuilder.addAnnotation(NonNull.class);
                    if (primaryKeySet.size() == 1) {
                        AnnotationSpec.Builder primaryKeySpecBuilder = AnnotationSpec.builder(PrimaryKey.class);
                        if (companionAnnotation.autoGenerate()) {
                            primaryKeySpecBuilder.addMember("autoGenerate", "$L", new Object[]{true});
                        }
                        fieldSpecBuilder.addAnnotation(primaryKeySpecBuilder.build());
                    }
                }
                fieldSpecs.add(fieldSpecBuilder.build());
                fields.add(varName);
                fieldsOutsideConstructor.add(varName);
                continue;
            }
            if (!(element instanceof ExecutableElement) || !"<init>".equals(element.getSimpleName().toString())) continue;
            this.debug("processing constructor: %s", element);
            if (constructorElement == null) {
                constructorElement = (ExecutableElement)element;
                continue;
            }
            int newParamsCount = this.getParametersCount((ExecutableElement)element);
            if (newParamsCount <= (oldParamsCount = this.getParametersCount(constructorElement))) continue;
            constructorElement = (ExecutableElement)element;
        }
        if (constructorElement == null) {
            this.warn("failed to access constructor of %s", typeElement);
            return null;
        }
        ClassName object = TypeNamesUtils.getObjectTypeName(packageName, typeName);
        ClassName className = TypeNamesUtils.getCompanionTypeName(packageName, typeName);
        TypeName listOfCompanions = TypeNamesUtils.getListOfCompanionsTypeName(packageName, typeName);
        TypeName listOfObjects = TypeNamesUtils.getListOfObjectsTypeName(packageName, typeName);
        WildcardTypeName wildcardListOfObjects = WildcardTypeName.supertypeOf((TypeName)listOfObjects);
        TypeName continuationOfListOfObjects = TypeNamesUtils.getContinuationOfTypeName((TypeName)wildcardListOfObjects);
        TypeName func2 = TypeNamesUtils.getFunction2OfTypeName(listOfCompanions, continuationOfListOfObjects, listOfObjects);
        MethodSpec.Builder methodToObjectBuilder = MethodSpec.methodBuilder((String)"toObject").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)object);
        StringBuilder constParamsBuilder = new StringBuilder();
        List<? extends VariableElement> constParams = constructorElement.getParameters();
        for (int i = 0; i < constParams.size(); ++i) {
            VariableElement param = constParams.get(i);
            String paramName = param.getSimpleName().toString();
            this.debug("param: %s", param.getSimpleName());
            constParamsBuilder.append(paramName);
            if (i < constParams.size() - 1) {
                constParamsBuilder.append(", ");
            }
            fieldsOutsideConstructor.remove(paramName);
        }
        methodToObjectBuilder.addStatement("$T object = new $T($N)", new Object[]{object, object, constParamsBuilder.toString()});
        methodToObjectBuilder.addStatement("copyFieldsToObject(object)", new Object[0]);
        methodToObjectBuilder.addStatement("return object", new Object[0]);
        MethodSpec.Builder methodCopyFieldsToObjectBuilder = MethodSpec.methodBuilder((String)"copyFieldsToObject").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)object, "object", new Modifier[0]);
        if (superType != null) {
            methodCopyFieldsToObjectBuilder.addStatement("super.copyFieldsToObject(object)", new Object[0]);
        }
        for (String fieldName : fieldsOutsideConstructor) {
            methodCopyFieldsToObjectBuilder.addStatement("object.set$N(this.$N)", new Object[]{NameUtils.capitalizeName(fieldName), fieldName});
        }
        classBuilder.addMethod(methodCopyFieldsToObjectBuilder.build());
        MethodSpec.Builder methodToCompanionBuilder = MethodSpec.methodBuilder((String)"fromObject").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter((TypeName)object, NameUtils.lowerCamelCaseName(typeName), new Modifier[0]).addStatement("$T companion = new $T()", new Object[]{generatedClassName, generatedClassName}).returns((TypeName)generatedClassName);
        methodToCompanionBuilder.addStatement("companion.copyFieldsFromObject($N)", new Object[]{NameUtils.lowerCamelCaseName(typeName)});
        methodToCompanionBuilder.addStatement("return companion", new Object[0]);
        MethodSpec.Builder methodCopyFieldsFromObjectBuilder = MethodSpec.methodBuilder((String)"copyFieldsFromObject").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)object, "object", new Modifier[0]);
        if (superType != null) {
            methodCopyFieldsFromObjectBuilder.addStatement("super.copyFieldsFromObject(object)", new Object[0]);
        }
        for (String fieldName : fields) {
            methodCopyFieldsFromObjectBuilder.addStatement("this.$N = object.get$N()", new Object[]{fieldName, NameUtils.capitalizeName(fieldName)});
        }
        classBuilder.addMethod(methodCopyFieldsFromObjectBuilder.build());
        for (FieldSpec fieldSpec : fieldSpecs) {
            classBuilder.addField(fieldSpec);
        }
        classBuilder.addMethod(methodToObjectBuilder.build());
        classBuilder.addMethod(methodToCompanionBuilder.build());
        FieldSpec.Builder fieldMapFuncBuilder = FieldSpec.builder((TypeName)TypeNamesUtils.getMapFunctionOfTypeName((TypeName)className, (TypeName)object), (String)"mapCompanionToObject", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC}).initializer("new Function<$T, $T>() {\n   @Override\n   public $T apply($T companion) {\n       return companion.toObject();\n   }\n}", new Object[]{className, object, object, className});
        classBuilder.addField(fieldMapFuncBuilder.build());
        FieldSpec.Builder fieldListMapFuncBuilder = FieldSpec.builder((TypeName)TypeNamesUtils.getMapFunctionOfTypeName(listOfCompanions, listOfObjects), (String)"mapCompanionsToObjects", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC}).initializer("new Function<$T, $T>() {\n   @Override\n   public $T apply($T companions) {\n       $T objects = new $T<>();\n       for(int i = 0; i < companions.size(); i++) {\n           objects.add(companions.get(i).toObject());\n       }\n       return objects;\n   }\n}", new Object[]{listOfCompanions, listOfObjects, listOfObjects, listOfCompanions, listOfObjects, TypeNamesUtils.getArrayListTypeName()});
        FieldSpec fieldListMapFunc = fieldListMapFuncBuilder.build();
        classBuilder.addField(fieldListMapFunc);
        FieldSpec.Builder fieldListMapSuspendFuncBuilder = FieldSpec.builder((TypeName)func2, (String)"mapCompanionsToObjectsSuspend", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.STATIC}).initializer("new $T() {\n   @Override\n   public $T invoke($T companions, $T continuation) {\n       return $N.apply(companions);\n   }\n}", new Object[]{func2, listOfObjects, listOfCompanions, continuationOfListOfObjects, fieldListMapFunc.name});
        classBuilder.addField(fieldListMapSuspendFuncBuilder.build());
        return this.singleResult(packageName, classBuilder);
    }

    private int getParametersCount(ExecutableElement executableElement) {
        List<? extends VariableElement> params = executableElement.getParameters();
        return params == null ? 0 : params.size();
    }

    private String buildPrimaryKeysString(String[] primaryKeys) {
        StringBuilder prKeysBuilder = new StringBuilder("{ ");
        for (int i = 0; i < primaryKeys.length; ++i) {
            prKeysBuilder.append("\"");
            prKeysBuilder.append(primaryKeys[i]);
            prKeysBuilder.append("\"");
            if (i >= primaryKeys.length - 1) continue;
            prKeysBuilder.append(", ");
        }
        prKeysBuilder.append(" }");
        return prKeysBuilder.toString();
    }

    private String buildForeignKeysString(TypeElement typeElement) {
        List<AnnotationMirror> foreignKeys = AnnotationsUtils.getAnnotationValueFromAnnotation(typeElement, "foreignKeys");
        this.debug("foreign keys = [%s]", foreignKeys);
        if (foreignKeys == null) {
            return null;
        }
        StringBuilder foreignKeyStrings = new StringBuilder();
        foreignKeyStrings.append("{ ");
        int N = foreignKeys.size();
        for (int i = 0; i < N; ++i) {
            AnnotationMirror mirror = foreignKeys.get(i);
            AnnotationSpec spec = AnnotationSpec.get((AnnotationMirror)mirror);
            String foreignKeyString = mirror.toString();
            List codeBlocks = (List)spec.members.get("entity");
            if (codeBlocks != null) {
                for (CodeBlock cb : codeBlocks) {
                    ClassName className = ClassName.bestGuess((String)cb.toString().replace(".class", ""));
                    ClassName companionClassName = TypeNamesUtils.getCompanionTypeName(className.packageName(), className.simpleName());
                    foreignKeyString = foreignKeyString.replace(className.toString(), companionClassName.toString());
                }
            }
            foreignKeyStrings.append(foreignKeyString);
            if (i >= N - 1) continue;
            foreignKeyStrings.append(", ");
        }
        foreignKeyStrings.append(" }");
        return foreignKeyStrings.toString();
    }

    private String buildIndicesString(TypeElement typeElement) {
        List<AnnotationMirror> indices = AnnotationsUtils.getAnnotationValueFromAnnotation(typeElement, "indices");
        this.debug("indices = [%s]", indices);
        if (indices == null) {
            return null;
        }
        StringBuilder indexStrings = new StringBuilder();
        indexStrings.append("{ ");
        int N = indices.size();
        for (int i = 0; i < N; ++i) {
            AnnotationMirror mirror = indices.get(i);
            String indexString = mirror.toString();
            indexStrings.append(indexString);
            if (i >= N - 1) continue;
            indexStrings.append(", ");
        }
        indexStrings.append(" }");
        return indexStrings.toString();
    }
}

