/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.compiler.processor.roomcompanion.typeelementprocessor;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Transaction;
import androidx.room.Update;
import com.dailystudio.devbricksx.annotations.RoomCompanion;
import com.dailystudio.devbricksx.compiler.processor.AbsSingleTypeElementProcessor;
import com.dailystudio.devbricksx.compiler.processor.AbsTypeElementProcessor;
import com.dailystudio.devbricksx.compiler.processor.roomcompanion.FieldsHelper;
import com.dailystudio.devbricksx.compiler.processor.roomcompanion.GeneratedNames;
import com.dailystudio.devbricksx.compiler.processor.roomcompanion.MethodStatementsGenerator;
import com.dailystudio.devbricksx.compiler.processor.roomcompanion.TypeNamesUtils;
import com.dailystudio.devbricksx.compiler.utils.AnnotationsUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.HashMap;
import java.util.List;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class RoomCompanionDaoClassProcessor
extends AbsSingleTypeElementProcessor {
    @Override
    protected List<AbsTypeElementProcessor.GeneratedResult> onProcess(TypeElement typeElement, String packageName, String typeName, RoundEnvironment roundEnv, Object preResults) {
        int pageSize;
        ClassName generatedClassName = ClassName.get((String)packageName, (String)GeneratedNames.getRoomCompanionDaoName(typeName), (String[])new String[0]);
        this.debug("generated class = [%s]", generatedClassName);
        RoomCompanion companionAnnotation = typeElement.getAnnotation(RoomCompanion.class);
        if (companionAnnotation == null) {
            return null;
        }
        HashMap<String, TypeName> primaryKeyFields = new HashMap<String, TypeName>();
        FieldsHelper.collectPrimaryKeyFields(typeElement, primaryKeyFields, this.mTypesUtils);
        ClassName daoExtension = AnnotationsUtils.getClassValueFromAnnotation(typeElement, "extension");
        this.debug("dao extension = [%s]", daoExtension);
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)generatedClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addAnnotation(Dao.class);
        if (daoExtension != null && !TypeNamesUtils.getVoidTypeName().equals((Object)daoExtension)) {
            classBuilder.superclass((TypeName)ClassName.get((String)daoExtension.packageName(), (String)GeneratedNames.getDaoExtensionCompanionName(daoExtension.simpleName()), (String[])new String[0]));
        }
        if ((pageSize = companionAnnotation.pageSize()) <= 0) {
            this.error("page size must be positive.", new Object[0]);
            return null;
        }
        String tableName = GeneratedNames.getTableName(typeName);
        ClassName object = TypeNamesUtils.getObjectTypeName(packageName, typeName);
        ClassName companion = TypeNamesUtils.getCompanionTypeName(packageName, typeName);
        ClassName arrayList = ClassName.get((String)"java.util", (String)"ArrayList", (String[])new String[0]);
        TypeName liveDataOfObject = TypeNamesUtils.getLiveDataOfObjectTypeName(packageName, typeName);
        TypeName liveDataOfCompanion = TypeNamesUtils.getLiveDataOfCompanionTypeName(packageName, typeName);
        TypeName listOfCompanions = TypeNamesUtils.getListOfCompanionsTypeName(packageName, typeName);
        TypeName listOfObjects = TypeNamesUtils.getListOfObjectsTypeName(packageName, typeName);
        TypeName liveDataOfListOfCompanions = TypeNamesUtils.getLiveDataOfListOfCompanionsTypeName(packageName, typeName);
        TypeName liveDataOfListOfObjects = TypeNamesUtils.getLiveDataOfListOfObjectsTypeName(packageName, typeName);
        TypeName dataSourceFactoryOfCompanions = TypeNamesUtils.getDataSourceFactoryOfCompanionsTypeName(packageName, typeName);
        TypeName pagingSourceOfCompanions = TypeNamesUtils.getPagingSourceOfCompanionsTypeName(packageName, typeName);
        TypeName pagingSourceOfObjects = TypeNamesUtils.getPagingSourceOfObjectsTypeName(packageName, typeName);
        TypeName flowOfListOfCompanions = TypeNamesUtils.getFlowOfListOfCompanionsTypeName(packageName, typeName);
        TypeName flowOfListOfObjects = TypeNamesUtils.getFlowOfListOfObjectsTypeName(packageName, typeName);
        String whereClauseForGetOneMethods = FieldsHelper.primaryKeyFieldsToWhereClause(primaryKeyFields);
        String getOneMethodCallParameters = FieldsHelper.primaryKeyFieldsToFuncCallParameters(primaryKeyFields);
        MethodSpec.Builder methodGetOneBuilder = MethodSpec.methodBuilder((String)"_getOne").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)companion);
        FieldsHelper.primaryKeyFieldsToMethodParameters(methodGetOneBuilder, primaryKeyFields);
        methodGetOneBuilder.addAnnotation(AnnotationSpec.builder(Query.class).addMember("value", "$S", new Object[]{"SELECT * FROM `" + tableName + "` " + whereClauseForGetOneMethods}).build());
        MethodSpec methodGetOne = methodGetOneBuilder.build();
        classBuilder.addMethod(methodGetOne);
        MethodSpec.Builder methodGetOneLiveBuilder = MethodSpec.methodBuilder((String)"_getOneLive").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(liveDataOfCompanion);
        FieldsHelper.primaryKeyFieldsToMethodParameters(methodGetOneLiveBuilder, primaryKeyFields);
        methodGetOneLiveBuilder.addAnnotation(AnnotationSpec.builder(Query.class).addMember("value", "$S", new Object[]{"SELECT * FROM `" + tableName + "` " + whereClauseForGetOneMethods}).build());
        MethodSpec methodGetOneLive = methodGetOneLiveBuilder.build();
        classBuilder.addMethod(methodGetOneLive);
        MethodSpec methodGetAll = MethodSpec.methodBuilder((String)"_getAll").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(listOfCompanions).addAnnotation(AnnotationSpec.builder(Query.class).addMember("value", "$S", new Object[]{"SELECT * FROM `" + tableName + "`"}).build()).build();
        classBuilder.addMethod(methodGetAll);
        MethodSpec methodGetAllLive = MethodSpec.methodBuilder((String)"_getAllLive").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(liveDataOfListOfCompanions).addAnnotation(AnnotationSpec.builder(Query.class).addMember("value", "$S", new Object[]{"SELECT * FROM `" + tableName + "`"}).build()).build();
        classBuilder.addMethod(methodGetAllLive);
        MethodSpec methodGetAllDataSourceFactory = MethodSpec.methodBuilder((String)"_getAllDataSource").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(dataSourceFactoryOfCompanions).addAnnotation(AnnotationSpec.builder(Query.class).addMember("value", "$S", new Object[]{"SELECT * FROM `" + tableName + "`"}).build()).build();
        classBuilder.addMethod(methodGetAllDataSourceFactory);
        MethodSpec methodGetAllFlow = MethodSpec.methodBuilder((String)"_getAllFlow").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(flowOfListOfCompanions).addAnnotation(AnnotationSpec.builder(Query.class).addMember("value", "$S", new Object[]{"SELECT * FROM `" + tableName + "`"}).build()).build();
        classBuilder.addMethod(methodGetAllFlow);
        MethodSpec methodInsertOne = MethodSpec.methodBuilder((String)"_insert").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)companion, "companion", new Modifier[0]).returns(Long.class).addAnnotation(AnnotationSpec.builder(Insert.class).addMember("onConflict", "$L", new Object[]{5}).build()).build();
        classBuilder.addMethod(methodInsertOne);
        MethodSpec methodInsertAll = MethodSpec.methodBuilder((String)"_insert").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(listOfCompanions, "companions", new Modifier[0]).returns(TypeNamesUtils.getListOfTypeName(Long.class)).addAnnotation(AnnotationSpec.builder(Insert.class).addMember("onConflict", "$L", new Object[]{5}).build()).build();
        classBuilder.addMethod(methodInsertAll);
        MethodSpec methodUpdateOne = MethodSpec.methodBuilder((String)"_update").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)companion, "companion", new Modifier[0]).addAnnotation(Update.class).build();
        classBuilder.addMethod(methodUpdateOne);
        MethodSpec methodUpdateAll = MethodSpec.methodBuilder((String)"_update").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(listOfCompanions, "companion", new Modifier[0]).addAnnotation(Update.class).build();
        classBuilder.addMethod(methodUpdateAll);
        MethodSpec methodInsertOrUpdateOne = MethodSpec.methodBuilder((String)"_insertOrUpdate").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)companion, "companion", new Modifier[0]).addAnnotation(Transaction.class).addStatement("long id = $N(companion)", new Object[]{methodInsertOne.name}).beginControlFlow("if (id == -1L)", new Object[0]).addStatement("$N(companion)", new Object[]{methodUpdateOne.name}).endControlFlow().build();
        classBuilder.addMethod(methodInsertOrUpdateOne);
        MethodSpec methodInsertOrUpdateAll = MethodSpec.methodBuilder((String)"_insertOrUpdate").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(listOfCompanions, "companions", new Modifier[0]).addAnnotation(Transaction.class).addStatement("$T insertResults = $N(companions)", new Object[]{TypeNamesUtils.getListOfTypeName(Long.class), methodInsertAll.name}).beginControlFlow("if (insertResults == null)", new Object[0]).addStatement("return", new Object[0]).endControlFlow().addStatement("$T updateList = new $T<>()", new Object[]{listOfCompanions, arrayList}).beginControlFlow("for (int i = 0; i < insertResults.size(); i++)", new Object[0]).beginControlFlow("if (insertResults.get(i) == -1L)", new Object[0]).addStatement("updateList.add(companions.get(i))", new Object[0]).endControlFlow().endControlFlow().beginControlFlow("if (updateList.size() > 0)", new Object[0]).beginControlFlow("for (int i = 0; i < updateList.size(); i++)", new Object[0]).addStatement("$N(updateList.get(i))", new Object[]{methodUpdateOne.name}).endControlFlow().endControlFlow().build();
        classBuilder.addMethod(methodInsertOrUpdateAll);
        MethodSpec methodDeleteOne = MethodSpec.methodBuilder((String)"_delete").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)companion, "companion", new Modifier[0]).addAnnotation(Delete.class).build();
        classBuilder.addMethod(methodDeleteOne);
        MethodSpec.Builder methodGetOneWrapperBuilder = MethodSpec.methodBuilder((String)"getOne").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)object);
        FieldsHelper.primaryKeyFieldsToMethodParameters(methodGetOneWrapperBuilder, primaryKeyFields);
        MethodStatementsGenerator.outputCompanionToObject(packageName, typeName, methodGetOneWrapperBuilder, methodGetOne.name, getOneMethodCallParameters);
        classBuilder.addMethod(methodGetOneWrapperBuilder.build());
        MethodSpec.Builder methodGetOneLiveWrapperBuilder = MethodSpec.methodBuilder((String)"getOneLive").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(liveDataOfObject);
        FieldsHelper.primaryKeyFieldsToMethodParameters(methodGetOneLiveWrapperBuilder, primaryKeyFields);
        MethodStatementsGenerator.outputLiveCompanionToLiveObject(packageName, typeName, methodGetOneLiveWrapperBuilder, methodGetOneLive.name, getOneMethodCallParameters);
        classBuilder.addMethod(methodGetOneLiveWrapperBuilder.build());
        MethodSpec.Builder methodGetAllWrapperBuilder = MethodSpec.methodBuilder((String)"getAll").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(listOfObjects);
        MethodStatementsGenerator.outputCompanionsToObjects(packageName, typeName, methodGetAllWrapperBuilder, methodGetAll.name);
        classBuilder.addMethod(methodGetAllWrapperBuilder.build());
        MethodSpec.Builder methodGetAllLiveWrapperBuilder = MethodSpec.methodBuilder((String)"getAllLive").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(liveDataOfListOfObjects);
        MethodStatementsGenerator.outputLiveCompanionsToLiveObjects(packageName, typeName, methodGetAllLiveWrapperBuilder, methodGetAllLive.name);
        classBuilder.addMethod(methodGetAllLiveWrapperBuilder.build());
        MethodSpec.Builder methodGetAllFlowWrapperBuilder = MethodSpec.methodBuilder((String)"getAllFlow").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(flowOfListOfObjects);
        MethodStatementsGenerator.outputFlowCompanionsToFlowObjects(packageName, typeName, methodGetAllFlowWrapperBuilder, methodGetAllFlow.name);
        classBuilder.addMethod(methodGetAllFlowWrapperBuilder.build());
        MethodSpec.Builder methodGetAllLivePagedWrapperBuilder = MethodSpec.methodBuilder((String)"getAllLivePaged").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(liveDataOfListOfObjects);
        MethodStatementsGenerator.outputDataSourceCompanionsToLiveObjects(packageName, typeName, pageSize, methodGetAllLivePagedWrapperBuilder, methodGetAllDataSourceFactory.name);
        classBuilder.addMethod(methodGetAllLivePagedWrapperBuilder.build());
        MethodSpec.Builder methodGetAllPagingSourceWrapperBuilder = MethodSpec.methodBuilder((String)"getAllPagingSource").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(pagingSourceOfObjects);
        MethodStatementsGenerator.outputDataSourceCompanionsToPagingSourceObjects(packageName, typeName, pageSize, methodGetAllPagingSourceWrapperBuilder, methodGetAllDataSourceFactory.name);
        classBuilder.addMethod(methodGetAllPagingSourceWrapperBuilder.build());
        MethodSpec methodInsertOneWrapper = MethodSpec.methodBuilder((String)"insert").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)object, "object", new Modifier[0]).beginControlFlow("if (object == null)", new Object[0]).addStatement("return -1L", new Object[0]).endControlFlow().addStatement("$T companion = $T.fromObject(object)", new Object[]{companion, companion}).addStatement("return this.$N(companion)", new Object[]{methodInsertOne.name}).returns(Long.class).build();
        classBuilder.addMethod(methodInsertOneWrapper);
        MethodSpec methodInsertAllWrapper = MethodSpec.methodBuilder((String)"insert").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(listOfObjects, "objects", new Modifier[0]).beginControlFlow("if (objects == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addStatement("$T companions = new $T<>()", new Object[]{listOfCompanions, arrayList}).beginControlFlow("for (int i = 0; i < objects.size(); i++)", new Object[0]).addStatement("companions.add($T.fromObject(objects.get(i)))", new Object[]{companion}).endControlFlow().addStatement("return this.$N(companions)", new Object[]{methodInsertAll.name}).returns(TypeNamesUtils.getListOfTypeName(Long.class)).build();
        classBuilder.addMethod(methodInsertAllWrapper);
        MethodSpec methodUpdateOneWrapper = MethodSpec.methodBuilder((String)"update").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)object, "object", new Modifier[0]).beginControlFlow("if (object == null)", new Object[0]).addStatement("return", new Object[0]).endControlFlow().addStatement("$T companion = $T.fromObject(object)", new Object[]{companion, companion}).addStatement("this.$N(companion)", new Object[]{methodUpdateOne.name}).build();
        classBuilder.addMethod(methodUpdateOneWrapper);
        MethodSpec methodUpdateAllWrapper = MethodSpec.methodBuilder((String)"update").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(listOfObjects, "objects", new Modifier[0]).beginControlFlow("if (objects == null)", new Object[0]).addStatement("return", new Object[0]).endControlFlow().addStatement("$T companions = new $T<>()", new Object[]{listOfCompanions, arrayList}).beginControlFlow("for (int i = 0; i < objects.size(); i++)", new Object[0]).addStatement("companions.add($T.fromObject(objects.get(i)))", new Object[]{companion}).endControlFlow().addStatement("this.$N(companions)", new Object[]{methodUpdateAll.name}).build();
        classBuilder.addMethod(methodUpdateAllWrapper);
        MethodSpec methodInsertOrUpdateOneWrapper = MethodSpec.methodBuilder((String)"insertOrUpdate").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)object, "object", new Modifier[0]).beginControlFlow("if (object == null)", new Object[0]).addStatement("return", new Object[0]).endControlFlow().addStatement("$T companion = $T.fromObject(object)", new Object[]{companion, companion}).addStatement("this.$N(companion)", new Object[]{methodInsertOrUpdateOne.name}).build();
        classBuilder.addMethod(methodInsertOrUpdateOneWrapper);
        MethodSpec methodInsertOrUpdateAllWrapper = MethodSpec.methodBuilder((String)"insertOrUpdate").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(listOfObjects, "objects", new Modifier[0]).beginControlFlow("if (objects == null)", new Object[0]).addStatement("return", new Object[0]).endControlFlow().addStatement("$T companions = new $T<>()", new Object[]{listOfCompanions, arrayList}).beginControlFlow("for (int i = 0; i < objects.size(); i++)", new Object[0]).addStatement("companions.add($T.fromObject(objects.get(i)))", new Object[]{companion}).endControlFlow().addStatement("this.$N(companions)", new Object[]{methodInsertOrUpdateAll.name}).build();
        classBuilder.addMethod(methodInsertOrUpdateAllWrapper);
        MethodSpec methodDeleteWrapper = MethodSpec.methodBuilder((String)"delete").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)object, "object", new Modifier[0]).beginControlFlow("if (object == null)", new Object[0]).addStatement("return", new Object[0]).endControlFlow().addStatement("$T companion = $T.fromObject(object)", new Object[]{companion, companion}).addStatement("this.$N(companion)", new Object[]{methodDeleteOne.name}).build();
        classBuilder.addMethod(methodDeleteWrapper);
        return this.singleResult(packageName, classBuilder);
    }
}

