/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.compiler.processor.roomcompanion.typeelementprocessor;

import androidx.room.Database;
import androidx.room.TypeConverters;
import com.dailystudio.devbricksx.annotations.RoomCompanion;
import com.dailystudio.devbricksx.compiler.processor.AbsTypeElementProcessor;
import com.dailystudio.devbricksx.compiler.processor.AbsTypeElementsGroupProcessor;
import com.dailystudio.devbricksx.compiler.processor.roomcompanion.GeneratedNames;
import com.dailystudio.devbricksx.compiler.processor.roomcompanion.TypeNamesUtils;
import com.dailystudio.devbricksx.compiler.utils.AnnotationsUtils;
import com.dailystudio.devbricksx.compiler.utils.NameUtils;
import com.dailystudio.devbricksx.compiler.utils.TextUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class RoomCompanionDatabaseClassProcessor
extends AbsTypeElementsGroupProcessor {
    protected ClassName getCompanionDaoTypeName(String packageName, String typeElementName) {
        return ClassName.get((String)packageName, (String)GeneratedNames.getRoomCompanionDaoName(typeElementName), (String[])new String[0]);
    }

    protected AbsTypeElementProcessor.GeneratedResult processDatabase(String database, List<TypeElement> typeElements, RoundEnvironment roundEnv) {
        if (TextUtils.isEmpty(database) || typeElements == null || typeElements.size() <= 0) {
            return null;
        }
        this.debug("group for database = [%s]", database);
        String packageName = this.getPackageNameOfTypeElement(typeElements.get(0));
        this.debug("packageName for database = [%s]", packageName);
        ClassName generatedClassName = ClassName.get((String)packageName, (String)GeneratedNames.databaseToClassName(database), (String[])new String[0]);
        this.info("generated class = [%s]", generatedClassName);
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)generatedClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.ABSTRACT}).superclass((TypeName)ClassName.get((String)"androidx.room", (String)"RoomDatabase", (String[])new String[0]));
        StringBuilder entityClasses = new StringBuilder();
        entityClasses.append("{ ");
        int N = typeElements.size();
        ArrayList<ClassName> migrations = new ArrayList<ClassName>();
        int databaseVersion = 1;
        for (int i = 0; i < N; ++i) {
            List<ClassName> migrationsForElement;
            int elementDbVersion;
            TypeElement typeElement = typeElements.get(i);
            RoomCompanion companionAnnotation = typeElement.getAnnotation(RoomCompanion.class);
            if (companionAnnotation != null && (elementDbVersion = companionAnnotation.databaseVersion()) > databaseVersion) {
                databaseVersion = elementDbVersion;
                this.info("dbVersion [%d] of element[%s] is larger, using it as database version.", elementDbVersion, typeElement);
            }
            String typeName = this.getTypeNameOfTypeElement(typeElement);
            this.debug("packageName of typeElement[%s]: %s", typeElement, this.getPackageNameOfTypeElement(typeElement));
            if (!packageName.equals(this.getPackageNameOfTypeElement(typeElement))) {
                this.error("typeElement[%s] has different package name [%s] with rest ones in the same database.", typeElement, packageName);
            }
            entityClasses.append(GeneratedNames.getRoomCompanionName(typeName));
            entityClasses.append(".class");
            if (i < N - 1) {
                entityClasses.append(", ");
            }
            ClassName dao = this.getCompanionDaoTypeName(packageName, typeName);
            MethodSpec methodGetDao = MethodSpec.methodBuilder((String)NameUtils.lowerCamelCaseName(dao.simpleName())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)dao).build();
            classBuilder.addMethod(methodGetDao);
            List<ClassName> converters = AnnotationsUtils.getClassesValueFromAnnotation(typeElement, "converters");
            if (converters != null) {
                int CN = converters.size();
                StringBuilder converterClasses = new StringBuilder();
                converterClasses.append("{ ");
                for (int j = 0; j < CN; ++j) {
                    converterClasses.append("$T.class");
                    if (j >= CN - 1) continue;
                    converterClasses.append(", ");
                }
                converterClasses.append(" }");
                classBuilder.addAnnotation(AnnotationSpec.builder(TypeConverters.class).addMember("value", converterClasses.toString(), (Object[])converters.toArray(new ClassName[0])).build());
            }
            if ((migrationsForElement = AnnotationsUtils.getClassesValueFromAnnotation(typeElement, "migrations")) == null) continue;
            migrations.addAll(migrationsForElement);
        }
        entityClasses.append(" }");
        classBuilder.addAnnotation(AnnotationSpec.builder(Database.class).addMember("entities", "$N", new Object[]{entityClasses.toString()}).addMember("version", "$L", new Object[]{databaseVersion}).build());
        String instanceFieldName = "sInstance";
        classBuilder.addField(FieldSpec.builder((TypeName)generatedClassName, (String)instanceFieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).addModifiers(new Modifier[]{Modifier.VOLATILE}).addModifiers(new Modifier[]{Modifier.STATIC}).build());
        MethodSpec.Builder getInstanceWithMigrationsMethodBuilder = MethodSpec.methodBuilder((String)"getDatabase").addModifiers(new Modifier[]{Modifier.STATIC}).addModifiers(new Modifier[]{Modifier.SYNCHRONIZED}).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeNamesUtils.getContextTypeName(), "context", new Modifier[0]).addParameter((TypeName)ArrayTypeName.of((TypeName)TypeNamesUtils.getMigrationTypeName()), "migrations", new Modifier[0]).beginControlFlow("if ($N == null)", new Object[]{instanceFieldName}).addStatement("$T builder = $T.databaseBuilder(context.getApplicationContext(), $T.class, $S)", new Object[]{TypeNamesUtils.getRoomDatabaseBuilderTypeName((TypeName)generatedClassName), TypeNamesUtils.getRoomTypeName(), generatedClassName, database}).beginControlFlow("if (migrations != null)", new Object[0]).addStatement("builder.addMigrations(migrations)", new Object[0]).endControlFlow();
        if (databaseVersion > 1) {
            TypeName dummyMigrationClassName = TypeNamesUtils.getDummyMigrationTypeName();
            TypeName listOfMigrations = TypeNamesUtils.getListOfTypeName(TypeNamesUtils.getMigrationTypeName());
            getInstanceWithMigrationsMethodBuilder.beginControlFlow("else", new Object[0]);
            getInstanceWithMigrationsMethodBuilder.addStatement("$T customizedMigrations = new $T()", new Object[]{listOfMigrations, TypeNamesUtils.getArrayListTypeName()});
            if (migrations.isEmpty()) {
                getInstanceWithMigrationsMethodBuilder.addStatement("customizedMigrations.add(new $T(1, $L))", new Object[]{dummyMigrationClassName, databaseVersion});
            } else {
                for (ClassName migration : migrations) {
                    getInstanceWithMigrationsMethodBuilder.addStatement("customizedMigrations.add(new $T())", new Object[]{migration});
                }
            }
            getInstanceWithMigrationsMethodBuilder.addStatement("builder.addMigrations(customizedMigrations.toArray(new $T[0]))", new Object[]{TypeNamesUtils.getMigrationTypeName()}).endControlFlow();
        }
        getInstanceWithMigrationsMethodBuilder.addStatement("$N = builder.build()", new Object[]{instanceFieldName}).endControlFlow().addStatement("return $N", new Object[]{instanceFieldName}).returns((TypeName)generatedClassName);
        MethodSpec getInstanceWithMigrationsMethod = getInstanceWithMigrationsMethodBuilder.build();
        classBuilder.addMethod(getInstanceWithMigrationsMethod);
        MethodSpec.Builder getInstanceMethodBuilder = MethodSpec.methodBuilder((String)"getDatabase").addModifiers(new Modifier[]{Modifier.STATIC}).addModifiers(new Modifier[]{Modifier.SYNCHRONIZED}).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeNamesUtils.getContextTypeName(), "context", new Modifier[0]).addStatement("return $N(context, null)", new Object[]{getInstanceWithMigrationsMethod.name}).returns((TypeName)generatedClassName);
        classBuilder.addMethod(getInstanceMethodBuilder.build());
        return new AbsTypeElementProcessor.GeneratedResult(packageName, classBuilder);
    }

    @Override
    protected List<AbsTypeElementProcessor.GeneratedResult> onProcess(List<TypeElement> typeElements, RoundEnvironment roundEnv, Object preResults) {
        if (typeElements == null) {
            return null;
        }
        HashMap databasesMap = new HashMap();
        for (TypeElement typeElement : typeElements) {
            String typeName = this.getTypeNameOfTypeElement(typeElement);
            RoomCompanion companionAnnotation = typeElement.getAnnotation(RoomCompanion.class);
            String database = null;
            if (companionAnnotation != null) {
                database = companionAnnotation.database();
            }
            if (TextUtils.isEmpty(database)) {
                database = GeneratedNames.getRoomCompanionDatabaseName(typeName);
            }
            List groupedElements = databasesMap.containsKey(database) ? (List)databasesMap.get(database) : new ArrayList();
            groupedElements.add(typeElement);
            databasesMap.put(database, groupedElements);
        }
        if (databasesMap.size() <= 0) {
            return null;
        }
        ArrayList<AbsTypeElementProcessor.GeneratedResult> results = new ArrayList<AbsTypeElementProcessor.GeneratedResult>();
        Set keys = databasesMap.keySet();
        for (String database : keys) {
            AbsTypeElementProcessor.GeneratedResult result = this.processDatabase(database, (List)databasesMap.get(database), roundEnv);
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }
}

