/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.compiler.processor.roomcompanion.typeelementprocessor;

import androidx.room.Ignore;
import com.dailystudio.devbricksx.annotations.RoomCompanion;
import com.dailystudio.devbricksx.compiler.processor.AbsSingleTypeElementProcessor;
import com.dailystudio.devbricksx.compiler.processor.AbsTypeElementProcessor;
import com.dailystudio.devbricksx.compiler.processor.roomcompanion.GeneratedNames;
import com.dailystudio.devbricksx.compiler.processor.roomcompanion.TypeNamesUtils;
import com.dailystudio.devbricksx.compiler.utils.NameUtils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class RoomCompanionDiffUtilClassProcessor
extends AbsSingleTypeElementProcessor {
    @Override
    protected List<AbsTypeElementProcessor.GeneratedResult> onProcess(TypeElement typeElement, String packageName, String typeName, RoundEnvironment roundEnv, Object preResults) {
        String[] primaryKeys;
        ClassName generatedClassName = ClassName.get((String)packageName, (String)GeneratedNames.getDiffUtilName(typeName), (String[])new String[0]);
        this.debug("generated class = [%s]", generatedClassName);
        RoomCompanion companionAnnotation = typeElement.getAnnotation(RoomCompanion.class);
        if (companionAnnotation == null) {
            return null;
        }
        ClassName superType = null;
        RoomCompanion superRoomCompanion = null;
        TypeMirror superClass = typeElement.getSuperclass();
        if (superClass != null) {
            Element superElement = this.mTypesUtils.asElement(superClass);
            superRoomCompanion = superElement.getAnnotation(RoomCompanion.class);
            this.debug("super class annotation: %s", superRoomCompanion);
            if (superRoomCompanion != null) {
                String superTypePackage = this.getPackageNameOfTypeElement((TypeElement)superElement);
                String string = this.getTypeNameOfTypeElement((TypeElement)superElement);
                superType = ClassName.get((String)superTypePackage, (String)GeneratedNames.getDiffUtilName(string), (String[])new String[0]);
            }
        }
        if ((primaryKeys = companionAnnotation.primaryKeys()) == null || primaryKeys.length <= 0) {
            this.error("primary keys are not specified for [%s]", typeName);
            return null;
        }
        HashSet<String> primaryKeySet = new HashSet<String>();
        for (String key : primaryKeys) {
            primaryKeySet.add(key);
        }
        List<? extends Element> list = typeElement.getEnclosedElements();
        HashMap<String, TypeMirror> fields = new HashMap<String, TypeMirror>();
        HashMap<String, TypeMirror> primaryFields = new HashMap<String, TypeMirror>();
        for (Element element : list) {
            if (!(element instanceof VariableElement)) continue;
            this.debug("processing field: %s", element);
            VariableElement varElement = (VariableElement)element;
            String varName = varElement.getSimpleName().toString();
            TypeMirror fieldType = varElement.asType();
            if ("Companion".equals(varName)) {
                this.warn("skip [Companion] field ...", new Object[0]);
                continue;
            }
            if (varElement.getAnnotation(Ignore.class) != null) {
                this.warn("skip [Ignore] field ...", new Object[0]);
                continue;
            }
            fields.put(varName, fieldType);
            if (!primaryKeySet.contains(varName)) continue;
            primaryFields.put(varName, fieldType);
        }
        ClassName object = TypeNamesUtils.getObjectTypeName(packageName, typeName);
        TypeName typeName2 = TypeNamesUtils.getItemCallbackOfTypeName((TypeName)object);
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)generatedClassName).superclass(typeName2).addModifiers(new Modifier[]{Modifier.PUBLIC});
        MethodSpec.Builder methodItemsSameBuilder = MethodSpec.methodBuilder((String)"areItemsTheSame").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)object, "oldObject", new Modifier[0]).addParameter((TypeName)object, "newObject", new Modifier[0]).returns(TypeName.BOOLEAN);
        if (superType != null) {
            methodItemsSameBuilder.addStatement("return new $T().areItemsTheSame(oldObject, newObject) && $L", new Object[]{superType, this.buildFieldEqualsStatement(primaryFields)});
        } else {
            methodItemsSameBuilder.addStatement("return $L", new Object[]{this.buildFieldEqualsStatement(primaryFields)});
        }
        classBuilder.addMethod(methodItemsSameBuilder.build());
        MethodSpec.Builder methodContentsSameBuilder = MethodSpec.methodBuilder((String)"areContentsTheSame").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)object, "oldObject", new Modifier[0]).addParameter((TypeName)object, "newObject", new Modifier[0]).returns(TypeName.BOOLEAN);
        if (superType != null) {
            methodContentsSameBuilder.addStatement("return new $T().areContentsTheSame(oldObject, newObject) && $L", new Object[]{superType, this.buildFieldEqualsStatement(fields)});
        } else {
            methodContentsSameBuilder.addStatement("return $L", new Object[]{this.buildFieldEqualsStatement(fields)});
        }
        classBuilder.addMethod(methodContentsSameBuilder.build());
        return this.singleResult(packageName, classBuilder);
    }

    private String buildFieldEqualsStatement(Map<String, TypeMirror> fields) {
        if (fields == null || fields.size() <= 0) {
            return "true";
        }
        Set<String> keys = fields.keySet();
        StringBuilder builder = new StringBuilder();
        int N = keys.size();
        int i = 0;
        for (String fieldName : keys) {
            TypeMirror fieldType = fields.get(fieldName);
            if (fieldType.getKind().isPrimitive()) {
                builder.append("oldObject.get");
                builder.append(NameUtils.capitalizeName(fieldName));
                builder.append("() == ");
                builder.append("newObject.get");
                builder.append(NameUtils.capitalizeName(fieldName));
                builder.append("()");
            } else {
                builder.append("(");
                builder.append("oldObject.get");
                builder.append(NameUtils.capitalizeName(fieldName));
                builder.append("() == null");
                builder.append(" && ");
                builder.append("newObject.get");
                builder.append(NameUtils.capitalizeName(fieldName));
                builder.append("() == null");
                builder.append(" || ");
                builder.append("oldObject.get");
                builder.append(NameUtils.capitalizeName(fieldName));
                builder.append("() != null");
                builder.append(" && ");
                builder.append("newObject.get");
                builder.append(NameUtils.capitalizeName(fieldName));
                builder.append("() != null");
                builder.append(" && ");
                builder.append("oldObject.get");
                builder.append(NameUtils.capitalizeName(fieldName));
                builder.append("().equals(");
                builder.append("newObject.get");
                builder.append(NameUtils.capitalizeName(fieldName));
                builder.append("())");
                builder.append(")");
            }
            if (i < N - 1) {
                builder.append(" && ");
            }
            ++i;
        }
        return builder.toString();
    }
}

