/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.compiler.processor.roomcompanion.typeelementprocessor;

import com.dailystudio.devbricksx.annotations.DaoExtension;
import com.dailystudio.devbricksx.annotations.RoomCompanion;
import com.dailystudio.devbricksx.compiler.processor.AbsSingleTypeElementProcessor;
import com.dailystudio.devbricksx.compiler.processor.AbsTypeElementProcessor;
import com.dailystudio.devbricksx.compiler.processor.roomcompanion.FieldsHelper;
import com.dailystudio.devbricksx.compiler.processor.roomcompanion.GeneratedNames;
import com.dailystudio.devbricksx.compiler.processor.roomcompanion.TypeNamesUtils;
import com.dailystudio.devbricksx.compiler.utils.AnnotationsUtils;
import com.dailystudio.devbricksx.compiler.utils.NameUtils;
import com.dailystudio.devbricksx.compiler.utils.TextUtils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class RoomCompanionRepositoryClassProcessor
extends AbsSingleTypeElementProcessor {
    @Override
    protected List<AbsTypeElementProcessor.GeneratedResult> onProcess(TypeElement typeElement, String packageName, String typeName, RoundEnvironment roundEnv, Object preResults) {
        RoomCompanion companionAnnotation = typeElement.getAnnotation(RoomCompanion.class);
        if (companionAnnotation == null) {
            return null;
        }
        if (!companionAnnotation.repository()) {
            return null;
        }
        HashMap<String, TypeName> primaryKeyFields = new HashMap<String, TypeName>();
        FieldsHelper.collectPrimaryKeyFields(typeElement, primaryKeyFields, this.mTypesUtils);
        TypeElement daoExtensionElement = this.findDaoExtensionTypeElement(preResults, typeElement);
        this.debug("find daoExtension[%s] for element: %s", daoExtensionElement, typeElement);
        String targetPackage = GeneratedNames.getRoomCompanionRepositoryPackageName(packageName);
        ClassName generatedClassName = ClassName.get((String)targetPackage, (String)GeneratedNames.getRoomCompanionRepositoryName(typeName), (String[])new String[0]);
        this.debug("generated class = [%s]", generatedClassName);
        ClassName dao = ClassName.get((String)packageName, (String)GeneratedNames.getRoomCompanionDaoName(typeName), (String[])new String[0]);
        String daoFieldName = NameUtils.lowerCamelCaseName(dao.simpleName());
        ClassName object = TypeNamesUtils.getObjectTypeName(packageName, typeName);
        ClassName arrayList = ClassName.get((String)"java.util", (String)"ArrayList", (String[])new String[0]);
        TypeName liveDataOfObject = TypeNamesUtils.getLiveDataOfObjectTypeName(packageName, typeName);
        TypeName listOfObjects = TypeNamesUtils.getListOfObjectsTypeName(packageName, typeName);
        TypeName liveDataOfListOfObjects = TypeNamesUtils.getLiveDataOfListOfObjectsTypeName(packageName, typeName);
        TypeName liveDataOfPagedListOfObjects = TypeNamesUtils.getLiveDataOfPagedListOfObjectsTypeName(packageName, typeName);
        TypeName flowOfListOfObjects = TypeNamesUtils.getFlowOfListOfObjectsTypeName(packageName, typeName);
        TypeName pagingSourceOfObjects = TypeNamesUtils.getPagingSourceOfObjectsTypeName(packageName, typeName);
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)generatedClassName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        FieldSpec daoField = FieldSpec.builder((TypeName)dao, (String)daoFieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PROTECTED}).build();
        classBuilder.addField(daoField);
        MethodSpec constructorMethod = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)dao, daoFieldName, new Modifier[0]).addStatement("this.$N = $N", new Object[]{daoFieldName, daoFieldName}).build();
        classBuilder.addMethod(constructorMethod);
        String getOneMethodCallParameters = FieldsHelper.primaryKeyFieldsToFuncCallParameters(primaryKeyFields);
        MethodSpec.Builder methodGetOneBuilder = MethodSpec.methodBuilder((String)GeneratedNames.getRepositoryObjectMethodName(typeName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)object);
        FieldsHelper.primaryKeyFieldsToMethodParameters(methodGetOneBuilder, primaryKeyFields);
        methodGetOneBuilder.addStatement("return $N.getOne($N)", new Object[]{daoFieldName, getOneMethodCallParameters});
        classBuilder.addMethod(methodGetOneBuilder.build());
        MethodSpec.Builder methodGetOneLiveBuilder = MethodSpec.methodBuilder((String)GeneratedNames.getRepositoryObjectLiveMethodName(typeName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(liveDataOfObject);
        FieldsHelper.primaryKeyFieldsToMethodParameters(methodGetOneLiveBuilder, primaryKeyFields);
        methodGetOneLiveBuilder.addStatement("return $N.getOneLive($N)", new Object[]{daoFieldName, getOneMethodCallParameters});
        classBuilder.addMethod(methodGetOneLiveBuilder.build());
        MethodSpec.Builder methodGetAllBuilder = MethodSpec.methodBuilder((String)GeneratedNames.getRepositoryAllObjectsMethodName(typeName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(listOfObjects);
        methodGetAllBuilder.addStatement("return $N.getAll()", new Object[]{daoFieldName});
        classBuilder.addMethod(methodGetAllBuilder.build());
        MethodSpec.Builder methodGetAllLiveBuilder = MethodSpec.methodBuilder((String)GeneratedNames.getRepositoryAllObjectsLiveMethodName(typeName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(liveDataOfListOfObjects);
        methodGetAllLiveBuilder.addStatement("return $N.getAllLive()", new Object[]{daoFieldName});
        classBuilder.addMethod(methodGetAllLiveBuilder.build());
        MethodSpec.Builder methodGetAllLivePagedBuilder = MethodSpec.methodBuilder((String)GeneratedNames.getRepositoryAllObjectsPagedMethodName(typeName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(liveDataOfPagedListOfObjects);
        methodGetAllLivePagedBuilder.addStatement("return $N.getAllLivePaged()", new Object[]{daoFieldName});
        classBuilder.addMethod(methodGetAllLivePagedBuilder.build());
        MethodSpec.Builder methodGetAllFlowBuilder = MethodSpec.methodBuilder((String)GeneratedNames.getRepositoryAllObjectsFlowMethodName(typeName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(flowOfListOfObjects);
        methodGetAllFlowBuilder.addStatement("return $N.getAllFlow()", new Object[]{daoFieldName});
        classBuilder.addMethod(methodGetAllFlowBuilder.build());
        MethodSpec.Builder methodGetAllPagingSourceBuilder = MethodSpec.methodBuilder((String)GeneratedNames.getRepositoryAllObjectsPagingSourceMethodName(typeName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(pagingSourceOfObjects);
        methodGetAllPagingSourceBuilder.addStatement("return $N.getAllPagingSource()", new Object[]{daoFieldName});
        classBuilder.addMethod(methodGetAllPagingSourceBuilder.build());
        MethodSpec methodInsertOne = MethodSpec.methodBuilder((String)"insert").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)object, "object", new Modifier[0]).addStatement("return $N.insert(object)", new Object[]{daoFieldName}).returns(Long.class).build();
        classBuilder.addMethod(methodInsertOne);
        MethodSpec methodInsertAll = MethodSpec.methodBuilder((String)"insert").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(listOfObjects, "objects", new Modifier[0]).addStatement("return $N.insert(objects)", new Object[]{daoFieldName}).returns(TypeNamesUtils.getListOfTypeName(Long.class)).build();
        classBuilder.addMethod(methodInsertAll);
        MethodSpec methodUpdateOne = MethodSpec.methodBuilder((String)"update").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)object, "object", new Modifier[0]).addStatement("$N.update(object)", new Object[]{daoFieldName}).build();
        classBuilder.addMethod(methodUpdateOne);
        MethodSpec methodUpdateAll = MethodSpec.methodBuilder((String)"update").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(listOfObjects, "objects", new Modifier[0]).addStatement("$N.update(objects)", new Object[]{daoFieldName}).build();
        classBuilder.addMethod(methodUpdateAll);
        MethodSpec methodInsertOrUpdateOne = MethodSpec.methodBuilder((String)"insertOrUpdate").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)object, "object", new Modifier[0]).addStatement("$N.insertOrUpdate(object)", new Object[]{daoFieldName}).build();
        classBuilder.addMethod(methodInsertOrUpdateOne);
        MethodSpec methodInsertOrUpdateAll = MethodSpec.methodBuilder((String)"insertOrUpdate").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(listOfObjects, "objects", new Modifier[0]).addStatement("$N.insertOrUpdate(objects)", new Object[]{daoFieldName}).build();
        classBuilder.addMethod(methodInsertOrUpdateAll);
        MethodSpec methodDelete = MethodSpec.methodBuilder((String)"delete").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)object, "object", new Modifier[0]).addStatement("$N.delete(object)", new Object[]{daoFieldName}).build();
        classBuilder.addMethod(methodDelete);
        this.attachExtendMethods(packageName, typeName, daoExtensionElement, classBuilder);
        return this.singleResult(targetPackage, classBuilder);
    }

    private void attachExtendMethods(String objectPackage, String objectTypeName, TypeElement daoExtensionElement, TypeSpec.Builder classBuilder) {
        if (daoExtensionElement == null) {
            return;
        }
        DaoExtension daoExtension = daoExtensionElement.getAnnotation(DaoExtension.class);
        if (daoExtension == null) {
            return;
        }
        List<? extends Element> subElements = daoExtensionElement.getEnclosedElements();
        for (Element element : subElements) {
            if (!(element instanceof ExecutableElement)) continue;
            this.debug("processing method: %s", element);
            if ("<init>".equals(element.getSimpleName().toString())) {
                this.debug("constructor method, skip", new Object[0]);
                continue;
            }
            ExecutableElement executableElement = (ExecutableElement)element;
            this.handleMethod(objectPackage, objectTypeName, executableElement, classBuilder);
        }
    }

    private void handleMethod(String objectPackage, String objectTypeName, ExecutableElement executableElement, TypeSpec.Builder classBuilder) {
        String daoFieldName = NameUtils.lowerCamelCaseName(GeneratedNames.getRoomCompanionDaoName(objectTypeName));
        String methodName = executableElement.getSimpleName().toString();
        TypeName returnTypeName = TypeName.get((TypeMirror)executableElement.getReturnType());
        boolean hasReturn = !TypeNamesUtils.isTypeNameVoid(returnTypeName);
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(returnTypeName);
        StringBuilder parametersBuilder = new StringBuilder();
        List<? extends VariableElement> parameters = executableElement.getParameters();
        if (parameters != null && parameters.size() > 0) {
            int N = parameters.size();
            for (int i = 0; i < N; ++i) {
                VariableElement param = parameters.get(i);
                String paramName = param.getSimpleName().toString();
                methodSpecBuilder.addParameter(TypeName.get((TypeMirror)param.asType()), paramName, new Modifier[0]);
                parametersBuilder.append(paramName);
                if (i >= N - 1) continue;
                parametersBuilder.append(", ");
            }
        }
        String methodParameters = parametersBuilder.toString();
        if (hasReturn) {
            if (!TextUtils.isEmpty(methodParameters)) {
                methodSpecBuilder.addStatement("return $N.$N($N)", new Object[]{daoFieldName, methodName, methodParameters});
            } else {
                methodSpecBuilder.addStatement("return $N.$N()", new Object[]{daoFieldName, methodName});
            }
        } else if (!TextUtils.isEmpty(methodParameters)) {
            methodSpecBuilder.addStatement("$N.$N($N)", new Object[]{daoFieldName, methodName, methodParameters});
        } else {
            methodSpecBuilder.addStatement("$N.$N()", new Object[]{daoFieldName, methodName});
        }
        classBuilder.addMethod(methodSpecBuilder.build());
    }

    private TypeElement findDaoExtensionTypeElement(Object preResults, TypeElement targetElement) {
        if (!(preResults instanceof Map)) {
            return null;
        }
        Map typeElementsMap = (Map)preResults;
        List typeElements = (List)typeElementsMap.get(DaoExtension.class);
        if (typeElements == null || typeElements.size() <= 0) {
            return null;
        }
        for (TypeElement typeElement : typeElements) {
            ClassName entityClass = AnnotationsUtils.getClassValueFromAnnotation(typeElement, "entity");
            if (!entityClass.equals((Object)ClassName.get((TypeElement)targetElement))) continue;
            return typeElement;
        }
        return null;
    }

    private boolean isTypeNameOfList(TypeName typeName) {
        return typeName.toString().contains("java.util.List<");
    }

    private boolean isTypeNameVoid(TypeName typeName) {
        return TypeNamesUtils.getVoidTypeName().equals((Object)typeName);
    }
}

