/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.compiler.utils;

import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;

public class LogUtils {
    private static final boolean DEBUG = false;
    private static final String UNKNOWN_METHOD = "UnknownMethod";
    private static final String UNKNOWN_CLASS = "UnknownClass";
    private static final String UNKNOWN_TAG = "Unknown";
    private static final int TRACE_BASE_INDEX = 3;
    private static final String OUTPUT_MESSAGE_TEMPLATE = "%s.%s(): %s\n";

    public static void debug(Messager messager, String format, Object ... args) {
        if (messager == null) {
            return;
        }
    }

    public static void info(Messager messager, String format, Object ... args) {
        if (messager == null) {
            return;
        }
        LogUtils.output(messager, Diagnostic.Kind.NOTE, String.format(format, args), new Object[0]);
    }

    public static void warn(Messager messager, String format, Object ... args) {
        if (messager == null) {
            return;
        }
        LogUtils.output(messager, Diagnostic.Kind.WARNING, String.format(format, args), new Object[0]);
    }

    public static void error(Messager messager, String format, Object ... args) {
        if (messager == null) {
            return;
        }
        LogUtils.output(messager, Diagnostic.Kind.ERROR, String.format(format, args), new Object[0]);
    }

    private static void output(Messager messager, Diagnostic.Kind kind, String format, Object ... args) {
        String tag = LogUtils.getCallingSimpleClassName(2);
        if (tag == null || tag.length() <= 0) {
            tag = UNKNOWN_TAG;
        }
        String compose = String.format(OUTPUT_MESSAGE_TEMPLATE, tag, LogUtils.getCallingMethodName(2), format);
        if (kind == Diagnostic.Kind.OTHER) {
            System.out.print(String.format(compose, args));
        } else {
            messager.printMessage(kind, String.format(compose, args));
        }
    }

    public static StackTraceElement getCallingElement(int traceLevel) {
        if (traceLevel < 0) {
            return null;
        }
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (elements == null) {
            return null;
        }
        int length = elements.length;
        if (3 + traceLevel >= length) {
            return null;
        }
        return elements[3 + traceLevel];
    }

    public static String getCallingMethodName() {
        return LogUtils.getCallingMethodName(1);
    }

    public static String getCallingMethodName(int traceLevel) {
        StackTraceElement element = LogUtils.getCallingElement(traceLevel + 1);
        if (element == null) {
            return UNKNOWN_METHOD;
        }
        return element.getMethodName();
    }

    public static String getCallingClassName() {
        return LogUtils.getCallingClassName(1);
    }

    public static String getCallingSimpleClassName() {
        return LogUtils.getCallingSimpleClassName(1);
    }

    public static String getCallingSimpleClassName(int traceLevel) {
        String className = LogUtils.getCallingClassName(traceLevel + 1);
        if (className == null) {
            return UNKNOWN_CLASS;
        }
        Class<?> kls = null;
        try {
            kls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            kls = null;
        }
        if (kls == null) {
            return UNKNOWN_CLASS;
        }
        return kls.getSimpleName();
    }

    public static String getCallingClassName(int traceLevel) {
        StackTraceElement element = LogUtils.getCallingElement(traceLevel + 1);
        if (element == null) {
            return UNKNOWN_CLASS;
        }
        return element.getClassName();
    }
}

