/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.compiler.kotlin;

import com.dailystudio.devbricksx.annotations.InMemoryRepository;
import com.dailystudio.devbricksx.compiler.kotlin.BaseProcessor;
import com.dailystudio.devbricksx.compiler.kotlin.GeneratedNames;
import com.dailystudio.devbricksx.compiler.kotlin.GeneratedResult;
import com.dailystudio.devbricksx.compiler.kotlin.utils.AnnotationsUtils;
import com.dailystudio.devbricksx.compiler.kotlin.utils.TypeNamesUtils;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/dailystudio/devbricksx/compiler/kotlin/InMemoryRepositoryProcessor;", "Lcom/dailystudio/devbricksx/compiler/kotlin/BaseProcessor;", "()V", "generateInMemoryRepository", "Lcom/dailystudio/devbricksx/compiler/kotlin/GeneratedResult;", "element", "Ljavax/lang/model/element/TypeElement;", "getSupportedAnnotationTypes", "", "", "process", "", "annotations", "roundEnv", "Ljavax/annotation/processing/RoundEnvironment;", "devbricksx-kotlin-compiler"})
public final class InMemoryRepositoryProcessor
extends BaseProcessor {
    @Override
    @NotNull
    public Set<String> getSupportedAnnotationTypes() {
        Object[] objectArray = new String[1];
        String string = InMemoryRepository.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"InMemoryRepository::class.java.name");
        objectArray[0] = string;
        return SetsKt.mutableSetOf((Object[])objectArray);
    }

    @Override
    public boolean process(@Nullable Set<? extends TypeElement> annotations, @NotNull RoundEnvironment roundEnv) {
        Intrinsics.checkNotNullParameter((Object)roundEnv, (String)"roundEnv");
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(InMemoryRepository.class);
        Intrinsics.checkNotNullExpressionValue(set, (String)"roundEnv.getElementsAnnotatedWith(InMemoryRepository::class.java)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GeneratedResult result;
            GeneratedResult generatedResult;
            Element element = (Element)element$iv;
            boolean bl = false;
            if (element.getKind() != ElementKind.CLASS) {
                this.error("Only classes can be annotated", new Object[0]);
                return true;
            }
            if (!(element instanceof TypeElement) || (generatedResult = (result = this.generateInMemoryRepository((TypeElement)element))) == null) continue;
            GeneratedResult generatedResult2 = generatedResult;
            boolean bl2 = false;
            boolean bl3 = false;
            GeneratedResult it = generatedResult2;
            boolean bl4 = false;
            this.writeToFile(it);
        }
        return true;
    }

    private final GeneratedResult generateInMemoryRepository(TypeElement element) {
        String typeName = element.getSimpleName().toString();
        String packageName = this.processingEnv.getElementUtils().getPackageOf(element).toString();
        InMemoryRepository annotation = element.getAnnotation(InMemoryRepository.class);
        int pageSize = annotation.pageSize();
        ClassName className = AnnotationsUtils.Companion.getClassValueFromAnnotation(element, "key");
        if (className == null) {
            return null;
        }
        ClassName key = className;
        String generatedClassName = GeneratedNames.Companion.getRepositoryName(typeName);
        String[] stringArray = new String[]{typeName};
        ClassName objectTypeName = new ClassName(packageName, stringArray);
        TypeName repositoryTypeName = TypeNamesUtils.Companion.getObjectRepositoryOfTypeName(TypeNamesUtils.Companion.javaToKotlinTypeName((TypeName)key), (TypeName)objectTypeName);
        String[] stringArray2 = new String[]{GeneratedNames.Companion.getManagerName(typeName)};
        ClassName managerTypeName = new ClassName(packageName, stringArray2);
        Object[] objectArray = new Object[]{managerTypeName};
        TypeSpec.Builder builder = TypeSpec.Companion.classBuilder(generatedClassName).superclass(repositoryTypeName).addSuperclassConstructorParameter("%T", objectArray);
        objectArray = new Object[]{pageSize};
        TypeSpec.Builder builder2 = builder.addSuperclassConstructorParameter("%L", objectArray);
        objectArray = new KModifier[]{KModifier.OPEN};
        TypeSpec.Builder classBuilder = builder2.addModifiers((KModifier[])objectArray);
        return new GeneratedResult(GeneratedNames.Companion.getRepositoryPackageName(packageName), classBuilder);
    }
}

