/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.compiler.kotlin;

import com.dailystudio.devbricksx.annotations.PreferenceValue;
import com.dailystudio.devbricksx.annotations.SharedPreference;
import com.dailystudio.devbricksx.compiler.kotlin.BaseProcessor;
import com.dailystudio.devbricksx.compiler.kotlin.GeneratedNames;
import com.dailystudio.devbricksx.compiler.kotlin.GeneratedResult;
import com.dailystudio.devbricksx.compiler.kotlin.utils.NameUtilsKt;
import com.dailystudio.devbricksx.compiler.kotlin.utils.TypeNamesUtils;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/dailystudio/devbricksx/compiler/kotlin/SharedPreferenceProcessor;", "Lcom/dailystudio/devbricksx/compiler/kotlin/BaseProcessor;", "()V", "generateSharedPreference", "Lcom/dailystudio/devbricksx/compiler/kotlin/GeneratedResult;", "element", "Ljavax/lang/model/element/TypeElement;", "getSupportedAnnotationTypes", "", "", "process", "", "annotations", "roundEnv", "Ljavax/annotation/processing/RoundEnvironment;", "devbricksx-kotlin-compiler"})
public final class SharedPreferenceProcessor
extends BaseProcessor {
    @Override
    @NotNull
    public Set<String> getSupportedAnnotationTypes() {
        Object[] objectArray = new String[1];
        String string = SharedPreference.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SharedPreference::class.java.name");
        objectArray[0] = string;
        return SetsKt.mutableSetOf((Object[])objectArray);
    }

    @Override
    public boolean process(@Nullable Set<? extends TypeElement> annotations, @NotNull RoundEnvironment roundEnv) {
        Intrinsics.checkNotNullParameter((Object)roundEnv, (String)"roundEnv");
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(SharedPreference.class);
        Intrinsics.checkNotNullExpressionValue(set, (String)"roundEnv.getElementsAnnotatedWith(SharedPreference::class.java)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GeneratedResult result;
            GeneratedResult generatedResult;
            Element element = (Element)element$iv;
            boolean bl = false;
            if (element.getKind() != ElementKind.CLASS) {
                this.error("Only classes can be annotated", new Object[0]);
                return true;
            }
            if (!(element instanceof TypeElement) || (generatedResult = (result = this.generateSharedPreference((TypeElement)element))) == null) continue;
            GeneratedResult generatedResult2 = generatedResult;
            boolean bl2 = false;
            boolean bl3 = false;
            GeneratedResult it = generatedResult2;
            boolean bl4 = false;
            this.writeToFile(it);
        }
        return true;
    }

    private final GeneratedResult generateSharedPreference(TypeElement element) {
        TypeName typeName;
        Object superTypeName;
        String typeName2 = element.getSimpleName().toString();
        String packageName = this.processingEnv.getElementUtils().getPackageOf(element).toString();
        String generatedClassName = GeneratedNames.Companion.getSharedPrefsName(typeName2);
        String[] stringArray = new String[]{generatedClassName};
        ClassName generatedTypeName = new ClassName(packageName, stringArray);
        String[] stringArray2 = new String[]{typeName2};
        ClassName objectTypeName = new ClassName(packageName, stringArray2);
        String prefName = NameUtilsKt.kebabCaseName(typeName2);
        TypeName absPrefsTypeName = TypeNamesUtils.Companion.getAbsPrefsTypeName();
        TypeName globalContextWrapperTypeName = TypeNamesUtils.Companion.getGlobalContextWrapperTypeName();
        ClassName booleanTypeName = TypeNamesUtils.Companion.getBooleanTypeName();
        ClassName floatTypeName = TypeNamesUtils.Companion.getFloatTypeName();
        ClassName longTypeName = TypeNamesUtils.Companion.getLongTypeName();
        ClassName integerTypeName = TypeNamesUtils.Companion.getIntegerTypeName();
        ClassName stringTypeName = TypeNamesUtils.Companion.getStringTypeName();
        TypeMirror typeMirror = element.getSuperclass();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"element.superclass");
        TypeMirror superClass = typeMirror;
        Object[] objectArray = this.processingEnv.getTypeUtils().asElement(superClass);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"processingEnv.typeUtils.asElement(superClass)");
        Object[] superElement = objectArray;
        objectArray = new Object[]{element, superElement};
        this.debug("[element: %s] super class: %s", objectArray);
        SharedPreference superSharePrefs = superElement.getAnnotation(SharedPreference.class);
        Object[] objectArray2 = new Object[]{element, superSharePrefs};
        this.debug("[element: %s] super class annotation: %s", objectArray2);
        if (superSharePrefs != null) {
            String superTypePackage = this.processingEnv.getElementUtils().getPackageOf((Element)superElement).toString();
            superTypeName = superElement.getSimpleName().toString();
            String[] stringArray3 = new String[]{GeneratedNames.Companion.getSharedPrefsName((String)superTypeName)};
            typeName = (TypeName)new ClassName(superTypePackage, stringArray3);
        } else {
            typeName = absPrefsTypeName;
        }
        TypeName superType = typeName;
        superTypeName = new KModifier[]{KModifier.OPEN};
        TypeSpec.Builder classBuilder = TypeSpec.Companion.classBuilder(generatedClassName).superclass(superType).addModifiers(superTypeName);
        TypeSpec.Builder compObjBuilder = TypeSpec.Companion.companionObjectBuilder$default((TypeSpec.Companion)TypeSpec.Companion, null, (int)1, null);
        Object[] objectArray3 = new KModifier[]{KModifier.OVERRIDE};
        PropertySpec.Builder builder = PropertySpec.Companion.builder("prefName", Reflection.getOrCreateKotlinClass(String.class), new KModifier[0]).addModifiers((KModifier[])objectArray3);
        objectArray3 = new Object[]{prefName};
        PropertySpec.Builder prefNameFieldBuilder = builder.initializer("%S", objectArray3);
        Object[] objectArray4 = new Object[]{generatedTypeName};
        PropertySpec.Builder instanceFieldBuilder = PropertySpec.Companion.builder("instance", (TypeName)generatedTypeName, new KModifier[0]).initializer("%T()", objectArray4);
        compObjBuilder.addProperty(instanceFieldBuilder.build());
        List<? extends Element> list = element.getEnclosedElements();
        Intrinsics.checkNotNullExpressionValue(list, (String)"element.enclosedElements");
        List<? extends Element> subElements = list;
        for (Element element2 : subElements) {
            Object[] objectArray5;
            boolean bl;
            Object[] objectArray6;
            PreferenceValue preferenceValue;
            if (!(element2 instanceof VariableElement) || (preferenceValue = ((VariableElement)element2).getAnnotation(PreferenceValue.class)) == null) continue;
            PreferenceValue defValAnnotation = preferenceValue;
            Object[] defValStr = defValAnnotation.defaultValueStr();
            Object[] objectArray7 = new Object[3];
            objectArray7[0] = element2;
            TypeMirror typeMirror2 = ((VariableElement)element2).asType();
            Intrinsics.checkNotNullExpressionValue((Object)typeMirror2, (String)"subElement.asType()");
            objectArray7[1] = TypeNames.get((TypeMirror)typeMirror2);
            objectArray7[2] = defValStr;
            this.debug("processing field: %s[%s], default value: [str = %s]", objectArray7);
            String varName = ((VariableElement)element2).getSimpleName().toString();
            String keyName = NameUtilsKt.kebabCaseName(varName);
            String prefKeyName = GeneratedNames.Companion.getPreferenceKeyName(varName);
            TypeMirror typeMirror3 = ((VariableElement)element2).asType();
            Intrinsics.checkNotNullExpressionValue((Object)typeMirror3, (String)"subElement.asType()");
            TypeMirror fieldType = typeMirror3;
            Object[] objectArray8 = new KModifier[]{KModifier.CONST};
            PropertySpec.Builder builder2 = PropertySpec.Companion.builder(prefKeyName, Reflection.getOrCreateKotlinClass(String.class), new KModifier[0]).addModifiers((KModifier[])objectArray8);
            objectArray8 = new Object[]{keyName};
            PropertySpec.Builder prefNameConstant = builder2.initializer("%S", objectArray8);
            compObjBuilder.addProperty(prefNameConstant.build());
            boolean nullable = ((VariableElement)element2).getAnnotation(Nullable.class) != null;
            PropertySpec.Builder propBuilder = PropertySpec.Builder.mutable$default((PropertySpec.Builder)PropertySpec.Companion.builder(varName, TypeName.copy$default((TypeName)TypeNamesUtils.Companion.javaToKotlinTypeName(TypeNames.get((TypeMirror)fieldType)), (boolean)nullable, null, (int)2, null), new KModifier[0]), (boolean)false, (int)1, null);
            FunSpec.Builder getterBuilder = FunSpec.Companion.getterBuilder();
            FunSpec.Builder setterBuilder = FunSpec.Companion.setterBuilder();
            CodeBlock.Builder initializerBuilder = CodeBlock.Companion.builder();
            TypeName typeName3 = TypeNamesUtils.Companion.javaToKotlinTypeName(TypeNames.get((TypeMirror)fieldType));
            if (Intrinsics.areEqual((Object)typeName3, (Object)booleanTypeName)) {
                objectArray6 = defValStr;
                bl = false;
                boolean defaultVal = Boolean.parseBoolean((String)objectArray6);
                objectArray6 = new Object[]{defaultVal};
                getterBuilder.addStatement("val defaultVal = %L", objectArray6);
                objectArray6 = new Object[]{globalContextWrapperTypeName};
                getterBuilder.addStatement("val context = %L.context ?: return defaultVal", objectArray6);
                objectArray6 = new Object[]{keyName};
                getterBuilder.addStatement("return getBooleanPrefValue(context, %S, defaultVal)", objectArray6);
                setterBuilder.addParameter("value", (TypeName)booleanTypeName, new KModifier[0]);
                setterBuilder.addStatement("field = value", new Object[0]);
                objectArray6 = new Object[]{globalContextWrapperTypeName};
                setterBuilder.addStatement("val context = %L.context ?: return", objectArray6);
                objectArray6 = new Object[]{keyName};
                setterBuilder.addStatement("setBooleanPrefValue(context, %S, value)", objectArray6);
                objectArray6 = new Object[]{defaultVal};
                initializerBuilder.addStatement("%L", objectArray6);
            } else if (Intrinsics.areEqual((Object)typeName3, (Object)integerTypeName)) {
                int n;
                try {
                    objectArray6 = defValStr;
                    bl = false;
                    n = Integer.parseInt((String)objectArray6);
                }
                catch (NumberFormatException e342) {
                    objectArray5 = new Object[]{defValStr, e342};
                    this.error("failed to parse default int value from [%s]: %s", objectArray5);
                    n = 0;
                }
                int defaultVal = n;
                objectArray6 = new Object[]{defaultVal};
                getterBuilder.addStatement("val defaultVal = %L.toInt()", objectArray6);
                objectArray6 = new Object[]{globalContextWrapperTypeName};
                getterBuilder.addStatement("val context = %L.context ?: return defaultVal", objectArray6);
                objectArray6 = new Object[]{keyName};
                getterBuilder.addStatement("return getIntegerPrefValue(context, %S, defaultVal)", objectArray6);
                setterBuilder.addParameter("value", (TypeName)floatTypeName, new KModifier[0]);
                setterBuilder.addStatement("field = value", new Object[0]);
                objectArray6 = new Object[]{globalContextWrapperTypeName};
                setterBuilder.addStatement("val context = %L.context ?: return", objectArray6);
                objectArray6 = new Object[]{keyName};
                setterBuilder.addStatement("setIntegerPrefValue(context, %S, value)", objectArray6);
                objectArray6 = new Object[]{defaultVal};
                initializerBuilder.addStatement("%L.toInt()", objectArray6);
            } else if (Intrinsics.areEqual((Object)typeName3, (Object)longTypeName)) {
                long e342;
                try {
                    Object[] e342 = defValStr;
                    boolean bl2 = false;
                    e342 = Long.parseLong((String)e342);
                }
                catch (NumberFormatException e) {
                    Object[] objectArray9 = new Object[]{defValStr, e};
                    this.error("failed to parse default long value from [%s]: %s", objectArray9);
                    e342 = 0L;
                }
                long defaultVal = e342;
                Object[] e342 = new Object[]{defaultVal};
                getterBuilder.addStatement("val defaultVal = %L.toLong()", e342);
                e342 = new Object[]{globalContextWrapperTypeName};
                getterBuilder.addStatement("val context = %L.context ?: return defaultVal", e342);
                e342 = new Object[]{keyName};
                getterBuilder.addStatement("return getLongPrefValue(context, %S, defaultVal)", e342);
                setterBuilder.addParameter("value", (TypeName)floatTypeName, new KModifier[0]);
                setterBuilder.addStatement("field = value", new Object[0]);
                e342 = new Object[]{globalContextWrapperTypeName};
                setterBuilder.addStatement("val context = %L.context ?: return", e342);
                e342 = new Object[]{keyName};
                setterBuilder.addStatement("setLongPrefValue(context, %S, value)", e342);
                e342 = new Object[]{defaultVal};
                initializerBuilder.addStatement("%L.toLong()", e342);
            } else if (Intrinsics.areEqual((Object)typeName3, (Object)floatTypeName)) {
                float f;
                try {
                    objectArray6 = defValStr;
                    boolean e342 = false;
                    f = Float.parseFloat((String)objectArray6);
                }
                catch (NumberFormatException e) {
                    objectArray5 = new Object[]{defValStr, e};
                    this.error("failed to parse default float value from [%s]: %s", objectArray5);
                    f = 0.0f;
                }
                float defaultVal = f;
                objectArray6 = new Object[]{Float.valueOf(defaultVal)};
                getterBuilder.addStatement("val defaultVal = %L.toFloat()", objectArray6);
                objectArray6 = new Object[]{globalContextWrapperTypeName};
                getterBuilder.addStatement("val context = %L.context ?: return defaultVal", objectArray6);
                objectArray6 = new Object[]{keyName};
                getterBuilder.addStatement("return getFloatPrefValue(context, %S, defaultVal)", objectArray6);
                setterBuilder.addParameter("value", (TypeName)floatTypeName, new KModifier[0]);
                setterBuilder.addStatement("field = value", new Object[0]);
                objectArray6 = new Object[]{globalContextWrapperTypeName};
                setterBuilder.addStatement("val context = %L.context ?: return", objectArray6);
                objectArray6 = new Object[]{keyName};
                setterBuilder.addStatement("setFloatPrefValue(context, %S, value)", objectArray6);
                objectArray6 = new Object[]{Float.valueOf(defaultVal)};
                initializerBuilder.addStatement("%L.toFloat()", objectArray6);
            } else if (Intrinsics.areEqual((Object)typeName3, (Object)stringTypeName)) {
                Object[] defaultVal = defValStr;
                objectArray6 = new Object[]{defaultVal};
                getterBuilder.addStatement("val defaultVal = %S", objectArray6);
                objectArray6 = new Object[]{globalContextWrapperTypeName};
                getterBuilder.addStatement("val context = %L.context ?: return defaultVal", objectArray6);
                objectArray6 = new Object[]{keyName};
                getterBuilder.addStatement("return getStringPrefValue(context, %S) ?: defaultVal", objectArray6);
                setterBuilder.addParameter("value", (TypeName)stringTypeName, new KModifier[0]);
                setterBuilder.addStatement("field = value", new Object[0]);
                objectArray6 = new Object[]{globalContextWrapperTypeName};
                setterBuilder.addStatement("val context = %L.context ?: return", objectArray6);
                objectArray6 = new Object[]{keyName};
                setterBuilder.addStatement("setStringPrefValue(context, %S, value)", objectArray6);
                objectArray6 = new Object[]{defaultVal};
                initializerBuilder.addStatement("%S", objectArray6);
            }
            propBuilder.getter(getterBuilder.build());
            propBuilder.setter(setterBuilder.build());
            propBuilder.initializer(initializerBuilder.build());
            classBuilder.addProperty(propBuilder.build());
        }
        classBuilder.addType(compObjBuilder.build());
        classBuilder.addProperty(prefNameFieldBuilder.build());
        return new GeneratedResult(packageName, classBuilder);
    }
}

