/*
 * Decompiled with CFR 0.152.
 */
package com.dailystudio.devbricksx.compiler.kotlin.utils;

import com.dailystudio.devbricksx.annotations.RoomCompanion;
import com.dailystudio.devbricksx.compiler.kotlin.utils.KotlinTypesUtils;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u00020\u000b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\u0010J\"\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\u0010\u00a8\u0006\u0014"}, d2={"Lcom/dailystudio/devbricksx/compiler/kotlin/utils/FieldsUtils;", "", "()V", "collectPrimaryKeyFields", "", "element", "Ljavax/lang/model/element/Element;", "objectTypeName", "Lcom/squareup/kotlinpoet/TypeName;", "fields", "", "", "typeUtils", "Ljavax/lang/model/util/Types;", "primaryKeyFieldsToFuncCallParameters", "primaryKeyFields", "", "primaryKeyFieldsToMethodParameters", "methodBuilder", "Lcom/squareup/kotlinpoet/FunSpec$Builder;", "devbricksx-kotlin-compiler"})
public final class FieldsUtils {
    @NotNull
    public static final FieldsUtils INSTANCE = new FieldsUtils();

    private FieldsUtils() {
    }

    public final void collectPrimaryKeyFields(@NotNull Element element, @NotNull TypeName objectTypeName, @NotNull Map<String, TypeName> fields, @NotNull Types typeUtils) {
        String[] primaryKeys;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)objectTypeName, (String)"objectTypeName");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter((Object)typeUtils, (String)"typeUtils");
        if (!(element instanceof TypeElement)) {
            return;
        }
        RoomCompanion roomCompanion = element.getAnnotation(RoomCompanion.class);
        if (roomCompanion == null) {
            return;
        }
        RoomCompanion companionAnnotation = roomCompanion;
        String[] stringArray = primaryKeys = companionAnnotation.primaryKeys();
        boolean bl = false;
        if (stringArray.length == 0) {
            return;
        }
        bl = false;
        Set primaryKeySet = new LinkedHashSet();
        for (String object : primaryKeys) {
            primaryKeySet.add(object);
        }
        List<? extends Element> subElements = ((TypeElement)element).getEnclosedElements();
        VariableElement varElement = null;
        for (Element element2 : subElements) {
            if (!(element2 instanceof VariableElement)) continue;
            varElement = (VariableElement)element2;
            String varName = varElement.getSimpleName().toString();
            TypeMirror fieldType = varElement.asType();
            if (!primaryKeySet.contains(varName)) continue;
            Map<String, TypeName> map = fields;
            Intrinsics.checkNotNullExpressionValue((Object)fieldType, (String)"fieldType");
            TypeName typeName = KotlinTypesUtils.INSTANCE.javaToKotlinTypeName(objectTypeName, TypeNames.get((TypeMirror)fieldType));
            boolean bl2 = false;
            map.put(varName, typeName);
        }
        TypeMirror superClass = ((TypeElement)element).getSuperclass();
        String string = Intrinsics.stringPlus((String)"superClass: ", (Object)superClass);
        boolean bl3 = false;
        System.out.print((Object)string);
        if (superClass != null) {
            Element element3 = typeUtils.asElement(superClass);
            Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"typeUtils.asElement(superClass)");
            this.collectPrimaryKeyFields(element3, objectTypeName, fields, typeUtils);
        }
    }

    public final void primaryKeyFieldsToMethodParameters(@NotNull FunSpec.Builder methodBuilder, @NotNull Map<String, ? extends TypeName> primaryKeyFields) {
        Intrinsics.checkNotNullParameter((Object)methodBuilder, (String)"methodBuilder");
        Intrinsics.checkNotNullParameter(primaryKeyFields, (String)"primaryKeyFields");
        Object object = primaryKeyFields;
        boolean bl = false;
        Iterator<Map.Entry<String, ? extends TypeName>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String filedName = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            TypeName fieldType = (TypeName)object3.getValue();
            methodBuilder.addParameter(filedName, fieldType, new KModifier[0]);
        }
    }

    @NotNull
    public final String primaryKeyFieldsToFuncCallParameters(@NotNull Map<String, ? extends TypeName> primaryKeyFields) {
        Intrinsics.checkNotNullParameter(primaryKeyFields, (String)"primaryKeyFields");
        Collection $this$toTypedArray$iv = primaryKeyFields.keySet();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] keys = stringArray;
        StringBuilder builder = new StringBuilder();
        String filedName = null;
        int n = 0;
        int n2 = keys.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                filedName = keys[i];
                builder.append(filedName);
                if (i >= keys.length - 1) continue;
                builder.append(",");
            } while (n <= n2);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }
}

