/*
 * Decompiled with CFR 0.152.
 */
package cn.daimax.framework.jackson.config;

import cn.daimax.framework.common.util.json.JsonUtils;
import cn.daimax.framework.jackson.core.databind.LocalDateTimeDeserializer;
import cn.daimax.framework.jackson.core.databind.LocalDateTimeSerializer;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DmxJacksonAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DmxJacksonAutoConfiguration.class);

    @Bean
    public BeanPostProcessor objectMapperBeanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (!(bean instanceof ObjectMapper)) {
                    return bean;
                }
                ObjectMapper objectMapper = (ObjectMapper)bean;
                SimpleModule simpleModule = new SimpleModule();
                simpleModule.addSerializer(LocalDateTime.class, (JsonSerializer)LocalDateTimeSerializer.INSTANCE).addDeserializer(LocalDateTime.class, (JsonDeserializer)LocalDateTimeDeserializer.INSTANCE);
                objectMapper.registerModules(new Module[]{simpleModule});
                JsonUtils.init((ObjectMapper)objectMapper);
                log.info("\u521d\u59cb\u5316 jackson \u81ea\u52a8\u914d\u7f6e");
                return bean;
            }
        };
    }
}

