/*
 * Decompiled with CFR 0.152.
 */
package cn.daimax.framework.web.config;

import cn.daimax.framework.satoken.core.router.IgnoreSaRouter;
import cn.daimax.framework.web.config.WebProperties;
import cn.daimax.framework.web.config.XssProperties;
import cn.daimax.framework.web.core.filter.CacheRequestBodyFilter;
import cn.daimax.framework.web.core.filter.XssFilter;
import cn.daimax.framework.web.core.handler.GlobalExceptionHandler;
import cn.daimax.framework.web.core.handler.GlobalResponseBodyHandler;
import cn.dev33.satoken.fun.SaFunction;
import cn.dev33.satoken.interceptor.SaAnnotationInterceptor;
import cn.dev33.satoken.interceptor.SaRouteInterceptor;
import cn.dev33.satoken.router.SaRouter;
import javax.annotation.Resource;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={WebProperties.class, XssProperties.class})
public class DmxWebAutoConfiguration
implements WebMvcConfigurer {
    @Resource
    private WebProperties webProperties;
    @Resource
    private XssProperties xssProperties;
    @Value(value="${spring.application.name}")
    private String applicationName;

    public void configurePathMatch(PathMatchConfigurer configurer) {
        this.configurePathMatch(configurer, this.webProperties.getAdminApi());
        this.configurePathMatch(configurer, this.webProperties.getAppApi());
    }

    private void configurePathMatch(PathMatchConfigurer configurer, WebProperties.Api api) {
        AntPathMatcher antPathMatcher = new AntPathMatcher(".");
        configurer.addPathPrefix(api.getPrefix(), clazz -> clazz.isAnnotationPresent(RestController.class) && antPathMatcher.match(api.getController(), clazz.getPackage().getName()));
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new SaAnnotationInterceptor()).addPathPatterns(new String[]{"/**"});
        registry.addInterceptor((HandlerInterceptor)new SaRouteInterceptor((req, res, handler) -> SaRouter.match((String)"/**", (SaFunction)new IgnoreSaRouter(handler)))).addPathPatterns(new String[]{"/**"}).excludePathPatterns(this.xssProperties.getExcludeUrls());
    }

    @Bean
    public GlobalExceptionHandler globalExceptionHandler() {
        return new GlobalExceptionHandler();
    }

    @Bean
    public GlobalResponseBodyHandler globalResponseBodyHandler() {
        return new GlobalResponseBodyHandler();
    }

    @Bean
    public FilterRegistrationBean<CorsFilter> corsFilterBean() {
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedOriginPattern("*");
        config.addAllowedHeader("*");
        config.addAllowedMethod("*");
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", config);
        return DmxWebAutoConfiguration.createFilterBean(new CorsFilter((CorsConfigurationSource)source), Integer.MIN_VALUE);
    }

    @Bean
    public FilterRegistrationBean<XssFilter> xssFilter(XssProperties properties, PathMatcher pathMatcher) {
        return DmxWebAutoConfiguration.createFilterBean(new XssFilter(properties, pathMatcher), -102);
    }

    @Bean
    public FilterRegistrationBean<CacheRequestBodyFilter> requestBodyCacheFilter() {
        return DmxWebAutoConfiguration.createFilterBean(new CacheRequestBodyFilter(), -2147483148);
    }

    private static <T extends Filter> FilterRegistrationBean<T> createFilterBean(T filter, Integer order) {
        FilterRegistrationBean bean = new FilterRegistrationBean(filter, new ServletRegistrationBean[0]);
        bean.setOrder(order.intValue());
        return bean;
    }
}

