/*
 * Decompiled with CFR 0.152.
 */
package cn.daimax.framework.web.core.filter;

import cn.daimax.framework.common.util.servlet.ServletUtils;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HTMLFilter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XssRequestWrapper
extends HttpServletRequestWrapper {
    private static final ThreadLocal<HTMLFilter> HTML_FILTER = ThreadLocal.withInitial(() -> {
        HTMLFilter htmlFilter = new HTMLFilter();
        ReflectUtil.setFieldValue((Object)htmlFilter, (String)"encodeQuotes", (Object)false);
        return htmlFilter;
    });

    public XssRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    private static String filterXss(String content) {
        if (StrUtil.isEmpty((CharSequence)content)) {
            return content;
        }
        return HTML_FILTER.get().filter(content);
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        if (!ServletUtils.isJsonRequest((ServletRequest)this)) {
            return super.getInputStream();
        }
        String content = IoUtil.readUtf8((InputStream)super.getInputStream());
        content = XssRequestWrapper.filterXss(content);
        final ByteArrayInputStream newInputStream = new ByteArrayInputStream(content.getBytes());
        return new ServletInputStream(){

            public int read() {
                return newInputStream.read();
            }

            public boolean isFinished() {
                return true;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }

    public String getParameter(String name) {
        String value = super.getParameter(name);
        return XssRequestWrapper.filterXss(value);
    }

    public String[] getParameterValues(String name) {
        Object[] values = super.getParameterValues(name);
        if (ArrayUtil.isEmpty((Object[])values)) {
            return values;
        }
        for (int i = 0; i < values.length; ++i) {
            values[i] = XssRequestWrapper.filterXss((String)values[i]);
        }
        return values;
    }

    public Map<String, String[]> getParameterMap() {
        Map valueMap = super.getParameterMap();
        if (CollUtil.isEmpty((Map)valueMap)) {
            return valueMap;
        }
        for (Map.Entry entry : valueMap.entrySet()) {
            String[] values = (String[])entry.getValue();
            for (int i = 0; i < values.length; ++i) {
                values[i] = XssRequestWrapper.filterXss(values[i]);
            }
        }
        return valueMap;
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        return XssRequestWrapper.filterXss(value);
    }
}

