/*
 * Decompiled with CFR 0.152.
 */
package nbcp.myoql.code.generator.db.mysql;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import nbcp.base.comm.ConfigKt;
import nbcp.base.extend.MyHelper;
import nbcp.base.utils.StringUtil;
import nbcp.myoql.code.generator.StringExtendKt;
import nbcp.myoql.code.generator.db.mysql.model.TableColumnMetaData;
import nbcp.myoql.db.sql.enums.DbType;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeanUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0010\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006R\u0011\u0010\u0014\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0017\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0019\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\u001b\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012R\u0011\u0010\u001d\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0012\u00a8\u0006 "}, d2={"Lnbcp/myoql/code/generator/db/mysql/TableColumnDetail;", "Lnbcp/myoql/code/generator/db/mysql/model/TableColumnMetaData;", "()V", "autoId", "", "getAutoId", "()Z", "autoNumber", "getAutoNumber", "dbType", "Lnbcp/myoql/db/sql/enums/DbType;", "getDbType", "()Lnbcp/myoql/db/sql/enums/DbType;", "setDbType", "(Lnbcp/myoql/db/sql/enums/DbType;)V", "fieldName", "", "getFieldName", "()Ljava/lang/String;", "isEnum", "isEnumSet", "javaDefaultValue", "getJavaDefaultValue", "javaType", "getJavaType", "kotlinDefaultValue", "getKotlinDefaultValue", "kotlinType", "getKotlinType", "labelComment", "getLabelComment", "Companion", "ktmyoql-code-generator"})
public final class TableColumnDetail
extends TableColumnMetaData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private DbType dbType = DbType.OTHER;

    @NotNull
    public final String getLabelComment() {
        return StringExtendKt.removeQuoteContent(this.getColumnComment());
    }

    @NotNull
    public final String getFieldName() {
        Object name2 = this.getColumnName();
        if (Character.isDigit(((String)name2).charAt(0))) {
            name2 = "field_" + (String)name2;
        }
        if (ConfigKt.getConfig().getMyoqlKeepDbName()) {
            return CollectionsKt.joinToString$default((Iterable)StringUtil.splitWordParts((String)name2), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null);
        }
        return StringUtil.getSmallCamelCase((String)name2);
    }

    @NotNull
    public final DbType getDbType() {
        return this.dbType;
    }

    public final void setDbType(@NotNull DbType dbType) {
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"<set-?>");
        this.dbType = dbType;
    }

    @NotNull
    public final String getKotlinType() {
        return this.dbType.toKotlinType();
    }

    @NotNull
    public final String getJavaType() {
        String string = this.dbType.getJavaType().getTypeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.dbType.javaType.typeName");
        return string;
    }

    @NotNull
    public final String getKotlinDefaultValue() {
        return this.dbType.toKotlinDefaultValue();
    }

    @NotNull
    public final String getJavaDefaultValue() {
        if (this.dbType == DbType.BYTE) {
            return "new byte[0]";
        }
        return this.dbType.toKotlinDefaultValue();
    }

    public final boolean getAutoId() {
        CharSequence charSequence = this.getColumnComment();
        return new Regex("\bauto_id\b", RegexOption.IGNORE_CASE).containsMatchIn(charSequence);
    }

    public final boolean getAutoNumber() {
        CharSequence charSequence = this.getColumnComment();
        return new Regex("\bauto_number\b", RegexOption.IGNORE_CASE).containsMatchIn(charSequence);
    }

    public final boolean isEnum() {
        return MyHelper.basicSame((Object)this.getColumnSqlType(), (Object)"enum");
    }

    public final boolean isEnumSet() {
        return MyHelper.basicSame((Object)this.getColumnSqlType(), (Object)"set");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lnbcp/myoql/code/generator/db/mysql/TableColumnDetail$Companion;", "", "()V", "loadFrom", "Lnbcp/myoql/code/generator/db/mysql/TableColumnDetail;", "column", "Lnbcp/myoql/code/generator/db/mysql/model/TableColumnMetaData;", "ktmyoql-code-generator"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TableColumnDetail loadFrom(@NotNull TableColumnMetaData column) {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            TableColumnDetail ret = new TableColumnDetail();
            BeanUtils.copyProperties((Object)column, (Object)ret);
            return ret;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

