/*
 * Decompiled with CFR 0.152.
 */
package nbcp.myoql.code.generator.tool;

import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nbcp.base.extend.ClassHelper;
import nbcp.base.extend.EnumHelper;
import nbcp.base.extend.TypeHelper;
import nbcp.base.utils.CnAnnotationUtil;
import nbcp.base.utils.StringUtil;
import nbcp.myoql.code.generator.tool.BaseFreemarkerModel;
import nbcp.myoql.code.generator.tool.freemarker.FreemarkerGetKotlinType;
import nbcp.myoql.code.generator.tool.freemarker.FreemarkerHasDustbin;
import nbcp.myoql.code.generator.tool.freemarker.FreemarkerHasField;
import nbcp.myoql.db.BaseEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bR\u001b\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\fR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000f\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u000f\"\u0004\b'\u0010\u001dR\u001b\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\n8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\fR\u0011\u0010*\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u000f\"\u0004\b1\u0010\u001dR\u0011\u00102\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u000fR\u0011\u00104\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u000f\u00a8\u00066"}, d2={"Lnbcp/myoql/code/generator/tool/CrudCodeTemplateData;", "Lnbcp/myoql/code/generator/tool/BaseFreemarkerModel;", "group", "", "entityClass", "Ljava/lang/Class;", "tableName", "idKey", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)V", "embedModelTypes", "", "getEmbedModelTypes", "()Ljava/util/Set;", "entity", "getEntity", "()Ljava/lang/String;", "getEntityClass", "()Ljava/lang/Class;", "setEntityClass", "(Ljava/lang/Class;)V", "enumTypes", "getEnumTypes", "fields", "", "Ljava/lang/reflect/Field;", "getFields", "()Ljava/util/List;", "getGroup", "setGroup", "(Ljava/lang/String;)V", "hasField", "Lnbcp/myoql/code/generator/tool/freemarker/FreemarkerHasField;", "getHasField", "()Lnbcp/myoql/code/generator/tool/freemarker/FreemarkerHasField;", "has_dustbin", "Lnbcp/myoql/code/generator/tool/freemarker/FreemarkerHasDustbin;", "getHas_dustbin", "()Lnbcp/myoql/code/generator/tool/freemarker/FreemarkerHasDustbin;", "getIdKey", "setIdKey", "inputTableTypes", "getInputTableTypes", "kotlin_type", "Lnbcp/myoql/code/generator/tool/freemarker/FreemarkerGetKotlinType;", "getKotlin_type", "()Lnbcp/myoql/code/generator/tool/freemarker/FreemarkerGetKotlinType;", "status_enum_class", "getStatus_enum_class", "getTableName", "setTableName", "title", "getTitle", "url", "getUrl", "ktmyoql-code-generator"})
@SourceDebugExtension(value={"SMAP\nCrudCodeTemplateData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrudCodeTemplateData.kt\nnbcp/myoql/code/generator/tool/CrudCodeTemplateData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1045#2:131\n1855#2,2:132\n1855#2,2:134\n288#2,2:136\n*S KotlinDebug\n*F\n+ 1 CrudCodeTemplateData.kt\nnbcp/myoql/code/generator/tool/CrudCodeTemplateData\n*L\n34#1:131\n52#1:132,2\n83#1:134,2\n118#1:136,2\n*E\n"})
public final class CrudCodeTemplateData
extends BaseFreemarkerModel {
    @NotNull
    private String group;
    @NotNull
    private Class<?> entityClass;
    @NotNull
    private String tableName;
    @NotNull
    private String idKey;
    @NotNull
    private final FreemarkerGetKotlinType kotlin_type;
    @NotNull
    private final FreemarkerHasField hasField;
    @NotNull
    private final FreemarkerHasDustbin has_dustbin;

    public CrudCodeTemplateData(@NotNull String group, @NotNull Class<?> entityClass, @NotNull String tableName, @NotNull String idKey) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)idKey, (String)"idKey");
        this.group = group;
        this.entityClass = entityClass;
        this.tableName = tableName;
        this.idKey = idKey;
        this.kotlin_type = new FreemarkerGetKotlinType();
        this.hasField = new FreemarkerHasField();
        this.has_dustbin = new FreemarkerHasDustbin();
    }

    @NotNull
    public final String getGroup() {
        return this.group;
    }

    public final void setGroup(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.group = string;
    }

    @NotNull
    public final Class<?> getEntityClass() {
        return this.entityClass;
    }

    public final void setEntityClass(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"<set-?>");
        this.entityClass = clazz;
    }

    @NotNull
    public final String getTableName() {
        return this.tableName;
    }

    public final void setTableName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.tableName = string;
    }

    @NotNull
    public final String getIdKey() {
        return this.idKey;
    }

    public final void setIdKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.idKey = string;
    }

    @NotNull
    public final String getUrl() {
        String string = StringUtil.getKebabCase((String)this.group);
        String string2 = this.entityClass.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entityClass.simpleName");
        return "/" + string + "/" + StringUtil.getKebabCase((String)string2);
    }

    @NotNull
    public final String getEntity() {
        String string = this.entityClass.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entityClass.simpleName");
        return string;
    }

    @NotNull
    public final List<Field> getFields() {
        Iterable $this$sortedBy$iv = ClassHelper.getAllFields(this.entityClass);
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Field it = (Field)a;
                boolean bl = false;
                Integer n = Intrinsics.areEqual((Object)it.getName(), (Object)"id") ? Integer.valueOf(-9) : (Intrinsics.areEqual((Object)it.getName(), (Object)"name") ? Integer.valueOf(-8) : (Intrinsics.areEqual((Object)it.getName(), (Object)"code") ? Integer.valueOf(-7) : Integer.valueOf(0)));
                it = (Field)b;
                Comparable comparable = n;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(Intrinsics.areEqual((Object)it.getName(), (Object)"id") ? Integer.valueOf(-9) : (Intrinsics.areEqual((Object)it.getName(), (Object)"name") ? Integer.valueOf(-8) : (Intrinsics.areEqual((Object)it.getName(), (Object)"code") ? Integer.valueOf(-7) : Integer.valueOf(0)))));
            }
        });
    }

    @NotNull
    public final Set<Class<?>> getEnumTypes() {
        return EnumHelper.findAllEnum(this.entityClass);
    }

    @NotNull
    public final Set<Class<?>> getEmbedModelTypes() {
        Set list = null;
        list = new LinkedHashSet();
        Iterable $this$forEach$iv = ClassHelper.getAllFields(this.entityClass);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Field it = (Field)element$iv;
            boolean bl = false;
            if (ClassHelper.IsCollectionType$default((Field)it, null, (int)1, null) || ClassHelper.IsArrayType$default((Field)it, null, (int)1, null)) continue;
            Class<?> clazz = it.getType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"it.type");
            if (ClassHelper.IsSimpleType(clazz) || it.getType() instanceof BaseEntity) continue;
            Class<?> clazz2 = it.getType();
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"it.type");
            list.add(clazz2);
        }
        return list;
    }

    @NotNull
    public final Set<Class<?>> getInputTableTypes() {
        Set list = null;
        list = new LinkedHashSet();
        Iterable $this$forEach$iv = ClassHelper.getAllFields(this.entityClass);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class<?> comType;
            Field it = (Field)element$iv;
            boolean bl = false;
            if (ClassHelper.IsCollectionType$default((Field)it, null, (int)1, null)) {
                comType = ClassHelper.GetFirstGenericType((Field)it);
                if (ClassHelper.IsSimpleType((Class)comType)) continue;
                list.add(comType);
                continue;
            }
            if (!ClassHelper.IsArrayType$default((Field)it, null, (int)1, null)) continue;
            Class<?> clazz = comType = it.getType().getComponentType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"comType");
            if (ClassHelper.IsSimpleType(clazz)) continue;
            list.add(comType);
        }
        return list;
    }

    @NotNull
    public final String getTitle() {
        return TypeHelper.AsString((Object)CnAnnotationUtil.getCnValue(this.entityClass), (String)this.tableName);
    }

    @NotNull
    public final String getStatus_enum_class() {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = this.getFields();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Field it = (Field)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"status")) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Field statusField = v0;
        if (statusField != null) {
            Class<?> clazz = statusField.getType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"statusField.type");
            return ClassHelper.getKotlinTypeName(clazz);
        }
        return "";
    }

    @NotNull
    public final FreemarkerGetKotlinType getKotlin_type() {
        return this.kotlin_type;
    }

    @NotNull
    public final FreemarkerHasField getHasField() {
        return this.hasField;
    }

    @NotNull
    public final FreemarkerHasDustbin getHas_dustbin() {
        return this.has_dustbin;
    }
}

