/*
 * Decompiled with CFR 0.152.
 */
package nbcp.myoql.code.generator.tool;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import nbcp.base.db.annotation.DbEntityIndex;
import nbcp.myoql.code.generator.tool.BaseFreemarkerModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J*\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0007J\b\u0010\f\u001a\u00020\rH\u0002J0\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0016\b\u0002\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0007J0\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0016\b\u0002\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0007J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u001a"}, d2={"Lnbcp/myoql/code/generator/tool/FreemarkerUtil;", "", "()V", "escapeString", "", "originStr", "getEntityUniqueIndexesDefine", "", "entType", "Ljava/lang/Class;", "procedClasses", "", "getFreemarkerConfig", "Lfreemarker/template/Configuration;", "process", "templateName", "params", "Lnbcp/myoql/code/generator/tool/BaseFreemarkerModel;", "configCallback", "Lkotlin/Function1;", "", "processContent", "content", "processTemplate", "template", "Lfreemarker/template/Template;", "ktmyoql-code-generator"})
@SourceDebugExtension(value={"SMAP\nFreeMarkerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FreeMarkerUtil.kt\nnbcp/myoql/code/generator/tool/FreemarkerUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,147:1\n13579#2,2:148\n*S KotlinDebug\n*F\n+ 1 FreeMarkerUtil.kt\nnbcp/myoql/code/generator/tool/FreemarkerUtil\n*L\n135#1:148,2\n*E\n"})
public final class FreemarkerUtil {
    @NotNull
    public static final FreemarkerUtil INSTANCE = new FreemarkerUtil();

    private FreemarkerUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String escapeString(@NotNull String originStr) {
        Intrinsics.checkNotNullParameter((Object)originStr, (String)"originStr");
        CharSequence charSequence = originStr;
        Regex regex = new Regex("\u4e95");
        String string = "\\#";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("\uffe5");
        string = "\\$";
        return regex.replace(charSequence, string);
    }

    private final Configuration getFreemarkerConfig() {
        Configuration ret = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        ret.setNumberFormat("#");
        ret.setClassicCompatible(true);
        ret.setDefaultEncoding("UTF-8");
        ret.setLocale(Locale.CHINA);
        ret.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        ret.setClassForTemplateLoading(FreemarkerUtil.class, "/");
        ret.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(FreemarkerUtil.class, "/"));
        return ret;
    }

    private final String processTemplate(Template template, BaseFreemarkerModel params) {
        StringWriter result = new StringWriter();
        template.process((Object)params, (Writer)result);
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String processContent(@NotNull String content, @NotNull BaseFreemarkerModel params, @Nullable Function1<? super Configuration, Unit> configCallback) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Configuration config = INSTANCE.getFreemarkerConfig();
        Function1<? super Configuration, Unit> function1 = configCallback;
        if (function1 != null) {
            function1.invoke((Object)config);
        }
        Template template = new Template("template", (Reader)new StringReader(content), config, "utf-8");
        return FreemarkerUtil.escapeString(INSTANCE.processTemplate(template, params));
    }

    public static /* synthetic */ String processContent$default(String string, BaseFreemarkerModel baseFreemarkerModel, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        return FreemarkerUtil.processContent(string, baseFreemarkerModel, (Function1<? super Configuration, Unit>)function1);
    }

    @JvmStatic
    @NotNull
    public static final String process(@NotNull String templateName, @NotNull BaseFreemarkerModel params, @Nullable Function1<? super Configuration, Unit> configCallback) {
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Configuration config = INSTANCE.getFreemarkerConfig();
        Function1<? super Configuration, Unit> function1 = configCallback;
        if (function1 != null) {
            function1.invoke((Object)config);
        }
        Template template = config.getTemplate(templateName);
        Intrinsics.checkNotNullExpressionValue((Object)template, (String)"config.getTemplate(templateName)");
        Template template2 = template;
        return FreemarkerUtil.escapeString(INSTANCE.processTemplate(template2, params));
    }

    public static /* synthetic */ String process$default(String string, BaseFreemarkerModel baseFreemarkerModel, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        return FreemarkerUtil.process(string, baseFreemarkerModel, (Function1<? super Configuration, Unit>)function1);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Set<String> getEntityUniqueIndexesDefine(@NotNull Class<?> entType, @NotNull Set<String> procedClasses) {
        Intrinsics.checkNotNullParameter(entType, (String)"entType");
        Intrinsics.checkNotNullParameter(procedClasses, (String)"procedClasses");
        String string = entType.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entType.name");
        procedClasses.add(string);
        Set uks = new LinkedHashSet();
        Annotation[] annotationArray = entType.getAnnotationsByType(DbEntityIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"entType.getAnnotationsBy\u2026bEntityIndex::class.java)");
        Object[] $this$forEach$iv = annotationArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DbEntityIndex it = (DbEntityIndex)element$iv;
            boolean bl = false;
            if (!it.unique()) continue;
            uks.add(ArraysKt.joinToString$default((Object[])it.value(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        if (entType.getSuperclass() != null && !procedClasses.contains(entType.getSuperclass().getName())) {
            Class<?> clazz = entType.getSuperclass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"entType.superclass");
            uks.addAll((Collection)FreemarkerUtil.getEntityUniqueIndexesDefine(clazz, procedClasses));
        }
        return uks;
    }

    public static /* synthetic */ Set getEntityUniqueIndexesDefine$default(Class clazz, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        return FreemarkerUtil.getEntityUniqueIndexesDefine(clazz, set);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Set<String> getEntityUniqueIndexesDefine(@NotNull Class<?> entType) {
        Intrinsics.checkNotNullParameter(entType, (String)"entType");
        return FreemarkerUtil.getEntityUniqueIndexesDefine$default(entType, null, 2, null);
    }
}

