package @pkg@.mvc.${sc(group)}

import io.swagger.annotations.*
import org.springframework.web.bind.annotation.*
import @pkg@.db.sql.*
import @pkg@.db.sql.entity.*
import nbcp.base.comm.*
import nbcp.myoql.db.*
import nbcp.db.sql.*
import nbcp.db.sql.entity.*
import nbcp.base.mvc.*
import javax.servlet.http.*
import java.time.*
import nbcp.web.*

/**
 * Created by CodeGenerator at ${now}
 */
@Api(description = "${title}", tags = arrayOf("${entity}"))
@RestController
@RequestMapping("${url}")
class ${entity}AutoController {

    @ApiOperation("列表")
    @PostMapping("/list")
    fun list(
        ${idKey}: ${kotlin_type(entity,idKey)}, //当列表列新一条后，刷新时使用
<#if hasField(entity,"name")>
        name: String,
</#if>
        @Require skip: Int,
        @Require take: Int,
        request: HttpServletRequest
    ): ListResult<${entity}> {

        dbr.${sc(group)}.${entity}.query()
            .apply {
                if (${idKey}.HasValue) {
                    this.where{it.${idKey} sqlEuals ${idKey}}
                }
<#if hasField(entity,"name")>
                if (name.HasValue) {
                    this.where { it.name sqlLike name }
                }
</#if>
            }
            .limit(skip, take)
            .toListResult()
            .apply {
                return this
            }
    }

    @ApiOperation("详情")
    @PostMapping("/detail/{id}")
    fun detail(
        @Require ${idKey}: ${kotlin_type(entity,idKey)},
        request: HttpServletRequest
    ): ApiResult<${entity}> {
        dbr.${sc(group)}.${entity}.queryBy${bc(idKey)}(${idKey})
            .toEntity()
            .apply {
                if (this == null) {
                    return ApiResult.error("找不到数据")
                }

                return ApiResult.of(this)
            }
    }

    @ApiOperation("更新")
    @PostMapping("/save")
    fun save(
        @JsonModel entity: ${entity},
        request: HttpServletRequest
    ): ApiResult<${kotlin_type(entity,idKey)}> {
        //鉴权
        var userId = request.UserId

        dbr.${sc(group)}.${entity}.updateWithEntity(entity)
            .withColumns(request.requestParameterKeys)
            .run {
                if (entity.${idKey}.HasValue) {
                    return@run this.execUpdate()
                } else {
                    return@run this.execInsert()
                }
            }
            .apply {
                if (this == 0) {
                    return ApiResult.error("更新失败")
                }

                return ApiResult.of(entity.${idKey})
            }
    }
<#if hasField(entity,"status")>

    @ApiOperation("更新状态，更新一个字段")
    @PostMapping("/set-status")
    fun set(
        @Require ${idKey}: ${kotlin_type(entity,idKey)},
        @Require status: ${status_enum_class},
        request: HttpServletRequest
    ): JsonResult {
        //鉴权
        var userId = request.UserId

        dbr.${sc(group)}.${entity}.updateBy${bc(idKey)}(${idKey})
            .set { it.status to status }
            .exec()
            .apply {
                if (this == 0) {
                    return JsonResult.error("更新失败")
                }

                return JsonResult()
            }
    }
</#if>

    @ApiOperation("删除")
    @PostMapping("/delete/{id}")
    fun delete(
        @Require ${idKey}: ${kotlin_type(entity,idKey)},
        request: HttpServletRequest
    ): JsonResult {
        //鉴权
        var userId = request.UserId

        var entity = dbr.${sc(group)}.${entity}.queryBy${bc(idKey)}(${idKey}).toEntity()
        if (entity == null) {
            return JsonResult.error("找不到数据")
        }
<#if has_dustbin(entity)>
        //实体上配置了垃圾箱功能，物理删除后会自动移到垃圾箱。
<#else>
        //实体上没有配置垃圾箱功能，物理删除后会丢失数据！
</#if>
        dbr.${sc(group)}.${entity}.deleteBy${bc(idKey)}(${idKey})
            .exec()
            .apply {
                if (this == 0) {
                    return JsonResult.error("删除失败")
                }

                return JsonResult()
            }
    }
}