<template>
    <div class="card-page">
        <tool-bar nav="" :title="action_name + '${title}'">
            <el-button size="small" @click="$router.push('${url}/add')" v-if="action=='edit'">新建</el-button>
            <el-button size="small" @click="save_click" type="primary">保存</el-button>
        </tool-bar>
        <el-row :gutter="12" style="width: 100%;" justify="space-around">
            <el-col :span="12">
                <el-card shadow="always">
                    <template #header>
                        <span>基本信息</span>
                    </template>
<#list fields as field>
    <#if field.getName() == "id">
    <#elseif field.getName() == "creator" || field.getName() == "createBy">
    <#elseif field.getName() == "updater" || field.getName() == "updateBy">
    <#elseif field.getName() == "createAt">
    <#elseif field.getName() == "updateAt">
    <#elseif field.getType().isEnum()>
                    <kv label="${fieldCn(field)}">
                        <selector v-model="info.${field.getName()}" enum="${field.getType().getSimpleName()}" chk="*"/>
                    </kv>
    <#elseif fieldIsEnumList(field)>
                    <kv label="${fieldCn(field)}">
                        <selector multi value-is-object v-model="info.${field.getName()}" enum="${fieldListType(field)}" />
                    </kv>
    <#elseif isType(field,"IdUrl")>
                    <kv>
                        <label slot="k">${fieldCn(field)}</label>
                        <upload
                                :maxCount="1"
                                v-model="info.${field.getName()}"
                                fileType="img"
                                scales="16:9"
                                :maxWidth="1024"
                                maxSize="5M"
                        ></upload>
                    </kv>
    <#elseif fieldIsList(field,"IdUrl")>
                    <kv>
                        <label slot="k">${fieldCn(field)}</label>
                        <upload
                                :maxCount="99"
                                v-model="info.${field.getName()}"
                                fileType="img"
                                scales="16:9"
                                :maxWidth="1024"
                                maxSize="5M"
                        ></upload>
                    </kv>
    <#elseif isType(field,"IdName")>
                    <kv label="${fieldCn(field)}">
                        <ref-${kb(field.getName())} v-model="info.${field.getName()}"></ref-${kb(field.getName())}>
                    </kv>
    <#elseif isType(field,"boolean")>
                    <kv label="${fieldCn(field)}">
                        <selector v-model="info.${field.getName()}" :data="{true:'是',false:'否','':'全部'}" />
                    </kv>
    <#elseif isType(field,"LocalDate")>
                    <kv label="${fieldCn(field)}">
                        <el-date-picker v-model="info.${field.getName()}" placeholder="选择日期" />
                    </kv>
    <#elseif isType(field,"LocalDateTime")>
                    <kv label="${fieldCn(field)}">
                        <el-date-picker v-model="info.${field.getName()}" placeholder="选择日期时间"  type="datetime" />
                    </kv>
    <#elseif isType(field,"LocalTime")>
                    <kv label="${fieldCn(field)}">
                        <el-time-select v-model="info.${field.getName()}" placeholder="选择时间" />
                    </kv>
    <#elseif isType(field,"byte","int","long")>
                    <kv label="${fieldCn(field)}">
                        <el-input v-model="info.${field.getName()}" chk="?int" />
                    </kv>
    <#elseif isType(field,"float","double")>
        <kv label="${fieldCn(field)}">
            <el-input v-model="info.${field.getName()}" chk="?float" />
        </kv>
    <#elseif fieldIsInputTable(field)>
    <#elseif fieldIsEmbedObjet(field)>
    <#elseif field.getName() == "name">
        <kv label="${fieldCn(field)}">
            <el-input v-model="info.${field.getName()}" chk="*" />
        </kv>
    <#elseif field.getName() == "remark">
        <kv label="${fieldCn(field)}">
            <el-input v-model="info.${field.getName()}" type="textarea"/>
        </kv>
    <#else>
        <kv label="${fieldCn(field)}">
            <el-input v-model="info.${field.getName()}" />
        </kv>
</#if>
</#list>
                </el-card>
            </el-col>
            <el-col :span="12">
            <el-card shadow="always">
                <template #header>
                    <span>扩展信息</span>
                </template>
            </el-card>
        </el-col>
    </el-row>
    <div>
<#list fields as field>
    <#if fieldIsEmbedObjet(field)>
        <ref-${kb(field.getType().getSimpleName())} title="${fieldCn(field)}" v-model="info.${field.getName()}">
        </ref-${kb(field.getType().getSimpleName())}>
    <#elseif fieldIsInputTable(field)>
            <ref-table-${kb(fieldInputTable(field).getSimpleName())} title="${fieldCn(field)}" v-model="info.${field.getName()}">
            </ref-table-${kb(fieldInputTable(field).getSimpleName())}>
    </#if>
</#list>

    </div>
</div>
</template>

<script setup>
/**
 * Created by CodeGenerator  at ${now}
 */
<#list inputTableTypes as type>

<#if isType(type,"IdName")>
import RefTable${bc(type.getSimpleName())}  "@/component/empty-ref"
<#else>
import RefTable${bc(type.getSimpleName())} from "./ref-table-${kb(type.getSimpleName())}"
</#if>
</#list>
<#list embedModelTypes as type>
<#if isType(type,"IdName")>
<#else>
import Ref${bc(type.getSimpleName())} from "./ref-${kb(type.getSimpleName())}"
</#if>
</#list>

import {
    reactive,
    defineOptions,
    watch,
    useAttrs,
    computed,
    onMounted,
    nextTick,
    getCurrentInstance
} from 'vue'

//定义 vue2的this,当前组件
let $self = getCurrentInstance();

//定义 $attrs
let $attrs = useAttrs()


//定义事件
let $emit = defineEmits(["update:modelValue", "loaded"]);

//定义属性
var $props = defineProps({
    id: {type: String, default: ""},
    action: {type: String, default: ""}
});
const action_name = computed(() => {
    return {add: "添加", edit: "修改"}[$props.action]
});

//定义data
let $data = reactive({
    info: {
        <#list fields as field>
        <#if fieldIsList(field)>
        ${field.getName()}: [],
        <#elseif isObject(field)>
        ${field.getName()}: {},
        </#if>
        </#list>
    }, //子对象需要声明。

    <#list enumTypes as type>
    ${type.getSimpleName()}: jv.enum.${type.getSimpleName()}.getData(),
    </#list>
})


const info = $computed(() => $data.info)

/**
 * 加载数据
 * @returns {Promise<void>}
 */
const loadData = async ()=> {
    if (!$props.id) return;
    let res = await jv.$http.post("${url}/detail/" + $props.id)
    $data.info = res.data.data;
}

/**
 * 保存数据
 */
const save_click = async () =>{
    //校验
    if (jv.chk_main() == false) {
        return;
    }

    let res = await jv.$http.post("${url}/save", $data.info)
    //[axios拦截器中已处理了异常]。
    jv.info(action_name + " 成功");
    let id = res.data.data || $data.info.id;
    if (!id) {
        return jv.error("找不到 id");
    }
    jv.$router.push("${url}/edit/" + id);
}

</script>

<style scoped lang="scss">
</style>
