/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.example.okhttp3;

import java.io.IOException;
import javax.annotation.Resource;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Okhttp3Service {
    private static final Logger log = LoggerFactory.getLogger(Okhttp3Service.class);
    @Resource
    private OkHttpClient okHttpClient;

    public void call(String url) {
        Request request = new Request.Builder().url(url).build();
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.error("okhttp3 async error", (Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                log.info("okhttp3 async result: {}", (Object)new String(response.body().bytes()));
            }
        });
    }
}

