/*
 * Decompiled with CFR 0.152.
 */
package cn.easii.tutelary.deps.ch.qos.logback.core.spi;

import cn.easii.tutelary.deps.ch.qos.logback.core.Context;
import cn.easii.tutelary.deps.ch.qos.logback.core.spi.ContextAware;
import cn.easii.tutelary.deps.ch.qos.logback.core.status.ErrorStatus;
import cn.easii.tutelary.deps.ch.qos.logback.core.status.InfoStatus;
import cn.easii.tutelary.deps.ch.qos.logback.core.status.Status;
import cn.easii.tutelary.deps.ch.qos.logback.core.status.StatusManager;
import cn.easii.tutelary.deps.ch.qos.logback.core.status.WarnStatus;

public class ContextAwareBase
implements ContextAware {
    private int noContextWarning = 0;
    protected Context context;
    final Object declaredOrigin;

    public ContextAwareBase() {
        this.declaredOrigin = this;
    }

    public ContextAwareBase(ContextAware declaredOrigin) {
        this.declaredOrigin = declaredOrigin;
    }

    @Override
    public void setContext(Context context) {
        if (this.context == null) {
            this.context = context;
        } else if (this.context != context) {
            throw new IllegalStateException("Context has been already set");
        }
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public StatusManager getStatusManager() {
        if (this.context == null) {
            return null;
        }
        return this.context.getStatusManager();
    }

    protected Object getDeclaredOrigin() {
        return this.declaredOrigin;
    }

    @Override
    public void addStatus(Status status) {
        if (this.context == null) {
            if (this.noContextWarning++ == 0) {
                System.out.println("LOGBACK: No context given for " + this);
            }
            return;
        }
        StatusManager sm = this.context.getStatusManager();
        if (sm != null) {
            sm.add(status);
        }
    }

    @Override
    public void addInfo(String msg) {
        this.addStatus(new InfoStatus(msg, this.getDeclaredOrigin()));
    }

    @Override
    public void addInfo(String msg, Throwable ex) {
        this.addStatus(new InfoStatus(msg, this.getDeclaredOrigin(), ex));
    }

    @Override
    public void addWarn(String msg) {
        this.addStatus(new WarnStatus(msg, this.getDeclaredOrigin()));
    }

    @Override
    public void addWarn(String msg, Throwable ex) {
        this.addStatus(new WarnStatus(msg, this.getDeclaredOrigin(), ex));
    }

    @Override
    public void addError(String msg) {
        this.addStatus(new ErrorStatus(msg, this.getDeclaredOrigin()));
    }

    @Override
    public void addError(String msg, Throwable ex) {
        this.addStatus(new ErrorStatus(msg, this.getDeclaredOrigin(), ex));
    }
}

