/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.common.utils;

import cn.easyes.common.utils.CollectionUtils;
import cn.easyes.common.utils.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReflectionKit {
    private static final Map<Class, List<Field>> classFieldCache = new ConcurrentHashMap<Class, List<Field>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getFieldList(Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            return Collections.emptyList();
        }
        List<Field> fields = classFieldCache.get(clazz);
        if (CollectionUtils.isEmpty(fields)) {
            Map<Class, List<Field>> map = classFieldCache;
            synchronized (map) {
                fields = ReflectionKit.doGetFieldList(clazz);
                classFieldCache.put(clazz, fields);
            }
        }
        return fields;
    }

    public static List<Field> doGetFieldList(Class<?> clazz) {
        if (clazz.getSuperclass() != null) {
            List fieldList = Stream.of(clazz.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> !Modifier.isTransient(field.getModifiers())).collect(Collectors.toCollection(LinkedList::new));
            Class<?> superClass = clazz.getSuperclass();
            return ReflectionKit.excludeOverrideSuperField(fieldList, ReflectionKit.getFieldList(superClass));
        }
        return Collections.emptyList();
    }

    public static List<Field> excludeOverrideSuperField(List<Field> fieldList, List<Field> superFieldList) {
        Map fieldMap = fieldList.stream().collect(Collectors.toMap(Field::getName, Function.identity()));
        superFieldList.stream().filter(field -> !fieldMap.containsKey(field.getName())).forEach(fieldList::add);
        return fieldList;
    }

    public static Method getMethod(Class<?> cls, Field field) {
        try {
            return cls.getDeclaredMethod(ReflectionKit.getMethodCapitalize(field, field.getName()), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = String.format("Error: NoSuchMethod in %s.  Cause: %s", cls.getName(), e);
            throw new RuntimeException(msg);
        }
    }

    public static String getMethodCapitalize(Field field, String str) {
        Class<?> fieldType = field.getType();
        return StringUtils.concatCapitalize(Boolean.TYPE.equals(fieldType) ? "is" : "get", str);
    }

    public static <T> T getVal(String val, Class<T> type) {
        T value = null;
        try {
            Constructor<T> constructor = type.getConstructor(String.class);
            constructor.setAccessible(true);
            value = constructor.newInstance(val);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }
}

