package cn.entertech.log.local

import android.content.Intent
import android.net.Uri
import android.view.View
import android.widget.Toast
import androidx.core.content.FileProvider
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import cn.android.base.view.ToastUtil
import cn.entertech.base.BaseActivity
import cn.entertech.base.list.adapter.BaseRecyclerViewAdapter
import cn.entertech.base.list.adapter.IRecycleViewClickListener
import cn.entertech.log.api.EnterTechLogUtils
import java.io.File

class LogListActivity : BaseActivity(), IRecycleViewClickListener<File> {
    private val mLogListAdapter by lazy {
        LogListAdapter(clickListener = this)
    }
    private var rvLogFileList: RecyclerView? = null

    override fun getActivityLayoutResId(): Int {
        return R.layout.log_list_activity
    }

    override fun initActivityData() {
        super.initActivityData()
        val printer = EnterTechLogUtils.printer
        if (printer !is StorageLogPrinter) {
            finish()
            return
        }
        val logFolder = printer.getCurrentLogFolder()
        val logFileList = logFolder.listFiles()?.toList() ?: emptyList()
        ToastUtil.toastShort(this, "本地存有 ${logFileList.size} 条日志")
        if (logFileList.isEmpty()) {

            finish()
            return
        }

        mLogListAdapter.setData(logFileList)
    }

    override fun initActivityView() {
        super.initActivityView()
        rvLogFileList = findViewById(R.id.rvLogFileList)
        rvLogFileList?.adapter = mLogListAdapter
        rvLogFileList?.layoutManager = LinearLayoutManager(this)

    }

    override fun itemClick(
        adapter: BaseRecyclerViewAdapter<File, *>,
        view: View?,
        position: Int,
        target: File
    ) {
        openTextFile(target)
    }

    private fun openTextFile(file: File) {
        if (file.exists()) {
            try {
                val fileUri: Uri = FileProvider.getUriForFile(
                    this, "${packageName}.log.file.provider", file
                )

                val intent = Intent(Intent.ACTION_VIEW)
                intent.setDataAndType(fileUri, "text/plain")
                intent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION)

                if (intent.resolveActivity(packageManager) != null) {
                    startActivity(intent)
                } else {
                    // 处理没有应用可以打开文件的情况
                    ToastUtil.toastShort(this, "没有应用可以打开此文件")

                }
            } catch (e: Exception) {
                e.printStackTrace()
            }
        } else {
            ToastUtil.toastShort(this, "$file 文件不存在")
        }
    }
}