package cn.entertech.log.local

import android.view.View
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import cn.entertech.base.list.adapter.BaseRecyclerViewAdapter
import cn.entertech.base.list.adapter.IRecycleViewClickListener
import java.io.File

class LogListAdapter(
    data: List<File> = emptyList(),
    clickListener: IRecycleViewClickListener<File>
) :
    BaseRecyclerViewAdapter<File, LogListAdapter.LogListVH>(
        data,
        itemLayoutResId = R.layout.log_list_item_layout,
        listener = clickListener
    ) {
    class LogListVH(rootView: View) : RecyclerView.ViewHolder(rootView) {
        val text = rootView.findViewById<TextView>(R.id.tvLogName)
    }

    override fun onBindViewHolder(holder: LogListVH, position: Int) {
        val file = getItem(position)
        holder.itemView.setOnClickListener {
            clickListener?.itemClick(this, it, position, file)
        }
        holder.text?.apply {
            text = file.name
        }
    }

    override fun getViewHolder(rootView: View): LogListVH {
        return LogListVH(rootView)
    }
}