/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.tpl;

import cn.featherfly.hammer.HammerException;
import java.util.HashMap;
import java.util.Map;

public class TemplateDirectives<D> {
    public static final String WHERE_DIRECTIVE_KEY = "where";
    public static final String AND_DIRECTIVE_KEY = "and";
    public static final String OR_DIRECTIVE_KEY = "or";
    public static final String PROPERTIES_DIRECTIVE_KEY = "prop";
    public static final String TEMPLATE_INCLUDE_DIRECTIVE_KEY = "tpl";
    public static final String WRAP_DIRECTIVE_KEY = "wrap";
    private static final String[] REQUIRED_KEYS = new String[]{"where", "and", "or", "prop", "tpl", "wrap"};
    protected Map<String, D> directiveMap = new HashMap<String, D>();

    public void addDirective(String key, D directive) {
        this.directiveMap.put(key, directive);
    }

    public Map<String, D> getDirectiveMap() {
        return this.directiveMap;
    }

    public Map<String, D> getDirectiveMapAfterCheck() {
        for (String key : REQUIRED_KEYS) {
            if (this.directiveMap.containsKey(key)) continue;
            throw new HammerException("directive with key " + key + " is null");
        }
        return this.directiveMap;
    }

    public void addWhereDirective(D directive) {
        this.directiveMap.put(WHERE_DIRECTIVE_KEY, directive);
    }

    public void addAndDirective(D directive) {
        this.directiveMap.put(AND_DIRECTIVE_KEY, directive);
    }

    public void addOrDirective(D directive) {
        this.directiveMap.put(OR_DIRECTIVE_KEY, directive);
    }

    public void addPropertiesDirective(D directive) {
        this.directiveMap.put(PROPERTIES_DIRECTIVE_KEY, directive);
    }

    public void addTemplateIncludeDirective(D directive) {
        this.directiveMap.put(TEMPLATE_INCLUDE_DIRECTIVE_KEY, directive);
    }

    public void addWrapDirective(D directive) {
        this.directiveMap.put(WRAP_DIRECTIVE_KEY, directive);
    }
}

