/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.tpl;

import cn.featherfly.common.io.ClassPathScanningProvider;
import cn.featherfly.common.io.FileUtils;
import cn.featherfly.common.lang.ClassLoaderUtils;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.UriUtils;
import cn.featherfly.common.lang.matcher.MethodAnnotationMatcher;
import cn.featherfly.common.lang.matcher.MethodMatcher;
import cn.featherfly.constant.ConstantPool;
import cn.featherfly.hammer.HammerException;
import cn.featherfly.hammer.tpl.TemplatePreprocessor;
import cn.featherfly.hammer.tpl.TplConfigFactory;
import cn.featherfly.hammer.tpl.TplExecuteConfig;
import cn.featherfly.hammer.tpl.TplExecuteConfigs;
import cn.featherfly.hammer.tpl.TplExecuteId;
import cn.featherfly.hammer.tpl.TplExecuteIdFileImpl;
import cn.featherfly.hammer.tpl.TplExecuteIdMapperImpl;
import cn.featherfly.hammer.tpl.TplType;
import cn.featherfly.hammer.tpl.annotation.Mapper;
import cn.featherfly.hammer.tpl.annotation.Template;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.MetadataReader;

public class TplConfigFactoryImpl
implements TplConfigFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String MULTI_SAME_EXECUTEID = "!@!";
    private ObjectMapper mapper;
    private boolean devMode;
    private String suffix;
    private String prefix;
    private Map<String, TplExecuteConfigs> configs = new HashMap<String, TplExecuteConfigs>();
    private Map<String, String> executIdFileMap = new HashMap<String, String>();
    private ResourcePatternResolver resourcePatternResolver;
    private ClassPathScanningProvider classPathScanningProvider;
    private Set<String> basePackages = new HashSet<String>();
    private TemplatePreprocessor templatePreprocessor;

    public TplConfigFactoryImpl() {
        this("");
    }

    public TplConfigFactoryImpl(Set<String> basePackages) {
        this("", basePackages);
    }

    public TplConfigFactoryImpl(String prefix) {
        this(prefix, ".yaml.sql");
    }

    public TplConfigFactoryImpl(String prefix, Set<String> basePackages) {
        this(prefix, ".yaml.sql", basePackages);
    }

    public TplConfigFactoryImpl(String prefix, String suffix) {
        this(prefix, suffix, null, null);
    }

    public TplConfigFactoryImpl(String prefix, String suffix, Set<String> basePackages) {
        this(prefix, suffix, basePackages, null);
    }

    public TplConfigFactoryImpl(TemplatePreprocessor preCompiler) {
        this("", preCompiler);
    }

    public TplConfigFactoryImpl(Set<String> basePackages, TemplatePreprocessor preCompiler) {
        this("", basePackages, preCompiler);
    }

    public TplConfigFactoryImpl(String prefix, TemplatePreprocessor preCompiler) {
        this(prefix, ".yaml.sql", preCompiler);
    }

    public TplConfigFactoryImpl(String prefix, Set<String> basePackages, TemplatePreprocessor preCompiler) {
        this(prefix, ".yaml.sql", basePackages, preCompiler);
    }

    public TplConfigFactoryImpl(String prefix, String suffix, TemplatePreprocessor preCompiler) {
        this(prefix, suffix, null, preCompiler);
    }

    public TplConfigFactoryImpl(String prefix, String suffix, Set<String> basePackages, TemplatePreprocessor preCompiler) {
        this.mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.mapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.templatePreprocessor = preCompiler == null ? value -> value : preCompiler;
        this.prefix = Lang.isEmpty((String)prefix) ? "" : prefix;
        this.suffix = Lang.isEmpty((String)suffix) ? ".yaml.sql" : suffix;
        this.basePackages = basePackages == null ? new HashSet() : basePackages;
        this.devMode = ConstantPool.getDefault().getConstantParameter().isDevMode();
        this.initConfigsFromFile();
        this.initConfigFromMapper();
    }

    private void initConfigFromMapper() {
        if (Lang.isEmpty(this.basePackages)) {
            return;
        }
        if (this.classPathScanningProvider == null) {
            this.classPathScanningProvider = new ClassPathScanningProvider();
        }
        for (String basePackage : this.basePackages) {
            Set metadataReaders = this.classPathScanningProvider.findMetadata(basePackage);
            for (MetadataReader metadataReader : metadataReaders) {
                if (!metadataReader.getAnnotationMetadata().hasAnnotatedMethods(Template.class.getName())) continue;
                this.readConfig(ClassUtils.forName((String)metadataReader.getClassMetadata().getClassName()));
            }
        }
    }

    private String getNamespace(Class<?> type) {
        Mapper mapper = type.getAnnotation(Mapper.class);
        return mapper == null || Lang.isEmpty((String)mapper.namespace()) ? type.getName() : mapper.namespace();
    }

    private TplExecuteConfigs readConfig(Class<?> type) {
        Collection methods = ClassUtils.findMethods(type, (MethodMatcher)new MethodAnnotationMatcher(new Class[]{Template.class}));
        String globalNamespace = this.getNamespace(type);
        TplExecuteConfigs newConfigs = new TplExecuteConfigs();
        newConfigs.setName(globalNamespace);
        newConfigs.setFilePath(ClassUtils.packageToDir((String)type.getName()));
        String fileDirectory = ClassUtils.packageToDir(type);
        HashSet<String> executeIds = new HashSet<String>();
        for (Method method : methods) {
            Template template = method.getAnnotation(Template.class);
            if (Lang.isEmpty((String)template.value())) continue;
            String name = Lang.isEmpty((String)template.name()) ? method.getName() : template.name();
            String namespace = Lang.isEmpty((String)template.namespace()) ? globalNamespace : template.namespace();
            this.checkName(executeIds, name, namespace);
            TplExecuteConfig config = new TplExecuteConfig();
            config.setQuery(this.templatePreprocessor.process(template.value()));
            config.setTplName(namespace + "@" + name);
            config.setExecuteId(name);
            config.setName(type.getSimpleName());
            config.setFileName(type.getSimpleName() + ".class");
            config.setFileDirectory(fileDirectory);
            this.logger.debug("type -> {} , namespace -> {} ,  {} -> {}", new Object[]{type.getName(), namespace, name, config});
            newConfigs.put((Object)name, (Object)config);
            if (this.executIdFileMap.containsKey(config.getExecuteId()) && !this.executIdFileMap.get(config.getExecuteId()).equals(newConfigs.getName())) {
                this.executIdFileMap.put(config.getExecuteId(), MULTI_SAME_EXECUTEID);
                continue;
            }
            this.executIdFileMap.put(config.getExecuteId(), newConfigs.getName());
        }
        this.logger.debug("type -> {} , namespace -> {} ,  configs -> {}", new Object[]{type.getName(), globalNamespace, newConfigs});
        this.configs.put(newConfigs.getName(), newConfigs);
        return newConfigs;
    }

    private void checkName(Set<String> executeIds, String name, String namespace) {
        if (name.contains("@")) {
            throw new HammerException("invalidate character [@] in executeId [" + name + "]");
        }
        if (executeIds.contains(name)) {
            throw new HammerException("duplicated executeId [" + name + "] in [" + namespace + "]");
        }
    }

    private void initConfigsFromFile() {
        this.resourcePatternResolver = new PathMatchingResourcePatternResolver();
        String packageSearchPath = "classpath*:" + UriUtils.linkUri((String)this.prefix, (String)"**/*") + this.suffix;
        try {
            Resource[] resources;
            for (Resource resource : resources = this.resourcePatternResolver.getResources(packageSearchPath)) {
                if (FileUtils.isResourceInJar((URL)resource.getURL())) {
                    this.readConfig(FileUtils.getPathInJar((URL)resource.getURL()));
                    continue;
                }
                String path = resource.getURL().getPath();
                Enumeration<URL> enums = ClassLoader.getSystemResources("");
                while (enums.hasMoreElements()) {
                    String rootPath = enums.nextElement().getPath();
                    if (!path.startsWith(rootPath)) continue;
                    path = StringUtils.substring((String)path, (int)rootPath.length());
                    break;
                }
                this.logger.debug("init read config : {}", (Object)path);
                this.readConfig(path);
            }
        }
        catch (IOException e) {
            throw new HammerException("\u4f7f\u7528\u8def\u5f84" + packageSearchPath + "\u626b\u63cftpl\u914d\u7f6e\u6587\u4ef6\u65f6I/O\u5f02\u5e38", (Throwable)e);
        }
    }

    private TplExecuteConfigs readConfig(String filePath) {
        String finalFilePath = this.toFinalFilePath(filePath);
        String fileName = StringUtils.substringAfterLast((String)finalFilePath, (String)"/");
        String fileDirectory = StringUtils.substringBeforeLast((String)finalFilePath, (String)"/");
        String name = StringUtils.substringBeforeLast((String)finalFilePath, (String)this.suffix);
        try {
            InputStream in = ClassLoaderUtils.getResourceAsStream((String)finalFilePath, TplConfigFactoryImpl.class);
            if (in == null) {
                throw new HammerException("can not read config from " + finalFilePath + " it may be does not exist");
            }
            TplExecuteConfigs tplExecuteConfigs = (TplExecuteConfigs)this.mapper.readerFor(TplExecuteConfigs.class).readValue(in);
            TplExecuteConfigs newConfigs = new TplExecuteConfigs();
            newConfigs.setFilePath(finalFilePath);
            newConfigs.setName(StringUtils.removeEnd((String)finalFilePath, (String)this.suffix));
            HashSet executeIds = new HashSet();
            tplExecuteConfigs.forEach((k, v) -> {
                TplExecuteConfig config = new TplExecuteConfig();
                if (v instanceof String) {
                    config.setQuery(this.templatePreprocessor.process(v.toString()));
                } else {
                    Object count;
                    Map map = (Map)v;
                    Object query = map.get("query");
                    if (Lang.isNotEmpty(query)) {
                        config.setQuery(this.templatePreprocessor.process(query.toString()));
                    }
                    if (Lang.isNotEmpty(count = map.get("count"))) {
                        config.setCount(this.templatePreprocessor.process(count.toString()));
                    }
                    if (Lang.isNotEmpty(map.get("type"))) {
                        config.setType(TplType.valueOf((String)map.get("type").toString()));
                    }
                }
                this.checkName(executeIds, (String)k, finalFilePath);
                executeIds.add(k);
                config.setTplName(newConfigs.getName() + "@" + k);
                config.setExecuteId(k);
                config.setName(name);
                config.setFileName(fileName);
                config.setFileDirectory(fileDirectory);
                this.logger.debug("filePath -> {} , finalFilePath -> {} ,  {} -> {}", new Object[]{filePath, finalFilePath, k, config});
                newConfigs.put(k, (Object)config);
                if (this.executIdFileMap.containsKey(config.getExecuteId()) && !this.executIdFileMap.get(config.getExecuteId()).equals(finalFilePath)) {
                    this.executIdFileMap.put(config.getExecuteId(), MULTI_SAME_EXECUTEID);
                } else {
                    this.executIdFileMap.put(config.getExecuteId(), finalFilePath);
                }
            });
            this.logger.debug("filePath -> {} , finalFilePath -> {} ,  configs -> {}", new Object[]{filePath, finalFilePath, newConfigs});
            this.configs.put(finalFilePath, newConfigs);
            return newConfigs;
        }
        catch (IOException e) {
            throw new HammerException("exception when read config file " + finalFilePath + " with argu " + filePath, (Throwable)e);
        }
    }

    private String toFinalFilePath(String filePath) {
        String result = filePath;
        if (!result.endsWith(this.suffix) && !(result = result + this.suffix).startsWith("/")) {
            result = this.prefix.endsWith("/") ? this.prefix + result : this.prefix + "/" + result;
        }
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public Collection<TplExecuteConfigs> getAllConfigs() {
        return new ArrayList<TplExecuteConfigs>(this.configs.values());
    }

    public TplExecuteConfigs getConfigs(String filePath) {
        if (this.devMode) {
            return this.readConfig(filePath);
        }
        return this.configs.get(this.toFinalFilePath(filePath));
    }

    private TplExecuteConfigs getConfigs(Class<?> type) {
        if (this.devMode) {
            return this.readConfig(type);
        }
        return this.configs.get(this.getNamespace(type));
    }

    public TplExecuteConfig getConfig(TplExecuteId executeId) {
        if (executeId instanceof TplExecuteIdMapperImpl) {
            TplExecuteConfigs configs = this.getConfigs(((TplExecuteIdMapperImpl)executeId).getMapper());
            if (configs == null) {
                throw new HammerException("configs with type->" + ((TplExecuteIdMapperImpl)executeId).getMapper().getName() + ",namespace->" + executeId.getNamespace() + "  not find");
            }
            TplExecuteConfig config = configs.getConfig(executeId.getName());
            if (config == null) {
                throw new HammerException("executeId " + executeId.getName() + " not find with type->" + executeId.getNamespace() + ",namespace->" + executeId.getNamespace());
            }
            return config;
        }
        if (executeId instanceof TplExecuteIdFileImpl) {
            return this.getConfig(executeId.getId());
        }
        throw new HammerException("Unsupported TplExecuteId type -> " + executeId.getClass().getName());
    }

    public TplExecuteConfig getConfig(String executeId) {
        executeId = StringUtils.substringBeforeLast((String)executeId, (String)".count");
        String[] result = this.getFilePathAndexecuteId(executeId);
        String filePath = null;
        String eId = null;
        if (result.length == 1) {
            filePath = this.getFilePath(executeId);
            eId = executeId;
        } else {
            filePath = result[0];
            eId = result[1];
        }
        TplExecuteConfigs configs = this.getConfigs(filePath);
        if (configs == null) {
            throw new HammerException("file " + filePath + " not find");
        }
        TplExecuteConfig config = configs.getConfig(eId);
        if (config == null) {
            throw new HammerException("executeId " + eId + " not find in " + filePath);
        }
        return config;
    }

    private String[] getFilePathAndexecuteId(String executeId) {
        String[] result = executeId.split("@");
        return result;
    }

    private String getFilePath(String executeId) {
        String file = this.executIdFileMap.get(executeId);
        if (MULTI_SAME_EXECUTEID.equals(file)) {
            throw new HammerException("duplicated executeId[" + executeId + "], you will use full executeId like dir/file" + "@" + executeId);
        }
        return file;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public TemplatePreprocessor getTemplatePreprocessor() {
        return this.templatePreprocessor;
    }
}

