/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.tpl.freemarker;

import cn.featherfly.hammer.HammerException;
import cn.featherfly.hammer.tpl.TemplateEngine;
import cn.featherfly.hammer.tpl.TemplateProcessEnv;
import cn.featherfly.hammer.tpl.TplConfigFactory;
import cn.featherfly.hammer.tpl.TplExecuteConfig;
import cn.featherfly.hammer.tpl.freemarker.FreemarkerDirective;
import cn.featherfly.hammer.tpl.freemarker.FreemarkerMethod;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFreemarkerTemplateEngine<T extends TemplateProcessEnv<FreemarkerDirective, FreemarkerMethod>>
implements TemplateEngine<T, FreemarkerDirective, FreemarkerMethod> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Configuration cfg = new Configuration(Configuration.VERSION_2_3_28);

    public AbstractFreemarkerTemplateEngine(TplConfigFactory configFactory) {
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        configFactory.getAllConfigs().forEach(configs -> configs.values().forEach(c -> {
            TplExecuteConfig config = (TplExecuteConfig)c;
            this.logger.debug("put template name: {}", (Object)config.getTplName());
            templateLoader.putTemplate(config.getTplName(), config.getQuery());
        }));
        this.cfg.setTemplateLoader((TemplateLoader)templateLoader);
    }

    @Override
    public String process(String templateName, String sourceCode, Map<String, Object> params, TemplateProcessEnv<FreemarkerDirective, FreemarkerMethod> templateProcessEnv) {
        this.logger.debug("execute template name : {}", (Object)templateName);
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.putAll(params);
        templateProcessEnv.createDirectives().getDirectiveMapAfterCheck().forEach((k, v) -> root.put((String)k, v));
        templateProcessEnv.createMethods().getMethodeMapAfterCheck().forEach((k, v) -> root.put((String)k, v));
        try {
            StringWriter stringWriter = new StringWriter();
            Template template = new Template(templateName, sourceCode, this.cfg);
            template.process(root, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (TemplateException | IOException e) {
            throw new HammerException(e);
        }
    }
}

