/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.tpl.mapper;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.hammer.HammerException;
import cn.featherfly.hammer.tpl.annotation.Mapper;
import cn.featherfly.hammer.tpl.mapper.TplDynamicExecutorFactory;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.core.type.classreading.MetadataReader;

public class DynamicTplExecutorSpringRegistor
implements BeanDefinitionRegistryPostProcessor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<MetadataReader> metadataReaders;
    private TplDynamicExecutorFactory dynamicExecutorFactory = TplDynamicExecutorFactory.getInstance();
    private String hammerReference;
    private ClassLoader classLoader;

    public DynamicTplExecutorSpringRegistor(String hammerReference) {
        this(null, hammerReference);
    }

    public DynamicTplExecutorSpringRegistor(Set<MetadataReader> metadataReaders, String hammerReference) {
        this(metadataReaders, hammerReference, null);
    }

    public DynamicTplExecutorSpringRegistor(Set<MetadataReader> metadataReaders, String hammerReference, ClassLoader classLoader) {
        this.metadataReaders = metadataReaders;
        this.hammerReference = hammerReference;
        this.classLoader = classLoader;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (Lang.isEmpty(this.metadataReaders)) {
            this.logger.debug("metadataReaders is empty");
            return;
        }
        this.logger.debug("start regist tpl exececutor mapper to spring");
        for (MetadataReader metadataReader : this.metadataReaders) {
            if (!metadataReader.getAnnotationMetadata().hasAnnotation(Mapper.class.getName())) continue;
            try {
                Class type = ClassUtils.forName((String)metadataReader.getClassMetadata().getClassName());
                String dynamicImplName = this.dynamicExecutorFactory.create(type, this.classLoader);
                this.logger.debug("create class {} for {} with hammerReference {}", new Object[]{dynamicImplName, type.getName(), this.hammerReference});
                Class<?> newType = null;
                newType = this.classLoader == null ? ClassUtils.forName((String)dynamicImplName) : this.classLoader.loadClass(dynamicImplName);
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(newType);
                builder.addConstructorArgReference(this.hammerReference);
                builder.setScope("singleton");
                registry.registerBeanDefinition(type.getName(), (BeanDefinition)builder.getBeanDefinition());
            }
            catch (Exception e) {
                throw new HammerException((Throwable)e);
            }
        }
        this.logger.debug("end regist tpl exececutor mapper to spring");
    }

    public Set<MetadataReader> getMetadataReaders() {
        return this.metadataReaders;
    }

    public void setMetadataReaders(Set<MetadataReader> metadataReaders) {
        this.metadataReaders = metadataReaders;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

