/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.tpl.mapper;

import cn.featherfly.common.asm.Asm;
import cn.featherfly.common.exception.ReflectException;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.structure.ChainMap;
import cn.featherfly.common.structure.HashChainMap;
import cn.featherfly.common.structure.page.Page;
import cn.featherfly.common.structure.page.PaginationResults;
import cn.featherfly.hammer.GenericHammer;
import cn.featherfly.hammer.Hammer;
import cn.featherfly.hammer.HammerException;
import cn.featherfly.hammer.tpl.TplExecuteId;
import cn.featherfly.hammer.tpl.TplExecuteIdFileImpl;
import cn.featherfly.hammer.tpl.TplExecuteIdMapperImpl;
import cn.featherfly.hammer.tpl.TplType;
import cn.featherfly.hammer.tpl.annotation.Mapper;
import cn.featherfly.hammer.tpl.annotation.Param;
import cn.featherfly.hammer.tpl.annotation.ParamType;
import cn.featherfly.hammer.tpl.annotation.Template;
import cn.featherfly.hammer.tpl.mapper.BasedMapper;
import cn.featherfly.hammer.tpl.mapper.BasedTplGenericHammer;
import cn.featherfly.hammer.tpl.mapper.BasedTplHammer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ParameterNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.objenesis.instantiator.util.DefineClassHelper;

public class TplDynamicExecutorFactory
extends ClassLoader
implements Opcodes {
    public static final String HAMMER_FIELD_NAME = "hammer";
    public static final String CLASS_NAME_SUFFIX = "$ImplByHammer";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ClassLoader classLoader;
    private Set<Class<?>> types = new HashSet();
    private static final TplDynamicExecutorFactory INSTANCE = new TplDynamicExecutorFactory();
    private Map<Class<?>, Object> typeInstances = new HashMap();
    private final Method putChainMethod;
    private final Method executeMethod;
    private final String executeMethodDescriptor;
    private final Method paginationTypeMethod;
    private final String paginationTypeMethodDescriptor;
    private final Method paginationTypeLimitMethod;
    private final String paginationTypeLimitMethodDescriptor;
    private final Method paginationMapMethod;
    private final String paginationMapMethodDescriptor;
    private final Method paginationMapLimitMethod;
    private final String paginationMapLimitMethodDescriptor;
    private final Method listTypeMethod;
    private final String listTypeMethodDescriptor;
    private final Method listTypePageMethod;
    private final String listTypePageMethodDescriptor;
    private final Method listTypeLimitMethod;
    private final String listTypeLimitMethodDescriptor;
    private final Method listMapMethod;
    private final String listMapMethodDescriptor;
    private final Method listMapPageMethod;
    private final String listMapPageMethodDescriptor;
    private final Method listMapLimitMethod;
    private final String listMapLimitMethodDescriptor;
    private final Method singleTypeMethod;
    private final String singleTypeMethodDescriptor;
    private final Method singleMapMethod;
    private final String singleMapMethodDescriptor;
    private final Method stringMethod;
    private final String stringMethodDescriptor;
    private final Method numberMethod;
    private final String numberMethodDescriptor;
    private final Method intValueMethod;
    private final String intValueMethodDescriptor;
    private final Method longValueMethod;
    private final String longValueMethodDescriptor;
    private final Method doubleValueMethod;
    private final String doubleValueMethodDescriptor;
    private final String hammerDescriptor;
    private final String hammerName;
    private final String paramName;
    private final String paramChainName;
    private final String constructorDescriptor;

    private TplDynamicExecutorFactory() {
        try {
            this.putChainMethod = ChainMap.class.getMethod("putChain", Object.class, Object.class);
            this.executeMethod = Hammer.class.getMethod("execute", TplExecuteId.class, Map.class);
            this.executeMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)this.executeMethod);
            this.listTypeMethod = Hammer.class.getMethod("list", TplExecuteId.class, Class.class, Map.class);
            this.listTypeMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)this.listTypeMethod);
            this.listTypePageMethod = Hammer.class.getMethod("list", TplExecuteId.class, Class.class, Map.class, Page.class);
            this.listTypePageMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)this.listTypePageMethod);
            this.listTypeLimitMethod = Hammer.class.getMethod("list", TplExecuteId.class, Class.class, Map.class, Integer.TYPE, Integer.TYPE);
            this.listTypeLimitMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)this.listTypeLimitMethod);
            this.listMapMethod = Hammer.class.getMethod("list", TplExecuteId.class, Map.class);
            this.listMapMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)this.listMapMethod);
            this.listMapPageMethod = Hammer.class.getMethod("list", TplExecuteId.class, Map.class, Page.class);
            this.listMapPageMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)this.listMapPageMethod);
            this.listMapLimitMethod = Hammer.class.getMethod("list", TplExecuteId.class, Map.class, Integer.TYPE, Integer.TYPE);
            this.listMapLimitMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)this.listMapLimitMethod);
            this.paginationTypeMethod = Hammer.class.getMethod("pagination", TplExecuteId.class, Class.class, Map.class, Page.class);
            this.paginationTypeMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)this.paginationTypeMethod);
            this.paginationTypeLimitMethod = Hammer.class.getMethod("pagination", TplExecuteId.class, Class.class, Map.class, Integer.TYPE, Integer.TYPE);
            this.paginationTypeLimitMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)this.paginationTypeLimitMethod);
            this.paginationMapMethod = Hammer.class.getMethod("pagination", TplExecuteId.class, Map.class, Page.class);
            this.paginationMapMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)this.paginationMapMethod);
            this.paginationMapLimitMethod = Hammer.class.getMethod("pagination", TplExecuteId.class, Map.class, Integer.TYPE, Integer.TYPE);
            this.paginationMapLimitMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)this.paginationMapLimitMethod);
            this.singleTypeMethod = Hammer.class.getMethod("single", TplExecuteId.class, Class.class, Map.class);
            this.singleTypeMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)this.singleTypeMethod);
            this.singleMapMethod = Hammer.class.getMethod("single", TplExecuteId.class, Map.class);
            this.singleMapMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)this.singleMapMethod);
            this.stringMethod = Hammer.class.getMethod("string", TplExecuteId.class, Map.class);
            this.stringMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)this.stringMethod);
            this.numberMethod = Hammer.class.getMethod("number", TplExecuteId.class, Class.class, Map.class);
            this.numberMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)this.numberMethod);
            this.intValueMethod = Hammer.class.getMethod("intValue", TplExecuteId.class, Map.class);
            this.intValueMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)this.intValueMethod);
            this.longValueMethod = Hammer.class.getMethod("longValue", TplExecuteId.class, Map.class);
            this.longValueMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)this.longValueMethod);
            this.doubleValueMethod = Hammer.class.getMethod("doubleValue", TplExecuteId.class, Map.class);
            this.doubleValueMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)this.doubleValueMethod);
            this.hammerDescriptor = org.objectweb.asm.Type.getDescriptor(Hammer.class);
            this.hammerName = org.objectweb.asm.Type.getInternalName(Hammer.class);
            this.paramName = org.objectweb.asm.Type.getInternalName(HashChainMap.class);
            this.paramChainName = org.objectweb.asm.Type.getInternalName(ChainMap.class);
            this.constructorDescriptor = Asm.getConstructorDescriptor((Class[])new Class[]{Hammer.class});
        }
        catch (Exception e) {
            throw new ReflectException((Throwable)e);
        }
    }

    public static TplDynamicExecutorFactory getInstance() {
        return INSTANCE;
    }

    public String create(Class<?> type) throws IOException, NoSuchMethodException, SecurityException {
        return this.create(type, this.getClass().getClassLoader());
    }

    public String create(Class<?> type, ClassLoader classLoader) throws IOException, NoSuchMethodException, SecurityException {
        ClassReader classReader;
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if (this.classLoader == null) {
            this.classLoader = classLoader;
        }
        if (this.classLoader != classLoader) {
            this.clear();
            this.classLoader = classLoader;
        }
        try (InputStream is = classLoader.getResourceAsStream(type.getName().replace('.', '/') + ".class");){
            classReader = new ClassReader(is);
        }
        ClassWriter cw = new ClassWriter(classReader, 1);
        String implClassName = type.getName() + CLASS_NAME_SUFFIX;
        String implClassByteCodeName = Asm.getName((String)implClassName);
        Class parentHammer = null;
        if (!this.types.contains(type)) {
            String globalNamespace = this.getNamespace(type);
            ClassNode cn = new ClassNode();
            cn.version = 52;
            cn.access = 1;
            cn.name = implClassByteCodeName;
            cn.interfaces.add(Asm.getName(type));
            if (ClassUtils.isParent(GenericHammer.class, type)) {
                String typeName = null;
                Class genericType = null;
                Class idType = null;
                for (Type implType : type.getGenericInterfaces()) {
                    ParameterizedType parameterizedType = (ParameterizedType)implType;
                    if (parameterizedType.getRawType() != GenericHammer.class) continue;
                    typeName = parameterizedType.getActualTypeArguments()[0].getTypeName();
                    genericType = ClassUtils.forName((String)typeName);
                    idType = ClassUtils.forName((String)parameterizedType.getActualTypeArguments()[1].getTypeName());
                    break;
                }
                parentHammer = GenericHammer.class;
                cn.superName = org.objectweb.asm.Type.getInternalName(BasedTplGenericHammer.class);
                SignatureWriter signature = new SignatureWriter();
                SignatureVisitor superVisitor = signature.visitSuperclass();
                superVisitor.visitClassType(cn.superName);
                SignatureVisitor typeVisitor = superVisitor.visitTypeArgument('=');
                typeVisitor.visitClassType(org.objectweb.asm.Type.getInternalName((Class)genericType));
                typeVisitor.visitEnd();
                SignatureVisitor idVisitor = superVisitor.visitTypeArgument('=');
                idVisitor.visitClassType(org.objectweb.asm.Type.getInternalName((Class)idType));
                idVisitor.visitEnd();
                superVisitor.visitEnd();
                cn.signature = signature.toString();
                MethodNode constructor = new MethodNode(1, "<init>", this.constructorDescriptor, null, null);
                constructor.visitVarInsn(25, 0);
                constructor.visitVarInsn(25, 1);
                constructor.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)genericType));
                constructor.visitMethodInsn(183, cn.superName, "<init>", Asm.getConstructorDescriptor((Class[])new Class[]{Hammer.class, Class.class}), false);
                constructor.visitInsn(177);
                constructor.visitMaxs(1, 1);
                constructor.visitEnd();
                cn.methods.add(constructor);
            } else {
                if (ClassUtils.isParent(Hammer.class, type)) {
                    parentHammer = Hammer.class;
                    cn.superName = org.objectweb.asm.Type.getInternalName(BasedTplHammer.class);
                } else {
                    parentHammer = BasedMapper.class;
                    cn.superName = org.objectweb.asm.Type.getInternalName(BasedMapper.class);
                }
                MethodNode constructor = new MethodNode(589824, 1, "<init>", this.constructorDescriptor, null, null);
                constructor.visitVarInsn(25, 0);
                constructor.visitVarInsn(25, 1);
                constructor.visitMethodInsn(183, cn.superName, "<init>", this.constructorDescriptor, false);
                constructor.visitInsn(177);
                constructor.visitMaxs(1, 1);
                constructor.visitEnd();
                cn.methods.add(constructor);
            }
            this.addImplMethods(type, globalNamespace, cn, parentHammer);
            cn.accept((ClassVisitor)cw);
            byte[] code = cw.toByteArray();
            DefineClassHelper.defineClass((String)implClassName, (byte[])code, (int)0, (int)code.length, null, (ClassLoader)classLoader, (ProtectionDomain)this.getClass().getProtectionDomain());
            this.types.add(type);
        }
        return implClassName;
    }

    private void clear() {
        this.types.clear();
        this.typeInstances.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addImplMethods(Class<?> type, String globalNamespace, ClassNode classNode, Class<?> parentHammer) throws NoSuchMethodException, SecurityException {
        Map genericTypes = ClassUtils.getInterfaceGenericTypeMap(type, GenericHammer.class);
        for (Method method : type.getDeclaredMethods()) {
            if (method.isDefault() || method.getName().startsWith("$")) continue;
            int localeSize = method.getParameters().length + 1;
            int stackSize = 1;
            MethodNode methodNode = null;
            Method parentMethod = this.getMethodFromParent(parentHammer, method, genericTypes);
            if (parentMethod != null) {
                stackSize = 2;
                String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)method);
                String parentMethodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)parentMethod);
                methodNode = new MethodNode(1, method.getName(), methodDescriptor, null, null);
                methodNode.parameters = new ArrayList();
                methodNode.visitVarInsn(25, 0);
                int size = method.getParameters().length + 1;
                for (int i = 1; i < size; ++i) {
                    methodNode.visitVarInsn(25, i);
                    ParameterNode parameterNode = new ParameterNode(method.getParameters()[i - 1].getName(), 32768);
                    methodNode.parameters.add(parameterNode);
                }
                methodNode.visitMethodInsn(183, classNode.superName, parentMethod.getName(), parentMethodDescriptor, false);
                if (method.getReturnType().isPrimitive()) {
                    if (method.getReturnType() == Integer.TYPE) {
                        methodNode.visitInsn(172);
                    } else if (method.getReturnType() == Byte.TYPE) {
                        methodNode.visitInsn(172);
                    } else if (method.getReturnType() == Short.TYPE) {
                        methodNode.visitInsn(172);
                    } else if (method.getReturnType() == Character.TYPE) {
                        methodNode.visitInsn(172);
                    } else if (method.getReturnType() == Boolean.TYPE) {
                        methodNode.visitInsn(172);
                    } else if (method.getReturnType() == Long.TYPE) {
                        methodNode.visitInsn(173);
                    } else if (method.getReturnType() == Double.TYPE) {
                        methodNode.visitInsn(175);
                    } else if (method.getReturnType() == Float.TYPE) {
                        methodNode.visitInsn(174);
                    } else {
                        methodNode.visitInsn(177);
                    }
                } else {
                    methodNode.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName(method.getReturnType()));
                    methodNode.visitInsn(176);
                }
                methodNode.visitMaxs(stackSize, localeSize);
                methodNode.visitEnd();
            } else {
                ParamPosition position;
                String returnTypeName;
                String executeIdType;
                String namespace = this.getNamespace(method, globalNamespace);
                String name = this.getName(method);
                methodNode = new MethodNode(1, method.getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)method), null, null);
                methodNode.parameters = new ArrayList();
                methodNode.visitVarInsn(25, 0);
                methodNode.visitFieldInsn(180, classNode.name, HAMMER_FIELD_NAME, this.hammerDescriptor);
                TplType tplType = this.getType(method);
                Boolean isTemplate = this.getIsTemplate(method);
                if (isTemplate != null) {
                    executeIdType = org.objectweb.asm.Type.getInternalName(TplExecuteIdMapperImpl.class);
                    methodNode.visitTypeInsn(187, executeIdType);
                    methodNode.visitInsn(89);
                    methodNode.visitLdcInsn((Object)name);
                    methodNode.visitLdcInsn((Object)namespace);
                    methodNode.visitLdcInsn((Object)org.objectweb.asm.Type.getType(type));
                    if (isTemplate.booleanValue()) {
                        methodNode.visitInsn(4);
                    } else {
                        methodNode.visitInsn(3);
                    }
                    methodNode.visitMethodInsn(183, executeIdType, "<init>", Asm.getConstructorDescriptor((Class[])new Class[]{String.class, String.class, Class.class, Boolean.TYPE}), false);
                    stackSize = 7;
                } else {
                    executeIdType = org.objectweb.asm.Type.getInternalName(TplExecuteIdFileImpl.class);
                    methodNode.visitTypeInsn(187, executeIdType);
                    methodNode.visitInsn(89);
                    methodNode.visitLdcInsn((Object)name);
                    methodNode.visitLdcInsn((Object)namespace);
                    methodNode.visitMethodInsn(183, executeIdType, "<init>", Asm.getConstructorDescriptor((Class[])new Class[]{String.class, String.class}), false);
                    stackSize = 5;
                }
                if (method.getReturnType() == Void.TYPE) {
                    this.setParams(methodNode, method);
                    methodNode.visitMethodInsn(185, this.hammerName, this.executeMethod.getName(), this.executeMethodDescriptor, true);
                    methodNode.visitInsn(87);
                    methodNode.visitInsn(177);
                    methodNode.visitMaxs(stackSize, localeSize);
                    methodNode.visitEnd();
                } else if (method.getReturnType() == Integer.TYPE && (tplType == TplType.AUTO || tplType == TplType.EXECUTE)) {
                    this.setParams(methodNode, method);
                    methodNode.visitMethodInsn(185, this.hammerName, this.executeMethod.getName(), this.executeMethodDescriptor, true);
                    methodNode.visitInsn(172);
                    methodNode.visitMaxs(stackSize, localeSize);
                    methodNode.visitEnd();
                } else if (ClassUtils.isParent(List.class, method.getReturnType())) {
                    returnTypeName = this.getReturnTypeName(method);
                    if (ClassUtils.isParent(Map.class, (Class)ClassUtils.forName((String)returnTypeName))) {
                        position = this.setParams(methodNode, method);
                        if (position.limitParamPosition > 0) {
                            methodNode.visitMethodInsn(185, this.hammerName, this.listMapLimitMethod.getName(), this.listMapLimitMethodDescriptor, true);
                        } else if (position.pageParamPosition > 0) {
                            methodNode.visitMethodInsn(185, this.hammerName, this.listMapPageMethod.getName(), this.listMapPageMethodDescriptor, true);
                        } else {
                            methodNode.visitMethodInsn(185, this.hammerName, this.listMapMethod.getName(), this.listMapMethodDescriptor, true);
                        }
                        methodNode.visitInsn(176);
                        methodNode.visitMaxs(stackSize, localeSize);
                        methodNode.visitEnd();
                    } else {
                        methodNode.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)ClassUtils.forName((String)returnTypeName)));
                        position = this.setParams(methodNode, method);
                        if (isTemplate == null && position.commonParamNum > 0) {
                            ++stackSize;
                        }
                        if (position.limitParamPosition > 0) {
                            methodNode.visitMethodInsn(185, this.hammerName, this.listTypeLimitMethod.getName(), this.listTypeLimitMethodDescriptor, true);
                        } else if (position.pageParamPosition > 0) {
                            methodNode.visitMethodInsn(185, this.hammerName, this.listTypePageMethod.getName(), this.listTypePageMethodDescriptor, true);
                        } else {
                            methodNode.visitMethodInsn(185, this.hammerName, this.listTypeMethod.getName(), this.listTypeMethodDescriptor, true);
                        }
                        methodNode.visitInsn(176);
                        methodNode.visitMaxs(stackSize, localeSize);
                        methodNode.visitEnd();
                    }
                } else if (ClassUtils.isParent(PaginationResults.class, method.getReturnType())) {
                    returnTypeName = this.getReturnTypeName(method);
                    if (ClassUtils.isParent(Map.class, (Class)ClassUtils.forName((String)returnTypeName))) {
                        position = this.setParams(methodNode, method);
                        if (position.limitParamPosition > 0) {
                            methodNode.visitMethodInsn(185, this.hammerName, this.paginationMapLimitMethod.getName(), this.paginationMapLimitMethodDescriptor, true);
                        } else {
                            methodNode.visitMethodInsn(185, this.hammerName, this.paginationMapMethod.getName(), this.paginationMapMethodDescriptor, true);
                        }
                        methodNode.visitInsn(176);
                        methodNode.visitMaxs(stackSize, localeSize);
                        methodNode.visitEnd();
                    } else {
                        methodNode.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)ClassUtils.forName((String)returnTypeName)));
                        position = this.setParams(methodNode, method);
                        if (isTemplate == null && position.commonParamNum > 0) {
                            ++stackSize;
                        }
                        if (position.limitParamPosition > 0) {
                            methodNode.visitMethodInsn(185, this.hammerName, this.paginationTypeLimitMethod.getName(), this.paginationTypeLimitMethodDescriptor, true);
                        } else {
                            methodNode.visitMethodInsn(185, this.hammerName, this.paginationTypeMethod.getName(), this.paginationTypeMethodDescriptor, true);
                        }
                        methodNode.visitInsn(176);
                        methodNode.visitMaxs(stackSize, localeSize);
                        methodNode.visitEnd();
                    }
                } else if (ClassUtils.isParent(Number.class, method.getReturnType())) {
                    if (isTemplate == null && method.getParameters().length > 0) {
                        ++stackSize;
                    }
                    methodNode.visitLdcInsn((Object)org.objectweb.asm.Type.getType(method.getReturnType()));
                    this.setParams(methodNode, method);
                    methodNode.visitMethodInsn(185, this.hammerName, this.numberMethod.getName(), this.numberMethodDescriptor, true);
                    methodNode.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName(method.getReturnType()));
                    methodNode.visitInsn(176);
                    methodNode.visitMaxs(stackSize, localeSize);
                    methodNode.visitEnd();
                } else if (method.getReturnType().isPrimitive()) {
                    if (method.getReturnType() == Integer.TYPE) {
                        this.setParams(methodNode, method);
                        methodNode.visitMethodInsn(185, this.hammerName, this.intValueMethod.getName(), this.intValueMethodDescriptor, true);
                        methodNode.visitInsn(172);
                        methodNode.visitMaxs(stackSize, localeSize);
                        methodNode.visitEnd();
                    } else if (method.getReturnType() == Long.TYPE) {
                        this.setParams(methodNode, method);
                        methodNode.visitMethodInsn(185, this.hammerName, this.longValueMethod.getName(), this.longValueMethodDescriptor, true);
                        methodNode.visitInsn(173);
                        methodNode.visitMaxs(stackSize, localeSize);
                        methodNode.visitEnd();
                    } else {
                        if (method.getReturnType() != Double.TYPE) throw new HammerException("unsupport query return type with primitive type " + method.getReturnType() + ", you can use wrapper type instead");
                        this.setParams(methodNode, method);
                        methodNode.visitMethodInsn(185, this.hammerName, this.doubleValueMethod.getName(), this.doubleValueMethodDescriptor, true);
                        methodNode.visitInsn(175);
                        methodNode.visitMaxs(stackSize, localeSize);
                        methodNode.visitEnd();
                    }
                } else if (String.class == method.getReturnType()) {
                    this.setParams(methodNode, method);
                    methodNode.visitMethodInsn(185, this.hammerName, this.stringMethod.getName(), this.stringMethodDescriptor, true);
                    methodNode.visitInsn(176);
                    methodNode.visitMaxs(stackSize, localeSize);
                    methodNode.visitEnd();
                } else if (ClassUtils.isParent(Map.class, method.getReturnType())) {
                    this.setParams(methodNode, method);
                    methodNode.visitMethodInsn(185, this.hammerName, this.singleMapMethod.getName(), this.singleMapMethodDescriptor, true);
                    methodNode.visitInsn(176);
                    methodNode.visitMaxs(stackSize, localeSize);
                    methodNode.visitEnd();
                } else {
                    if (isTemplate == null && method.getParameters().length > 0) {
                        ++stackSize;
                    }
                    methodNode.visitLdcInsn((Object)org.objectweb.asm.Type.getType(method.getReturnType()));
                    this.setParams(methodNode, method);
                    methodNode.visitMethodInsn(185, this.hammerName, this.singleTypeMethod.getName(), this.singleTypeMethodDescriptor, true);
                    methodNode.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName(method.getReturnType()));
                    methodNode.visitInsn(176);
                    methodNode.visitMaxs(stackSize, localeSize);
                    methodNode.visitEnd();
                }
                this.logger.debug("generate method {}", (Object)method.getName());
            }
            if (methodNode == null) continue;
            if (this.logger.isTraceEnabled()) {
                StringBuilder javapString = new StringBuilder();
                javapString.append(methodNode.access + " " + methodNode.name + methodNode.desc).append("\n").append(Strings.format((String)"stack={0},locales={1}", (Object)stackSize, (Object)localeSize)).append("\n");
                for (AbstractInsnNode node : methodNode.instructions) {
                    javapString.append("  ").append(Asm.javapString((AbstractInsnNode)node)).append("\n");
                }
                this.logger.trace(javapString.toString());
            }
            classNode.methods.add(methodNode);
        }
    }

    private ParamPosition setParams(MethodNode methodNode, Method method) throws NoSuchMethodException, SecurityException {
        ParamPosition position = new ParamPosition();
        int commonParamIndex = 1;
        methodNode.visitTypeInsn(187, this.paramName);
        methodNode.visitInsn(89);
        methodNode.visitMethodInsn(183, this.paramName, "<init>", "()V", false);
        block6: for (int paramIndex = 0; paramIndex < method.getParameters().length; ++paramIndex) {
            Parameter parameter = method.getParameters()[paramIndex];
            ParamType paramType = this.getParamType(parameter);
            methodNode.parameters.add(new ParameterNode(parameter.getName(), 32768));
            switch (paramType) {
                case COMMON: {
                    methodNode.visitLdcInsn((Object)this.getParamName(parameter, paramIndex));
                    methodNode.visitVarInsn(Asm.getLoadCode(parameter.getType()), paramIndex + 1);
                    if (parameter.getType().isPrimitive()) {
                        methodNode.visitMethodInsn(184, Asm.getPrimitiveWrapperName(parameter.getType()), "valueOf", Asm.getPrimitiveWrapperMethodDescriptor(parameter.getType()), false);
                    }
                    if (commonParamIndex == 1) {
                        methodNode.visitMethodInsn(182, this.paramName, this.putChainMethod.getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)this.putChainMethod), false);
                    } else {
                        methodNode.visitMethodInsn(185, this.paramChainName, this.putChainMethod.getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)this.putChainMethod), true);
                    }
                    ++commonParamIndex;
                    continue block6;
                }
                case PAGE: {
                    position.pageParamPosition = paramIndex + 1;
                    continue block6;
                }
                case PAGE_OFFSET: {
                    position.offsetParamPosition = paramIndex + 1;
                    continue block6;
                }
                case PAGE_LIMIT: {
                    position.limitParamPosition = paramIndex + 1;
                }
            }
        }
        position.commonParamNum = commonParamIndex - 1;
        if (position.pageParamPosition > 0) {
            methodNode.visitVarInsn(25, position.pageParamPosition);
        } else if (position.limitParamPosition > 0) {
            if (position.offsetParamPosition > 0) {
                methodNode.visitVarInsn(21, position.offsetParamPosition);
                methodNode.visitVarInsn(21, position.limitParamPosition);
            } else {
                methodNode.visitInsn(3);
                methodNode.visitVarInsn(21, position.limitParamPosition);
            }
        }
        return position;
    }

    private Method getMethodFromParent(Class<?> parentHammer, Method method, Map<String, Type> genericTypes) {
        if (parentHammer == null) {
            return null;
        }
        if (ClassUtils.isParent(GenericHammer.class, parentHammer)) {
            for (Method m : parentHammer.getMethods()) {
                if (!this.isOverwrite(m, method, genericTypes)) continue;
                return m;
            }
            return null;
        }
        try {
            return parentHammer.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private boolean isOverwrite(Method method, Method overwriteMethod, Map<String, Type> genericTypes) {
        if (method.getName().equals(overwriteMethod.getName()) && method.getParameterCount() == overwriteMethod.getParameterCount()) {
            if (method.getParameterTypes().equals(overwriteMethod.getParameterTypes())) {
                return true;
            }
            return this.isSameParameter(method, overwriteMethod, genericTypes);
        }
        return false;
    }

    private boolean isSameParameter(Method method, Method overwriteMethod, Map<String, Type> genericTypes) {
        Class[] types = new Class[method.getParameterCount()];
        int i = 0;
        for (Type type : method.getGenericParameterTypes()) {
            if (type instanceof Class) {
                types[i] = (Class)type;
                continue;
            }
            Type genericType = genericTypes.get(type.getTypeName());
            if (genericType == null) {
                return false;
            }
            types[i] = (Class)genericType;
        }
        return true;
    }

    public <E> E newInstance(Class<E> type, Hammer hammer) {
        try {
            return (E)ClassUtils.forName((String)this.create(type)).getConstructor(Hammer.class).newInstance(hammer);
        }
        catch (Exception e) {
            throw new HammerException((Throwable)e);
        }
    }

    public <E> E instance(Class<E> type, Hammer hammer) {
        Object e = null;
        e = this.typeInstances.get(type);
        if (e == null) {
            e = this.newInstance(type, hammer);
            this.typeInstances.put(type, e);
        }
        return (E)e;
    }

    private String getReturnTypeName(Method method) {
        if (method.getGenericReturnType() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
            Type objectType = ClassUtils.getRawType((Type)parameterizedType.getActualTypeArguments()[0]);
            return objectType.getTypeName();
        }
        return method.getName();
    }

    private String getNamespace(Class<?> type) {
        Mapper mapper = type.getAnnotation(Mapper.class);
        if (mapper != null && Lang.isNotEmpty((String)mapper.namespace())) {
            return mapper.namespace();
        }
        return type.getSimpleName();
    }

    private String getNamespace(Method method, String namespace) {
        Template tplExecution = method.getAnnotation(Template.class);
        if (tplExecution != null && Lang.isNotEmpty((String)tplExecution.namespace())) {
            return tplExecution.namespace();
        }
        return namespace;
    }

    private Boolean getIsTemplate(Method method) {
        Template template = method.getAnnotation(Template.class);
        if (template != null && Lang.isNotEmpty((String)template.value())) {
            return template.isTemplate();
        }
        return null;
    }

    private TplType getType(Method method) {
        Template template = method.getAnnotation(Template.class);
        if (template != null && Lang.isNotEmpty((Object)template.type())) {
            return template.type();
        }
        return TplType.AUTO;
    }

    private String getName(Method method) {
        Template tplExecution = method.getAnnotation(Template.class);
        if (tplExecution != null && Lang.isNotEmpty((String)tplExecution.name())) {
            return tplExecution.name();
        }
        return method.getName();
    }

    private String getParamName(Parameter parameter, int paramIndex) {
        Param tplParam = parameter.getAnnotation(Param.class);
        if (tplParam != null && Lang.isNotEmpty((String)tplParam.name())) {
            return tplParam.name();
        }
        if (tplParam != null && Lang.isNotEmpty((String)tplParam.value())) {
            return tplParam.value();
        }
        return parameter.getName();
    }

    private ParamType getParamType(Parameter parameter) {
        Param tplParam = parameter.getAnnotation(Param.class);
        if (tplParam != null) {
            return tplParam.type();
        }
        if (ClassUtils.isParent(Page.class, parameter.getType())) {
            return ParamType.PAGE;
        }
        return ParamType.COMMON;
    }

    private static class ParamPosition {
        int pageParamPosition = -1;
        int offsetParamPosition = -1;
        int limitParamPosition = -1;
        int commonParamNum = 0;
    }
}

