/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.tpl.processor;

import cn.featherfly.hammer.tpl.processor.Element;
import cn.featherfly.hammer.tpl.processor.Parser;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractElement
implements Element {
    protected StringBuilder source = new StringBuilder();
    protected Element parent;
    protected List<Element> childs = new ArrayList<Element>();
    protected int start;
    protected int end;
    protected Parser parser;

    public AbstractElement(Parser parser) {
        this.parser = parser;
    }

    public AbstractElement(String source, Parser parser) {
        this.parser = parser;
        this.source.append(source);
    }

    public AbstractElement(Element parent) {
        this.parent = parent;
    }

    public AbstractElement(Element parent, String value) {
        this.parent = parent;
        this.source.append(value);
    }

    public AbstractElement addChild(Element child) {
        if (child instanceof AbstractElement) {
            AbstractElement ae = (AbstractElement)child;
            ae.parent = this;
        }
        this.childs.add(child);
        return this;
    }

    public AbstractElement append(char c) {
        this.source.append(c);
        return this;
    }

    public AbstractElement append(String str) {
        this.source.append(str);
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [value=" + this.source + "]";
    }

    @Override
    public String getSource() {
        return this.source.toString();
    }

    public void setSource(String source) {
        this.source = new StringBuilder(source);
    }

    @Override
    public Element parent() {
        return this.parent;
    }

    @Override
    public List<Element> childs() {
        return new ArrayList<Element>(this.childs);
    }

    @Override
    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }
}

