/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.tpl.processor;

import cn.featherfly.common.lang.Lang;
import cn.featherfly.hammer.tpl.processor.AbstractElement;
import cn.featherfly.hammer.tpl.processor.Element;
import cn.featherfly.hammer.tpl.processor.Parser;
import java.util.Collection;

public class DirectiveElement
extends AbstractElement {
    protected char directive = (char)64;
    protected char macro = (char)35;

    public DirectiveElement(Parser parser) {
        this("", parser);
    }

    public DirectiveElement(String value, Parser parser) {
        super(value, parser);
    }

    @Override
    public String getValue() {
        if (Lang.isEmpty((Collection)this.childs)) {
            return this.wrapDirective();
        }
        return this.getValue(this);
    }

    protected String wrapDirective() {
        if (this.isReplaceable()) {
            boolean isEndWith;
            boolean isStartWith = this.source.charAt(2) == this.parser.getFuzzyQueryChar();
            boolean bl = isEndWith = this.source.charAt(this.source.length() - 1) == this.parser.getFuzzyQueryChar();
            if (isStartWith && isEndWith) {
                return this.source.substring(3, this.source.length() - 1);
            }
            if (isEndWith) {
                return this.source.substring(2, this.source.length() - 1);
            }
            if (isStartWith) {
                return this.source.substring(3);
            }
            return this.source.substring(2);
        }
        if (this.isEnclosed()) {
            return this.getString(false, true);
        }
        if (this.isEnd()) {
            return this.appendAfterChilds();
        }
        return this.appendBeforeChilds();
    }

    protected String getValue(Element element) {
        if (Lang.isEmpty(element.childs())) {
            return element.getValue();
        }
        StringBuilder sb = new StringBuilder();
        if (element instanceof DirectiveElement) {
            sb.append(((DirectiveElement)element).appendBeforeChilds());
        }
        for (Element child : element.childs()) {
            sb.append(this.getValue(child));
        }
        if (element instanceof DirectiveElement) {
            sb.append(((DirectiveElement)element).appendAfterChilds());
        }
        return sb.toString();
    }

    protected String appendBeforeChilds() {
        return this.getString(false, false);
    }

    protected String appendAfterChilds() {
        return this.getString(true, false);
    }

    private String getString(boolean isEndDirective, boolean isEnclosed) {
        char sign = this.directive;
        if (this.getName().equals("if")) {
            sign = this.macro;
        }
        String directiveEnd = "";
        if (isEndDirective) {
            directiveEnd = "/";
        }
        String enclosed = "";
        if (isEnclosed) {
            enclosed = "/";
        }
        String content = null;
        content = isEndDirective ? this.getName() : this.getNameAndAttr();
        return "<" + directiveEnd + sign + content + enclosed + ">";
    }

    public String getNameAndAttr() {
        return this.parser.directiveNameAndAttr(this.source.toString());
    }

    public String getName() {
        return this.parser.directiveName(this.source.toString());
    }

    public boolean isCondition() {
        return this.parser.isCondition(this.source.toString());
    }

    public boolean isEnd() {
        return this.source.charAt(0) == '>';
    }

    public boolean isReplaceable() {
        return this.parser.isReplaceable(this.source.toString());
    }

    public String getReplace() {
        return this.source.substring(2);
    }

    public boolean isGroupStart() {
        if (this.source.length() == 0) {
            return false;
        }
        return this.source.charAt(0) == '<' && this.source.length() > 1 && this.source.charAt(1) != '<';
    }

    public boolean isWrapper() {
        return this.parser.isWrapper(this.source.toString());
    }

    public boolean isEmptyConditionParam() {
        return this.parser.isEmptyConditionParam(this.source.toString());
    }

    public boolean isEnclosed() {
        return this.parser.isEnclosed(this.source.toString());
    }
}

