/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.tpl.processor;

import cn.featherfly.common.lang.Strings;
import cn.featherfly.hammer.tpl.TplException;
import cn.featherfly.hammer.tpl.processor.AbstractElement;
import cn.featherfly.hammer.tpl.processor.DirectiveElement;
import cn.featherfly.hammer.tpl.processor.StringElement;
import cn.featherfly.hammer.tpl.processor.StringPart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Parser {
    private char[] directiveStart = new char[]{'/', '*'};
    private char[] directiveEnd = new char[]{'*', '/'};
    private char startDirecitve = (char)60;
    private char endDirecitve = (char)62;
    private char namedParamStart = (char)58;
    private char fuzzyQueryChar = (char)37;
    private char[] namedParamEnds = new char[]{this.directiveEnd[0], ' ', '\n', this.fuzzyQueryChar};
    private String source;
    private AbstractElement parentElement;
    List<AbstractElement> elements = new ArrayList<AbstractElement>();

    private Parser(Parser parent, AbstractElement parentElement) {
        this.directiveStart = parent.directiveStart;
        this.directiveEnd = parent.directiveEnd;
        this.startDirecitve = parent.startDirecitve;
        this.endDirecitve = parent.endDirecitve;
        this.parentElement = parentElement;
    }

    public Parser() {
    }

    public Parser(char[] directiveStart, char[] directiveEnd, char startDirecitve, char endDirecitve) {
        this.directiveStart = directiveStart;
        this.directiveEnd = directiveEnd;
        this.startDirecitve = startDirecitve;
        this.endDirecitve = endDirecitve;
    }

    public void parse(String source) {
        char c = '\u0000';
        char c2 = '\u0000';
        AbstractElement element = null;
        int index = 0;
        while (index < source.length()) {
            DirectiveElement de;
            c = source.charAt(index);
            c2 = index + 1 < source.length() ? source.charAt(index + 1) : (char)'\u0000';
            if (element instanceof DirectiveElement && ((DirectiveElement)element).isGroupStart()) {
                de = (DirectiveElement)element;
                if (!de.isEnclosed()) {
                    int wrapIndex;
                    Directive directive = this.getEndDirective(source, (DirectiveElement)element);
                    Parser parser = new Parser(this, element);
                    int substart = element.getEnd() + 1;
                    if (de.getName().equals("where") && source.substring(substart, wrapIndex = this.wrapString(source, substart)).trim().equalsIgnoreCase("where")) {
                        substart = wrapIndex;
                    }
                    if (de.isCondition()) {
                        wrapIndex = this.wrapString(source, substart);
                        String ss = source.substring(substart, wrapIndex).trim();
                        if (ss.equalsIgnoreCase("and")) {
                            de.setSource(de.getSource().replaceAll("\\?", "") + "and");
                            substart = wrapIndex;
                        } else if (ss.equalsIgnoreCase("or")) {
                            de.setSource(de.getSource().replaceAll("\\?", "") + "or");
                            substart = wrapIndex;
                        }
                    }
                    String subSource = source.substring(substart, directive.start);
                    parser.parse(subSource);
                    index = directive.end;
                    element = null;
                }
            } else if (this.isDirectiveStart(c, c2)) {
                Directive directive = this.parseDirective(source, index);
                element = new DirectiveElement(directive.content, this);
                this.addElement(element);
                element.setEnd(directive.end);
                element.setStart(directive.start);
                index = directive.end;
            } else {
                if (!(element instanceof StringElement)) {
                    de = null;
                    if (element != null) {
                        de = (DirectiveElement)element;
                    }
                    element = new StringElement(this);
                    this.addElement(element);
                    if (de != null) {
                        if (de.isWrapper()) {
                            int wrapIndex = this.wrapString(source, index, de.isCondition());
                            int subStart = index;
                            if (de.isCondition()) {
                                boolean startWith;
                                boolean endWith;
                                String paramContent;
                                int logicIndex = this.wrapString(source, index, false);
                                String ss = source.substring(index, logicIndex).trim();
                                String pre = null;
                                String append = "";
                                String name = "";
                                if (ss.equalsIgnoreCase("and")) {
                                    pre = "<and if=";
                                    subStart = logicIndex + 1;
                                } else if (ss.equalsIgnoreCase("or")) {
                                    pre = "<or if=";
                                    subStart = logicIndex + 1;
                                } else {
                                    pre = "<and if=";
                                }
                                if (de.isEmptyConditionParam()) {
                                    paramContent = source.substring(index, wrapIndex);
                                    StringPart namePart = this.getFirstParamName(paramContent);
                                    name = namePart.getValue();
                                    if (this.isConditionNull(de.getSource())) {
                                        append = "?";
                                    } else if (this.isConditionNullOrEmpty(de.getSource())) {
                                        append = this.isInCondition(source.substring(index, wrapIndex)) ? " && " + name + "?size gt 0" : " && " + name + "?length gt 0";
                                    }
                                    endWith = paramContent.charAt(namePart.getStart() - 2) == this.fuzzyQueryChar;
                                    startWith = paramContent.charAt(namePart.getEnd()) == this.fuzzyQueryChar;
                                    append = this.appendTransverter(endWith, startWith, append);
                                    de.setSource(pre + name + de.getSource() + append + " name=\"" + name + "\"");
                                } else {
                                    name = de.getSource().replaceAll("\\?", "");
                                    if (this.isConditionNull(de.getSource())) {
                                        append = "??";
                                    } else if (this.isConditionNullOrEmpty(de.getSource())) {
                                        append = this.isInCondition(source.substring(index, wrapIndex)) ? "?? && " + name + "?size gt 0" : "?? && " + name + "?length gt 0";
                                    }
                                    paramContent = source.substring(index, wrapIndex);
                                    String fuzzyStr = paramContent.chars().filter(i -> i == this.fuzzyQueryChar || i == this.namedParamStart || i == 63).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
                                    endWith = fuzzyStr.indexOf(this.fuzzyQueryChar) == 0;
                                    startWith = fuzzyStr.lastIndexOf(this.fuzzyQueryChar) == fuzzyStr.length() - 1;
                                    append = this.appendTransverter(endWith, startWith, append);
                                    de.setSource(pre + name + append + " name=\"" + name + "\"");
                                }
                                Parser parser = new Parser(this, de);
                                parser.parse(source.substring(subStart, wrapIndex));
                            } else {
                                de.addChild(new StringElement(source.substring(index, wrapIndex), this));
                            }
                            index = wrapIndex;
                            continue;
                        }
                        if (de.isReplaceable()) {
                            int logicIndex;
                            index = logicIndex = this.wrapString(source, index, false);
                            continue;
                        }
                    }
                }
                element.append(c);
            }
            ++index;
        }
    }

    private String appendTransverter(boolean endWith, boolean startWith, String append) {
        if (startWith && endWith) {
            append = append + " transverter='CO'";
        } else if (startWith) {
            append = append + " transverter='SW'";
        } else if (endWith) {
            append = append + " transverter='EW'";
        }
        return append;
    }

    private boolean isInCondition(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != 'i' && c != 'I') continue;
            if (value.length() == i + 1) {
                return false;
            }
            char c2 = value.charAt(i + 1);
            return c2 == 'n' || c2 == 'N';
        }
        return false;
    }

    private StringPart getFirstParamName(String value, boolean autoEnd) {
        StringBuilder sb = new StringBuilder();
        int start = 0;
        int end = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            end = i;
            if (c == this.namedParamStart) {
                start = i;
                sb.append(c);
                continue;
            }
            if (sb.length() <= 0) continue;
            if (this.isNamedParamEnd(c)) {
                sb.deleteCharAt(0);
                return new StringPart(++start, end, sb.toString());
            }
            sb.append(c);
        }
        if (sb.length() > 0 && !autoEnd) {
            throw new TplException("\u683c\u5f0f\u9519\u8bef\uff0c\u672a\u627e\u5230\u5339\u914d\u7684\u7ed3\u675f\u7b26\u53f7");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(0);
            ++start;
        }
        return new StringPart(start, end, sb.toString());
    }

    private StringPart getFirstParamName(String value) {
        return this.getFirstParamName(value, true);
    }

    private boolean isNamedParamEnd(char c) {
        for (int i = 0; i < this.namedParamEnds.length; ++i) {
            if (this.namedParamEnds[i] != c) continue;
            return true;
        }
        return false;
    }

    private int wrapString(String value, int start) {
        return this.wrapString(value, start, false);
    }

    private int wrapString(String value, int start, boolean onlyNewLine) {
        int index;
        char c = '\u0000';
        boolean notWhitespace = false;
        for (index = start; index < value.length(); ++index) {
            char c2;
            c = value.charAt(index);
            if (!notWhitespace && !Character.isWhitespace(c)) {
                notWhitespace = true;
            }
            if (c == this.directiveStart[0] && value.length() < index + 1 && (c2 = value.charAt(index + 1)) == this.directiveStart[1]) {
                return index;
            }
            if (!(onlyNewLine ? notWhitespace && c == '\n' : notWhitespace && (c == ' ' || c == '\n'))) continue;
            return index;
        }
        if (index == start) {
            return -1;
        }
        return index;
    }

    public NullType getNullType(String value) {
        if (value.length() == 0) {
            return null;
        }
        if (value.charAt(0) == '?') {
            if (value.length() == 1) {
                return NullType.NULL;
            }
            if (value.charAt(value.length() - 1) == '?') {
                return NullType.EMPTY;
            }
            return NullType.NULL;
        }
        if (value.charAt(value.length() - 1) == '?') {
            if (value.length() - 2 >= 0 && value.charAt(value.length() - 2) == '?') {
                return NullType.EMPTY;
            }
            return NullType.NULL;
        }
        return null;
    }

    public boolean isCondition(String value) {
        return this.getNullType(value) != null;
    }

    public boolean isConditionNull(String value) {
        NullType type = this.getNullType(value);
        return type != null && type == NullType.NULL;
    }

    public boolean isConditionNullOrEmpty(String value) {
        NullType type = this.getNullType(value);
        return type != null && type == NullType.EMPTY;
    }

    private Directive parseDirective(String value, int start) {
        char c = '\u0000';
        char c2 = '\u0000';
        Directive directive = new Directive();
        directive.start = start;
        for (int index = start; index < value.length(); ++index) {
            c = value.charAt(index);
            if (this.isDirectiveStart(c, c2 = index + 1 < value.length() ? value.charAt(index + 1) : (char)'\u0000')) {
                directive.start = index;
                continue;
            }
            if (!this.isDirectiveEnd(c, c2)) continue;
            directive.end = index + this.directiveEnd.length - 1;
            break;
        }
        if (directive.start != -1 && directive.end != -1) {
            directive.setSource(value.substring(directive.start, directive.end + 1), this);
            return directive;
        }
        throw new TplException("\u89e3\u6790\u6307\u4ee4\u51fa\u9519\uff0c \u6ca1\u6709\u627e\u5230\u6307\u4ee4\u7ed3\u675f\u7b26\u53f7" + Arrays.toString(this.directiveEnd));
    }

    private Directive getEndDirective(String value, DirectiveElement directiveElement) {
        char c = '\u0000';
        char c2 = '\u0000';
        Directive directive = new Directive();
        directive.start = directiveElement.getStart();
        for (int index = directiveElement.getStart(); index < value.length(); ++index) {
            c = value.charAt(index);
            if (this.isDirectiveStart(c, c2 = index + 1 < value.length() ? value.charAt(index + 1) : (char)'\u0000')) {
                directive.start = index;
                continue;
            }
            if (!this.isDirectiveEnd(c, c2)) continue;
            directive.end = index + this.directiveEnd.length - 1;
            if (directive.start == -1 || directive.end == -1) continue;
            directive.setSource(value.substring(directive.start, directive.end + 1), this);
            if (directive.content.charAt(0) != this.endDirecitve || !directive.name.equals(directiveElement.getName())) continue;
            directive.end = index + this.directiveEnd.length - 1;
            return directive;
        }
        throw new TplException(Strings.format((String)"\u6ca1\u6709\u627e\u5230\u6807\u7b7e[{0}]\u5bf9\u5e94\u7684\u7ed3\u675f\u6807\u7b7e", (Object)directiveElement.getSource()));
    }

    private void addElement(AbstractElement element) {
        if (this.parentElement != null) {
            this.parentElement.addChild(element);
        } else {
            this.elements.add(element);
        }
    }

    private boolean isDirectiveStart(char c, char c2) {
        return this.directiveStart[0] == c && this.directiveStart[1] == c2;
    }

    private boolean isDirectiveEnd(char c, char c2) {
        return this.directiveEnd[0] == c && this.directiveEnd[1] == c2;
    }

    public String directiveContent(String directiveSouce) {
        return directiveSouce.substring(this.directiveStart.length, directiveSouce.length() - this.directiveStart.length);
    }

    public String directiveNameAndAttr(String directiveContent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < directiveContent.length(); ++i) {
            char c = directiveContent.charAt(i);
            if (i < 2) {
                if (c == this.startDirecitve || c == this.endDirecitve || c == '@') continue;
                sb.append(c);
                continue;
            }
            if (i == directiveContent.length() - 1) {
                if (c == this.endDirecitve) continue;
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String directiveName(String directiveContent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < directiveContent.length(); ++i) {
            char c = directiveContent.charAt(i);
            if (c == ' ' || c == '\n') {
                return sb.toString();
            }
            if (c == '<' || c == '>') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public boolean isWrapper(String directiveContent) {
        boolean b;
        if (directiveContent.length() == 0) {
            return false;
        }
        boolean bl = b = directiveContent.charAt(0) == this.startDirecitve;
        if (b) {
            return directiveContent.length() > 1 && directiveContent.charAt(1) == this.startDirecitve;
        }
        b = this.isEmptyConditionParam(directiveContent);
        return b ? b : Character.isLetter(directiveContent.charAt(0));
    }

    public boolean isEmptyConditionParam(String directiveContent) {
        String v = directiveContent.trim();
        if (v.length() == 1) {
            return v.charAt(0) == '?';
        }
        if (v.length() == 2) {
            return v.charAt(0) == '?' && v.charAt(1) == '?';
        }
        return false;
    }

    public boolean isReplaceable(String directiveContent) {
        return directiveContent.charAt(0) == '$';
    }

    public boolean isEnclosed(String directiveContent) {
        return directiveContent.charAt(directiveContent.length() - 1) == this.endDirecitve;
    }

    public String directiveNameFromSource(String directiveSouce) {
        return this.directiveName(directiveSouce.substring(this.directiveStart.length, directiveSouce.length() - this.directiveEnd.length));
    }

    public String toString() {
        return "Parser [source=" + this.source + "]";
    }

    public List<AbstractElement> getElements() {
        return this.elements;
    }

    public char[] getDirectiveStart() {
        return this.directiveStart;
    }

    public void setDirectiveStart(char[] directiveStart) {
        this.directiveStart = directiveStart;
    }

    public char[] getDirectiveEnd() {
        return this.directiveEnd;
    }

    public void setDirectiveEnd(char[] directiveEnd) {
        this.directiveEnd = directiveEnd;
    }

    public char getStartDirecitve() {
        return this.startDirecitve;
    }

    public void setStartDirecitve(char startDirecitve) {
        this.startDirecitve = startDirecitve;
    }

    public char getEndDirecitve() {
        return this.endDirecitve;
    }

    public void setEndDirecitve(char endDirecitve) {
        this.endDirecitve = endDirecitve;
    }

    public char getNamedParamStart() {
        return this.namedParamStart;
    }

    public void setNamedParamStart(char namedParamStart) {
        this.namedParamStart = namedParamStart;
    }

    public char getFuzzyQueryChar() {
        return this.fuzzyQueryChar;
    }

    public void setFuzzyQueryChar(char fuzzyQueryChar) {
        this.fuzzyQueryChar = fuzzyQueryChar;
    }

    public char[] getNamedParamEnds() {
        return this.namedParamEnds;
    }

    public void setNamedParamEnds(char[] namedParamEnds) {
        this.namedParamEnds = namedParamEnds;
    }

    private static class Directive {
        int start = -1;
        int end = -1;
        String name;
        String source;
        String content;

        Directive() {
        }

        public void setSource(String source, Parser parser) {
            this.source = source;
            this.content = parser.directiveContent(source);
            this.name = parser.directiveName(this.content);
        }

        public String toString() {
            return "Directive [start=" + this.start + ", end=" + this.end + ", source=" + this.source + ", content=" + this.content + "]";
        }
    }

    public static enum NullType {
        NULL,
        EMPTY;

    }
}

