/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.hammer.tpl.supports;

import cn.featherfly.common.lang.Lang;
import cn.featherfly.hammer.tpl.supports.ConditionGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ConditionParamsManager {
    private Boolean paramNamed;
    private int amount = 0;
    private Map<String, Param> paramNames = new HashMap<String, Param>();
    private Map<Integer, String> paramValuesMap = new TreeMap<Integer, String>((o1, o2) -> {
        if (o1 > o2) {
            return 1;
        }
        if (o1 < o2) {
            return -1;
        }
        return 0;
    });
    private ConditionGroup rootGroup;
    private ConditionGroup currentGroup = this.rootGroup = new ConditionGroup();

    public void addParam(String paramName) {
        this.addParam(new Param(paramName, null));
    }

    public void addParams(Collection<String> paramNames) {
        if (Lang.isEmpty(paramNames)) {
            return;
        }
        for (String paramName : paramNames) {
            this.addParam(new Param(paramName, null));
        }
    }

    public void addParam(Param param) {
        this.paramValuesMap.put(this.amount, param.getName());
        this.paramNames.put(param.getName(), param);
        ++this.amount;
        this.currentGroup.addCondition();
    }

    public int getAmount() {
        return this.paramValuesMap.size();
    }

    public List<String> getParamNames() {
        return new ArrayList<String>(this.paramValuesMap.values());
    }

    public List<Param> getParams() {
        return new ArrayList<Param>(this.paramNames.values());
    }

    public void startGroup() {
        ConditionGroup group = new ConditionGroup();
        this.currentGroup.addChild(group);
        this.currentGroup = group;
    }

    public void endGroup() {
        this.currentGroup = this.currentGroup.getParent();
    }

    public boolean isNeedAppendLogicWorld() {
        if (this.currentGroup == this.rootGroup) {
            return this.amount > 0;
        }
        return this.currentGroup.getAmount() > 0 && this.amount > 0;
    }

    public Boolean getParamNamed() {
        return this.paramNamed;
    }

    public void setParamNamed(Boolean paramNamed) {
        this.paramNamed = paramNamed;
    }

    public boolean containsName(String paramName) {
        return this.paramValuesMap.containsValue(paramName);
    }

    public Param getParam(String paramName) {
        return this.paramNames.get(paramName);
    }

    public static class Param {
        private String name;
        private String transverter;

        public Param() {
        }

        public Param(String name, String transverter) {
            this.name = name;
            this.transverter = transverter;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTransverter() {
            return this.transverter;
        }

        public void setTransverter(String transverter) {
            this.transverter = transverter;
        }
    }
}

