/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.callback;

import cn.felord.callback.ByteCollector;
import cn.felord.callback.CallbackAsyncConsumer;
import cn.felord.callback.CallbackDecrypted;
import cn.felord.callback.CallbackSettings;
import cn.felord.callback.CallbackXmlResponse;
import cn.felord.callback.PKCS7Encoder;
import cn.felord.callback.XmlEntity;
import cn.felord.utils.Algorithms;
import cn.felord.utils.Base64Utils;
import cn.felord.utils.StringUtils;
import cn.felord.xml.XmlReader;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class AbstractCallbackCrypto<EVENT> {
    private static final String BOM = "\ufeff";
    private static final String BASE_ = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final String MSG = "{\"encrypt\":\"%1$s\",\"msgsignature\":\"%2$s\",\"timestamp\":\"%3$s\",\"nonce\":\"%4$s\"}";
    private static final Random RANDOM = new SecureRandom();
    private final XmlReader xmlReader;
    private final CallbackAsyncConsumer<EVENT> callbackAsyncConsumer;

    public AbstractCallbackCrypto(XmlReader xmlReader, CallbackAsyncConsumer<EVENT> callbackAsyncConsumer) {
        this.xmlReader = xmlReader;
        this.callbackAsyncConsumer = callbackAsyncConsumer;
    }

    public String encrypt(String receiveid, byte[] aesKey, String randomStr, String text) throws IllegalArgumentException {
        byte[] randomStrBytes = randomStr.getBytes(StandardCharsets.UTF_8);
        byte[] textBytes = text.getBytes(StandardCharsets.UTF_8);
        byte[] networkBytesOrder = this.getNetworkBytesOrder(textBytes.length);
        byte[] receiveidBytes = receiveid.getBytes(StandardCharsets.UTF_8);
        int byteSize = receiveidBytes.length + textBytes.length + networkBytesOrder.length + receiveidBytes.length;
        ByteCollector byteCollector = new ByteCollector().addBytes(randomStrBytes).addBytes(networkBytesOrder).addBytes(textBytes).addBytes(receiveidBytes).addBytes(PKCS7Encoder.encode(byteSize));
        byte[] unencrypted = byteCollector.toBytes();
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(aesKey, 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            byte[] encrypted = cipher.doFinal(unencrypted);
            return Base64Utils.encodeToString(encrypted);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error when encrypt with AES", e);
        }
    }

    private CallbackDecrypted decrypt(byte[] aesKey, String text) throws IllegalArgumentException {
        byte[] original;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec spec = new SecretKeySpec(aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(aesKey, 0, 16));
            cipher.init(2, (Key)spec, iv);
            original = cipher.doFinal(Base64Utils.decodeFromString(text));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error when decrypt with AES", e);
        }
        try {
            byte[] bytes = PKCS7Encoder.decode(original);
            int to = 20;
            byte[] networkOrder = Arrays.copyOfRange(bytes, 16, to);
            int jsonLength = this.recoverNetworkBytesOrder(networkOrder);
            String jsonContent = new String(Arrays.copyOfRange(bytes, to, to + jsonLength), StandardCharsets.UTF_8);
            String fromReceiveid = new String(Arrays.copyOfRange(bytes, to + jsonLength, bytes.length), StandardCharsets.UTF_8);
            String content = jsonContent.startsWith(BOM) ? jsonContent.substring(1) : jsonContent;
            return new CallbackDecrypted(content, fromReceiveid);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid buffer when callback decrypted", e);
        }
    }

    public String encryptJsonMsg(CallbackSettings callbackSettings, String replyMsg, String timeStamp, String nonce) {
        String receiveid = callbackSettings.getReceiveid();
        String encrypt = this.encrypt(receiveid, callbackSettings.getAesKey(), this.randomStr(), replyMsg);
        if (!StringUtils.hasText(timeStamp)) {
            timeStamp = Long.toString(System.currentTimeMillis());
        }
        String token = callbackSettings.getToken();
        String signature = Algorithms.sha1Signature(token, timeStamp, nonce, encrypt);
        return String.format(MSG, encrypt, signature, timeStamp, nonce);
    }

    public String encryptXmlMsg(CallbackSettings callbackSettings, String replyMsg, String timeStamp, String nonce) {
        String receiveid = callbackSettings.getReceiveid();
        String encrypt = this.encrypt(receiveid, callbackSettings.getAesKey(), this.randomStr(), replyMsg);
        if (!StringUtils.hasText(timeStamp)) {
            timeStamp = Long.toString(Instant.now().toEpochMilli());
        }
        String token = callbackSettings.getToken();
        String signature = Algorithms.sha1Signature(token, timeStamp, nonce, encrypt);
        CallbackXmlResponse callbackXmlResponse = new CallbackXmlResponse(encrypt, signature, timeStamp, nonce);
        return this.xmlReader.write(callbackXmlResponse);
    }

    public <T> T accept(EVENT eventBody, T response) {
        this.callbackAsyncConsumer.asyncAction(eventBody);
        return response;
    }

    public CallbackDecrypted decrypt(CallbackSettings callbackSettings, String msgSignature, String timeStamp, String nonce, String encrypt) {
        String token = callbackSettings.getToken();
        String signature = Algorithms.sha1Signature(token, timeStamp, nonce, encrypt);
        if (!Objects.equals(msgSignature, signature)) {
            throw new IllegalArgumentException("callback signature not matched");
        }
        byte[] aesKey = callbackSettings.getAesKey();
        return this.decrypt(aesKey, encrypt);
    }

    public <T extends XmlEntity> T readXml(String xmlBody, Class<T> clazz) {
        return this.xmlReader.read(xmlBody, clazz);
    }

    byte[] getNetworkBytesOrder(int sourceNumber) {
        byte[] orderBytes = new byte[4];
        orderBytes[3] = (byte)(sourceNumber & 0xFF);
        orderBytes[2] = (byte)(sourceNumber >> 8 & 0xFF);
        orderBytes[1] = (byte)(sourceNumber >> 16 & 0xFF);
        orderBytes[0] = (byte)(sourceNumber >> 24 & 0xFF);
        return orderBytes;
    }

    int recoverNetworkBytesOrder(byte[] orderBytes) {
        int sourceNumber = 0;
        for (int i = 0; i < 4; ++i) {
            sourceNumber <<= 8;
            sourceNumber |= orderBytes[i] & 0xFF;
        }
        return sourceNumber;
    }

    String randomStr() {
        return RANDOM.ints(16L, 0, BASE_.length()).mapToObj(BASE_::charAt).collect(StringBuffer::new, StringBuffer::append, StringBuffer::append).toString();
    }
}

