/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.utils;

import cn.felord.utils.Base64Utils;
import cn.felord.utils.Hex;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class Algorithms {
    private Algorithms() {
    }

    public static String sha1Signature(String token, String timestamp, String nonce, String encrypt) throws IllegalArgumentException {
        try {
            String str = Stream.of(token, timestamp, nonce, encrypt).sorted().collect(Collectors.joining());
            return Algorithms.sha1Hex(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("SHA-1 signature error", e);
        }
    }

    public static String sha1Hex(String format) {
        MessageDigest SHA1;
        try {
            SHA1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("algorithm sha-1 init error", e);
        }
        SHA1.update(format.getBytes(StandardCharsets.UTF_8));
        byte[] bytes = SHA1.digest();
        return Hex.encodeHexString(bytes);
    }

    public static String hmacSha256Hex(String src, String secret, boolean upperCase) {
        Mac HMAC_SHA256;
        try {
            HMAC_SHA256 = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("algorithm hmac-sha256 init error", e);
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), HMAC_SHA256.getAlgorithm());
        try {
            HMAC_SHA256.init(secretKeySpec);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Hmac-sha256 encode error", e);
        }
        byte[] bytes = HMAC_SHA256.doFinal(src.getBytes(StandardCharsets.UTF_8));
        String encodeHexString = Hex.encodeHexString(bytes);
        return upperCase ? encodeHexString.toUpperCase() : encodeHexString;
    }

    public static String md5Hex(String src, boolean upperCase) {
        return Algorithms.md5Hex(src.getBytes(StandardCharsets.UTF_8), upperCase);
    }

    public static String md5Hex(byte[] src, boolean upperCase) {
        MessageDigest MD5;
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("algorithm md5 init error", e);
        }
        MD5.update(src);
        byte[] bytes = MD5.digest();
        String encodeHexString = Hex.encodeHexString(bytes);
        return upperCase ? encodeHexString.toUpperCase() : encodeHexString;
    }

    public static String aesDecode(byte[] aesKey, String associatedData, String nonce, String ciphertext) {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            SecretKeySpec secretKeySpec = new SecretKeySpec(aesKey, "AES");
            GCMParameterSpec spec = new GCMParameterSpec(128, nonce.getBytes(StandardCharsets.UTF_8));
            cipher.init(2, (Key)secretKeySpec, spec);
            cipher.updateAAD(associatedData.getBytes(StandardCharsets.UTF_8));
            byte[] bytes = cipher.doFinal(Base64Utils.decodeFromString(ciphertext));
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalArgumentException("Aes decrypt error", e);
        }
    }
}

