/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.xml;

import cn.felord.callback.XmlEntity;
import cn.felord.xml.UnixInstantConverter;
import cn.felord.xml.XmlReader;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class XStreamXmlReader
implements XmlReader {
    private static final Map<Class<?>, XStream> X_STREAM_HOLDER = new ConcurrentHashMap();
    private static final XmlFriendlyNameCoder NAME_CODER = new XmlFriendlyNameCoder("_-", "_");
    private static final DomDriver DOM_DRIVER = new DomDriver("UTF-8", (NameCoder)NAME_CODER);
    public static final XStreamXmlReader INSTANCE = new XStreamXmlReader();

    XStreamXmlReader() {
    }

    @Override
    public <T extends XmlEntity> T read(String xml, Class<T> clazz) {
        return (T)((XmlEntity)X_STREAM_HOLDER.computeIfAbsent(clazz, XStreamXmlReader::newXStream).fromXML(xml));
    }

    @Override
    public <T extends XmlEntity> String write(T t) {
        return X_STREAM_HOLDER.computeIfAbsent(t.getClass(), XStreamXmlReader::newXStream).toXML(t);
    }

    private static XStream newXStream(Class<?> clazz) {
        XStream xStream = new XStream((HierarchicalStreamDriver)DOM_DRIVER);
        xStream.allowTypeHierarchy(XmlEntity.class);
        xStream.registerConverter((SingleValueConverter)new UnixInstantConverter());
        xStream.ignoreUnknownElements();
        xStream.processAnnotations(clazz);
        return xStream;
    }
}

