/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.bytecode.javassist;

import java.util.HashMap;
import java.util.Map;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.LoaderClassPath;

public class ContextClassPool {
    private static ContextClassPool instance = new ContextClassPool();
    private Map<ClassLoader, ClassPool> pools = new HashMap<ClassLoader, ClassPool>();
    private final ClassPool defaultPool;

    private ContextClassPool() {
        ClassLoader classLoader = ContextClassPool.class.getClassLoader();
        this.defaultPool = new ClassPool(ClassPool.getDefault());
        this.defaultPool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
        this.pools.put(classLoader, this.defaultPool);
    }

    public static ContextClassPool instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPool getClassPool(ClassLoader loader) {
        if (loader == null) {
            return this.defaultPool;
        }
        ClassPool pool = this.pools.get(loader);
        if (pool != null) {
            return pool;
        }
        ContextClassPool contextClassPool = this;
        synchronized (contextClassPool) {
            pool = this.pools.get(loader);
            if (pool != null) {
                return pool;
            }
            pool = new ClassPool(this.defaultPool);
            pool.appendClassPath((ClassPath)new LoaderClassPath(loader));
            this.pools.put(loader, pool);
            return pool;
        }
    }
}

