/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.jdbc;

public final class ExpressionMeta
implements Cloneable {
    private final String catalog;
    private final String schema;
    private final String tableName;
    private final String fieldName;
    private final Class<?> fieldType;
    private final String expression;
    private final String jdbcType;
    private final int jdbcTypeValue;
    private final boolean selectable;
    private final String tableAliasPlaceholder;

    public ExpressionMeta(String catalog, String schema, String tableName, String fieldName, Class<?> fieldType, String expression, String jdbcType, int jdbcTypeValue, boolean selectable, String tableAliasPlaceholder) {
        this.catalog = catalog;
        this.schema = schema;
        this.tableName = tableName;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.expression = expression;
        this.jdbcType = jdbcType;
        this.jdbcTypeValue = jdbcTypeValue;
        this.selectable = selectable;
        this.tableAliasPlaceholder = tableAliasPlaceholder;
    }

    public ExpressionMeta clone() {
        try {
            return (ExpressionMeta)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String getExpressionWithoutTableAlias() {
        if (this.tableAliasPlaceholder == null || this.tableAliasPlaceholder.isEmpty()) {
            return this.expression;
        }
        return this.expression.replace(this.tableAliasPlaceholder, "");
    }

    public String getExpressionWithTableAlias(String alias) {
        if (this.tableAliasPlaceholder == null || this.tableAliasPlaceholder.isEmpty()) {
            return this.expression;
        }
        if (alias == null || alias.isEmpty()) {
            alias = this.tableName;
        }
        return this.expression.replace(this.tableAliasPlaceholder, alias + ".");
    }

    public String getExpressionWithTableName() {
        if (this.tableAliasPlaceholder == null || this.tableAliasPlaceholder.isEmpty()) {
            return this.expression;
        }
        return this.expression.replace(this.tableAliasPlaceholder, this.tableName + ".");
    }

    public static ExpressionMetaBuilder builder() {
        return new ExpressionMetaBuilder();
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Class<?> getFieldType() {
        return this.fieldType;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public int getJdbcTypeValue() {
        return this.jdbcTypeValue;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public String getTableAliasPlaceholder() {
        return this.tableAliasPlaceholder;
    }

    public String toString() {
        return "ExpressionMeta(catalog=" + this.catalog + ", schema=" + this.schema + ", tableName=" + this.tableName + ", fieldName=" + this.fieldName + ", fieldType=" + this.fieldType + ", expression=" + this.expression + ", jdbcType=" + this.jdbcType + ", jdbcTypeValue=" + this.jdbcTypeValue + ", selectable=" + this.selectable + ", tableAliasPlaceholder=" + this.tableAliasPlaceholder + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpressionMeta)) {
            return false;
        }
        ExpressionMeta other = (ExpressionMeta)o;
        if (this.jdbcTypeValue != other.jdbcTypeValue) {
            return false;
        }
        if (this.selectable != other.selectable) {
            return false;
        }
        String this$catalog = this.catalog;
        String other$catalog = other.catalog;
        if (this$catalog == null ? other$catalog != null : !this$catalog.equals(other$catalog)) {
            return false;
        }
        String this$schema = this.schema;
        String other$schema = other.schema;
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$tableName = this.tableName;
        String other$tableName = other.tableName;
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$fieldName = this.fieldName;
        String other$fieldName = other.fieldName;
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        Class<?> this$fieldType = this.fieldType;
        Class<?> other$fieldType = other.fieldType;
        if (this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType)) {
            return false;
        }
        String this$expression = this.expression;
        String other$expression = other.expression;
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        String this$jdbcType = this.jdbcType;
        String other$jdbcType = other.jdbcType;
        if (this$jdbcType == null ? other$jdbcType != null : !this$jdbcType.equals(other$jdbcType)) {
            return false;
        }
        String this$tableAliasPlaceholder = this.tableAliasPlaceholder;
        String other$tableAliasPlaceholder = other.tableAliasPlaceholder;
        return !(this$tableAliasPlaceholder == null ? other$tableAliasPlaceholder != null : !this$tableAliasPlaceholder.equals(other$tableAliasPlaceholder));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.jdbcTypeValue;
        result = result * 59 + (this.selectable ? 79 : 97);
        String $catalog = this.catalog;
        result = result * 59 + ($catalog == null ? 43 : $catalog.hashCode());
        String $schema = this.schema;
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $tableName = this.tableName;
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $fieldName = this.fieldName;
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        Class<?> $fieldType = this.fieldType;
        result = result * 59 + ($fieldType == null ? 43 : $fieldType.hashCode());
        String $expression = this.expression;
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        String $jdbcType = this.jdbcType;
        result = result * 59 + ($jdbcType == null ? 43 : $jdbcType.hashCode());
        String $tableAliasPlaceholder = this.tableAliasPlaceholder;
        result = result * 59 + ($tableAliasPlaceholder == null ? 43 : $tableAliasPlaceholder.hashCode());
        return result;
    }

    public static class ExpressionMetaBuilder {
        private String catalog;
        private String schema;
        private String tableName;
        private String fieldName;
        private Class<?> fieldType;
        private String expression;
        private String jdbcType;
        private int jdbcTypeValue;
        private boolean selectable;
        private String tableAliasPlaceholder;

        ExpressionMetaBuilder() {
        }

        public ExpressionMetaBuilder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public ExpressionMetaBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public ExpressionMetaBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public ExpressionMetaBuilder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public ExpressionMetaBuilder fieldType(Class<?> fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public ExpressionMetaBuilder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public ExpressionMetaBuilder jdbcType(String jdbcType) {
            this.jdbcType = jdbcType;
            return this;
        }

        public ExpressionMetaBuilder jdbcTypeValue(int jdbcTypeValue) {
            this.jdbcTypeValue = jdbcTypeValue;
            return this;
        }

        public ExpressionMetaBuilder selectable(boolean selectable) {
            this.selectable = selectable;
            return this;
        }

        public ExpressionMetaBuilder tableAliasPlaceholder(String tableAliasPlaceholder) {
            this.tableAliasPlaceholder = tableAliasPlaceholder;
            return this;
        }

        public ExpressionMeta build() {
            return new ExpressionMeta(this.catalog, this.schema, this.tableName, this.fieldName, this.fieldType, this.expression, this.jdbcType, this.jdbcTypeValue, this.selectable, this.tableAliasPlaceholder);
        }

        public String toString() {
            return "ExpressionMeta.ExpressionMetaBuilder(catalog=" + this.catalog + ", schema=" + this.schema + ", tableName=" + this.tableName + ", fieldName=" + this.fieldName + ", fieldType=" + this.fieldType + ", expression=" + this.expression + ", jdbcType=" + this.jdbcType + ", jdbcTypeValue=" + this.jdbcTypeValue + ", selectable=" + this.selectable + ", tableAliasPlaceholder=" + this.tableAliasPlaceholder + ")";
        }
    }
}

