/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.aop;

import io.polaris.core.aop.AroundAdvice;
import io.polaris.core.asm.proxy.Invocation;
import java.lang.reflect.Method;

public class AroundInvocation
implements Invocation {
    private final Invocation invocation;
    private final AroundAdvice[] advices;
    private final int index;
    private final Method method;

    public AroundInvocation(Invocation invocation, AroundAdvice[] advices, int index, Method method) {
        if (index < 0) {
            throw new IllegalArgumentException("index < 0");
        }
        this.invocation = invocation;
        this.advices = advices;
        this.index = index;
        this.method = method;
    }

    @Override
    public Object getProxy() {
        return this.invocation.getProxy();
    }

    @Override
    public Method getMethod() {
        return this.invocation.getMethod();
    }

    @Override
    public Object invoke(Object obj, Object[] args) throws Throwable {
        int size = this.advices.length;
        if (this.index < size) {
            AroundAdvice advice = this.advices[this.index];
            if (this.index < size - 1) {
                return advice.around(obj, this.method, args, new AroundInvocation(this.invocation, this.advices, this.index + 1, this.method));
            }
            return advice.around(obj, this.method, args, this.invocation);
        }
        return this.invocation.invoke(obj, args);
    }
}

