/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.aop;

import io.polaris.core.aop.Advice;
import io.polaris.core.aop.Advisor;
import io.polaris.core.aop.DefaultAdvisor;
import io.polaris.core.aop.MatchedAdvice;
import io.polaris.core.aop.NoopAdvisor;
import io.polaris.core.asm.proxy.Interceptor;
import io.polaris.core.asm.proxy.Invocation;
import io.polaris.dependency.org.objectweb.asm.Type;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public class Aspect
implements Interceptor {
    private final Object target;
    private final Map<MethodCacheKey, Advisor> methodCache = new ConcurrentHashMap<MethodCacheKey, Advisor>(32);
    private final List<MatchedAdvice> matchedAdvices = new ArrayList<MatchedAdvice>();

    public Aspect(Object target, Advice ... advices) {
        this(target, Arrays.asList(advices));
    }

    public Aspect(Object target, Iterable<Advice> advices) {
        this.target = target;
        for (Advice advice : advices) {
            this.addAdvice(advice);
        }
    }

    public void addAdvice(Advice ... advices) {
        this.matchedAdvices.add(new MatchedAdvice(null, advices));
        this.clearCache();
    }

    public void addAdvice(Predicate<Method> predicate, Advice ... advices) {
        this.matchedAdvices.add(new MatchedAdvice(predicate, advices));
        this.clearCache();
    }

    public void clearCache() {
        this.methodCache.clear();
    }

    public Advisor getAdvisor(Method method) {
        MethodCacheKey key = new MethodCacheKey(method);
        return this.methodCache.computeIfAbsent(key, k -> {
            ArrayList<Advice> advices = new ArrayList<Advice>();
            for (MatchedAdvice matchedAdvice : this.matchedAdvices) {
                if (!matchedAdvice.accept(method)) continue;
                advices.addAll(Arrays.asList(matchedAdvice.getAdvices()));
            }
            if (advices.isEmpty()) {
                return NoopAdvisor.INSTANCE;
            }
            return new DefaultAdvisor(method, advices);
        });
    }

    @Override
    public Object intercept(Object obj, Method method, Object[] args, Invocation invocation) throws Throwable {
        Advisor advisor = this.getAdvisor(method);
        return advisor.advise(this.target, args, invocation);
    }

    private static final class MethodCacheKey
    implements Comparable<MethodCacheKey> {
        private final String name;
        private final String desc;

        public MethodCacheKey(Method method) {
            this.name = method.getName();
            this.desc = Type.getMethodDescriptor(method);
        }

        @Override
        public int compareTo(MethodCacheKey other) {
            int result = this.name.compareTo(other.name);
            if (result == 0) {
                result = this.desc.compareTo(other.desc);
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodCacheKey)) {
                return false;
            }
            MethodCacheKey that = (MethodCacheKey)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.desc, that.desc);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.desc);
        }
    }
}

