/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.aop;

import io.polaris.core.aop.Advice;
import io.polaris.core.aop.JdkAspect;
import io.polaris.core.aop.ProxyFactory;
import io.polaris.core.aop.ProxyUtils;
import java.lang.reflect.Method;
import java.util.function.Predicate;

public class JdkProxyFactory
implements ProxyFactory {
    private final Object target;
    private final JdkAspect aspect;
    private Class<?> superclass;
    private Class<?>[] interfaces;
    private ClassLoader classloader;

    public JdkProxyFactory(Object target) {
        this.target = target;
        this.aspect = new JdkAspect(target, new Advice[0]);
        this.classloader = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public JdkProxyFactory classloader(ClassLoader classloader) {
        this.classloader = classloader;
        return this;
    }

    @Override
    public JdkProxyFactory superclass(Class<?> superclass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JdkProxyFactory interfaces(Class<?>[] interfaces) {
        this.interfaces = interfaces;
        return this;
    }

    @Override
    public JdkProxyFactory addAdvice(Advice ... advices) {
        this.aspect.addAdvice(advices);
        return this;
    }

    @Override
    public JdkProxyFactory addAdvice(Predicate<Method> predicate, Advice ... advices) {
        this.aspect.addAdvice(predicate, advices);
        return this;
    }

    @Override
    public <T> T get() {
        return ProxyUtils.jdkProxy(this.classloader, this.interfaces, this.aspect);
    }
}

