/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.generator;

import io.polaris.core.asm.generator.ClassGenerator;
import io.polaris.core.asm.generator.DefaultGeneratorStrategy;
import io.polaris.core.asm.generator.DefaultNamingPolicy;
import io.polaris.core.asm.generator.GeneratorStrategy;
import io.polaris.core.asm.generator.NamingPolicy;
import io.polaris.core.asm.internal.AsmReflects;
import io.polaris.core.asm.internal.ClassNameReader;
import io.polaris.core.err.BytecodeOperationException;
import io.polaris.core.tuple.Tuple2;
import io.polaris.dependency.org.objectweb.asm.ClassReader;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public abstract class AbstractClassGenerator
implements ClassGenerator {
    private static volatile Map<ClassLoader, ClassLoaderData> CACHE = new WeakHashMap<ClassLoader, ClassLoaderData>();
    private static final boolean DEFAULT_USE_CACHE = Boolean.parseBoolean(System.getProperty("java.class.generator.cache", "true"));
    private boolean frozen = false;
    private GeneratorStrategy strategy = DefaultGeneratorStrategy.INSTANCE;
    private NamingPolicy namingPolicy = DefaultNamingPolicy.INSTANCE;
    private ClassLoader classLoader;
    private String packageName;
    private String baseName;
    private Tuple2<AbstractClassGenerator, Object> key;
    private boolean useCache = DEFAULT_USE_CACHE;
    private String className;
    private boolean attemptLoad;

    protected AbstractClassGenerator() {
        this.setPackageName(this.getClass().getPackage().getName());
        this.setBaseName(this.getClass().getSimpleName());
    }

    protected boolean isFrozen() {
        return this.frozen;
    }

    protected boolean isEditable() {
        return !this.frozen;
    }

    protected void checkState() {
        if (this.frozen) {
            throw new IllegalStateException();
        }
    }

    protected void setPackageName(String packageName) {
        this.checkState();
        this.packageName = packageName;
    }

    protected void setBaseName(String baseName) {
        this.checkState();
        this.baseName = baseName;
    }

    protected void setKey(Object key) {
        this.checkState();
        this.key = Tuple2.of(this, key);
    }

    protected final String getClassName() {
        return this.className;
    }

    private void setClassName(String className) {
        this.checkState();
        this.className = className;
    }

    private String generateClassName(Predicate<String> dupChecker) {
        return this.namingPolicy.getClassName(this.packageName, this.baseName, this.key.getSecond(), dupChecker);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.checkState();
        this.classLoader = classLoader;
    }

    public void namingPolicy(NamingPolicy namingPolicy) {
        this.checkState();
        if (namingPolicy == null) {
            namingPolicy = DefaultNamingPolicy.INSTANCE;
        }
        this.namingPolicy = namingPolicy;
    }

    public NamingPolicy namingPolicy() {
        return this.namingPolicy;
    }

    public void useCache(boolean useCache) {
        this.checkState();
        this.useCache = useCache;
    }

    public boolean useCache() {
        return this.useCache;
    }

    public void attemptLoad(boolean attemptLoad) {
        this.checkState();
        this.attemptLoad = attemptLoad;
    }

    public boolean attemptLoad() {
        return this.attemptLoad;
    }

    protected void strategy(GeneratorStrategy strategy) {
        this.checkState();
        if (strategy == null) {
            strategy = DefaultGeneratorStrategy.INSTANCE;
        }
        this.strategy = strategy;
    }

    protected GeneratorStrategy strategy() {
        return this.strategy;
    }

    public ClassLoader getClassLoader() {
        ClassLoader t = this.classLoader;
        if (t == null) {
            t = this.getDefaultClassLoader();
        }
        if (t == null) {
            t = Thread.currentThread().getContextClassLoader();
        }
        if (t == null) {
            t = this.getClass().getClassLoader();
        }
        if (t == null) {
            throw new IllegalStateException("Cannot determine classloader");
        }
        return t;
    }

    protected abstract ClassLoader getDefaultClassLoader();

    protected ProtectionDomain getProtectionDomain() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected Class<?> generateClass() {
        Map<ClassLoader, ClassLoaderData> cache = CACHE;
        ClassLoader loader = this.getClassLoader();
        ClassLoaderData data = cache.get(loader);
        if (data == null) {
            Class<AbstractClassGenerator> clazz = AbstractClassGenerator.class;
            // MONITORENTER : io.polaris.core.asm.generator.AbstractClassGenerator.class
            cache = CACHE;
            data = cache.get(loader);
            if (data == null) {
                WeakHashMap<ClassLoader, ClassLoaderData> newCache = new WeakHashMap<ClassLoader, ClassLoaderData>(cache);
                data = new ClassLoaderData();
                newCache.put(loader, data);
                CACHE = newCache;
            }
            // MONITOREXIT : clazz
        }
        Class<?> clazz = data.get(this, loader, this.useCache());
        this.frozen = true;
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> generate(ClassLoader classLoader, ClassLoaderData data) {
        try {
            Class clazz;
            if (classLoader == null) {
                throw new IllegalArgumentException("ClassLoader is null ");
            }
            ClassLoader classLoader2 = classLoader;
            synchronized (classLoader2) {
                String name = this.generateClassName(data.getDupChecker());
                data.reserveName(name);
                this.setClassName(name);
            }
            if (this.attemptLoad) {
                try {
                    clazz = classLoader.loadClass(this.getClassName());
                    return clazz;
                }
                catch (ClassNotFoundException name) {
                    // empty catch block
                }
            }
            byte[] b = this.strategy.generate(this);
            String className = ClassNameReader.getClassName(new ClassReader(b));
            ProtectionDomain protectionDomain = this.getProtectionDomain();
            ClassLoader classLoader3 = classLoader;
            synchronized (classLoader3) {
                clazz = protectionDomain == null ? AsmReflects.defineClass(className, b, classLoader) : AsmReflects.defineClass(className, b, classLoader, protectionDomain);
            }
            return clazz;
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BytecodeOperationException(e);
        }
    }

    protected static class ClassLoaderData {
        private final Set<String> reservedClassNames = new HashSet<String>();
        private final Map<Tuple2<AbstractClassGenerator, Object>, WeakReference<Class<?>>> generatedClasses = new ConcurrentHashMap();
        private final Predicate<String> dupChecker = this.reservedClassNames::contains;

        public void reserveName(String name) {
            this.reservedClassNames.add(name);
        }

        public Class<?> get(AbstractClassGenerator generator, ClassLoader classLoader, boolean useCache) {
            if (!useCache) {
                return generator.generate(classLoader, this);
            }
            WeakReference cachedValue = this.generatedClasses.computeIfAbsent(generator.key, k -> new WeakReference(generator.generate(classLoader, this)));
            return (Class)cachedValue.get();
        }

        public Predicate<String> getDupChecker() {
            return this.dupChecker;
        }
    }
}

