/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.generator;

import io.polaris.core.asm.generator.AbstractClassGenerator;
import io.polaris.core.asm.internal.AsmConsts;
import io.polaris.core.asm.internal.AsmReflects;
import io.polaris.core.asm.internal.ClassEmitter;
import io.polaris.core.asm.internal.Emitters;
import io.polaris.dependency.org.objectweb.asm.ClassVisitor;
import io.polaris.dependency.org.objectweb.asm.Type;
import java.beans.PropertyDescriptor;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;

public class BeanGenerator
extends AbstractClassGenerator {
    private Class<?> superclass;
    private final Map<String, Type> props = new HashMap<String, Type>();

    public static void addProperties(BeanGenerator generator, Map<String, Class<?>> props) {
        props.forEach(generator::addProperty);
    }

    public static void addProperties(BeanGenerator generator, Class<?> type) {
        BeanGenerator.addProperties(generator, AsmReflects.getBeanProperties(type));
    }

    public static void addProperties(BeanGenerator generator, PropertyDescriptor[] descriptors) {
        for (PropertyDescriptor descriptor : descriptors) {
            generator.addProperty(descriptor.getName(), descriptor.getPropertyType());
        }
    }

    public void addProperty(String name, Class<?> type) {
        this.checkState();
        if (this.props.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate property name \"" + name + "\"");
        }
        this.props.put(name, Type.getType(type));
    }

    public void setSuperclass(Class<?> superclass) {
        this.checkState();
        if (superclass != null && superclass.equals(Object.class)) {
            superclass = null;
        }
        this.superclass = superclass;
    }

    public Object create() {
        return AsmReflects.newInstance(this.createClass());
    }

    public Class<?> createClass() {
        if (this.isEditable()) {
            if (this.superclass != null) {
                this.setPackageName(this.superclass.getPackage().getName());
                this.setBaseName(this.superclass.getSimpleName() + "$" + BeanGenerator.class.getSimpleName());
            }
            this.setKey(new Object[]{this.superclass != null ? this.superclass : Object.class, this.props});
        }
        return super.generateClass();
    }

    @Override
    protected ClassLoader getDefaultClassLoader() {
        if (this.superclass != null) {
            return this.superclass.getClassLoader();
        }
        return null;
    }

    @Override
    protected ProtectionDomain getProtectionDomain() {
        return AsmReflects.getProtectionDomain(this.superclass);
    }

    @Override
    public void generateClass(ClassVisitor cv) throws Exception {
        int size = this.props.size();
        String[] names = this.props.keySet().toArray(new String[size]);
        Type[] types = new Type[size];
        for (int i = 0; i < size; ++i) {
            types[i] = this.props.get(names[i]);
        }
        ClassEmitter ce = new ClassEmitter(cv);
        ce.begin_class(52, 1, this.getClassName(), this.superclass != null ? Type.getType(this.superclass) : AsmConsts.TYPE_OBJECT, null, null);
        Emitters.null_constructor(ce);
        Emitters.add_properties(ce, names, types);
        ce.end_class();
    }
}

