/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.generator;

import io.polaris.core.asm.generator.NamingPolicy;
import io.polaris.core.hash.ArrayHash;
import io.polaris.core.string.Strings;
import java.util.Objects;
import java.util.function.Predicate;

public class DefaultNamingPolicy
implements NamingPolicy {
    public static final DefaultNamingPolicy INSTANCE = new DefaultNamingPolicy();
    protected final String tag;

    public DefaultNamingPolicy() {
        this("Generated");
    }

    public DefaultNamingPolicy(String tag) {
        this.tag = Strings.coalesce(tag, "Generated");
    }

    @Override
    public String getClassName(String packageName, String baseName, Object key, Predicate<String> dupChecker) {
        if ((packageName = Strings.trimToNull(packageName)) == null) {
            packageName = "io.polaris.core.asm";
        } else if (packageName.equals("java")) {
            packageName = "javax";
        } else if (packageName.startsWith("java.")) {
            packageName = "javax." + packageName.substring(5);
        }
        baseName = Strings.trimToNull(baseName);
        if (baseName == null) {
            baseName = "Object";
        } else {
            int i = baseName.lastIndexOf(46);
            if (i != -1) {
                baseName = baseName.substring(i + 1);
            }
        }
        StringBuilder sb = new StringBuilder().append(packageName).append(".").append(baseName).append("$$").append(this.tag);
        if (key != null) {
            sb.append("$").append(Integer.toHexString(ArrayHash.hash(key)));
        }
        int baseLength = sb.length();
        String attempt = sb.toString();
        int index = 1;
        while (dupChecker.test(attempt)) {
            sb.setLength(baseLength);
            attempt = sb.append('$').append(index++).toString();
        }
        return attempt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNamingPolicy that = (DefaultNamingPolicy)o;
        return Objects.equals(this.tag, that.tag);
    }

    public int hashCode() {
        return Objects.hashCode(this.tag);
    }
}

