/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.internal;

import io.polaris.dependency.org.objectweb.asm.ClassWriter;
import io.polaris.dependency.org.objectweb.asm.Label;
import io.polaris.dependency.org.objectweb.asm.MethodVisitor;
import io.polaris.dependency.org.objectweb.asm.Type;

public class AsmUtils {
    public static void autoUnBoxing(MethodVisitor mv, Class<?> clz) {
        AsmUtils.autoUnBoxing(mv, Type.getType(clz));
    }

    public static void autoUnBoxing(MethodVisitor mv, Type fieldType) {
        switch (fieldType.getSort()) {
            case 1: {
                mv.visitTypeInsn(192, "java/lang/Boolean");
                mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
                break;
            }
            case 3: {
                mv.visitTypeInsn(192, "java/lang/Byte");
                mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
                break;
            }
            case 2: {
                mv.visitTypeInsn(192, "java/lang/Character");
                mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
                break;
            }
            case 4: {
                mv.visitTypeInsn(192, "java/lang/Short");
                mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
                break;
            }
            case 5: {
                mv.visitTypeInsn(192, "java/lang/Integer");
                mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
                break;
            }
            case 6: {
                mv.visitTypeInsn(192, "java/lang/Float");
                mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
                break;
            }
            case 7: {
                mv.visitTypeInsn(192, "java/lang/Long");
                mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
                break;
            }
            case 8: {
                mv.visitTypeInsn(192, "java/lang/Double");
                mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
                break;
            }
            case 9: {
                mv.visitTypeInsn(192, fieldType.getDescriptor());
                break;
            }
            case 10: {
                mv.visitTypeInsn(192, fieldType.getInternalName());
                break;
            }
            default: {
                mv.visitTypeInsn(192, fieldType.getInternalName());
            }
        }
    }

    public static void autoBoxing(MethodVisitor mv, Class<?> clz) {
        AsmUtils.autoBoxing(mv, Type.getType(clz));
    }

    public static void autoBoxing(MethodVisitor mv, Type fieldType) {
        switch (fieldType.getSort()) {
            case 1: {
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                break;
            }
            case 3: {
                mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                break;
            }
            case 2: {
                mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                break;
            }
            case 4: {
                mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                break;
            }
            case 5: {
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                break;
            }
            case 6: {
                mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                break;
            }
            case 7: {
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                break;
            }
            case 8: {
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                break;
            }
        }
    }

    public static void autoBoxingForReturn(MethodVisitor mv, Class<?> clz) {
        AsmUtils.autoBoxingForReturn(mv, Type.getType(clz));
    }

    public static void autoBoxingForReturn(MethodVisitor mv, Type fieldType) {
        if (fieldType.getSort() == 0) {
            mv.visitInsn(1);
        } else {
            AsmUtils.autoBoxing(mv, fieldType);
        }
    }

    public static void insertDefaultConstructor(ClassWriter cw, String superclassNameInternal) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superclassNameInternal, "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public static Label[] newLabels(int size) {
        Label[] label = new Label[size];
        for (int i = 0; i < size; ++i) {
            label[i] = new Label();
        }
        return label;
    }

    public static void storeVar(MethodVisitor mv, Class<?> type, int varIndex) {
        if (type == Byte.TYPE || type == Boolean.TYPE || type == Short.TYPE || type == Character.TYPE || type == Integer.TYPE) {
            mv.visitVarInsn(54, varIndex);
        } else if (type == Long.TYPE) {
            mv.visitVarInsn(55, varIndex);
        } else if (type == Float.TYPE) {
            mv.visitVarInsn(56, varIndex);
        } else if (type == Double.TYPE) {
            mv.visitVarInsn(57, varIndex);
        } else {
            mv.visitVarInsn(58, varIndex);
        }
    }

    public static void loadVar(MethodVisitor mv, Class<?> type, int varIndex) {
        if (type == Byte.TYPE || type == Boolean.TYPE || type == Short.TYPE || type == Character.TYPE || type == Integer.TYPE) {
            mv.visitVarInsn(21, varIndex);
        } else if (type == Long.TYPE) {
            mv.visitVarInsn(22, varIndex);
        } else if (type == Float.TYPE) {
            mv.visitVarInsn(23, varIndex);
        } else if (type == Double.TYPE) {
            mv.visitVarInsn(24, varIndex);
        } else {
            mv.visitVarInsn(25, varIndex);
        }
    }
}

