/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.internal;

import io.polaris.core.asm.internal.AsmCollections;
import io.polaris.core.asm.internal.AsmConsts;
import io.polaris.core.asm.internal.AsmTypes;
import io.polaris.core.asm.internal.Block;
import io.polaris.core.asm.internal.ClassEmitter;
import io.polaris.core.asm.internal.CodeEmitter;
import io.polaris.core.asm.internal.Local;
import io.polaris.core.asm.internal.MethodInfo;
import io.polaris.core.asm.internal.ObjectSwitchCallback;
import io.polaris.core.asm.internal.ProcessArrayCallback;
import io.polaris.core.asm.internal.ProcessSwitchCallback;
import io.polaris.core.asm.internal.Signature;
import io.polaris.core.asm.internal.Transformer;
import io.polaris.core.err.BytecodeOperationException;
import io.polaris.dependency.org.objectweb.asm.Label;
import io.polaris.dependency.org.objectweb.asm.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Emitters {
    private static final Signature CSTRUCT_NULL = AsmTypes.parseConstructor("");
    private static final Signature CSTRUCT_THROWABLE = AsmTypes.parseConstructor("Throwable");
    private static final Signature GET_NAME = AsmTypes.parseSignature("String getName()");
    private static final Signature HASH_CODE = AsmTypes.parseSignature("int hashCode()");
    private static final Signature EQUALS = AsmTypes.parseSignature("boolean equals(Object)");
    private static final Signature STRING_LENGTH = AsmTypes.parseSignature("int length()");
    private static final Signature STRING_CHAR_AT = AsmTypes.parseSignature("char charAt(int)");
    private static final Signature FOR_NAME = AsmTypes.parseSignature("Class forName(String)");
    private static final Signature DOUBLE_TO_LONG_BITS = AsmTypes.parseSignature("long doubleToLongBits(double)");
    private static final Signature FLOAT_TO_INT_BITS = AsmTypes.parseSignature("int floatToIntBits(float)");
    private static final Signature TO_STRING = AsmTypes.parseSignature("String toString()");
    private static final Signature APPEND_STRING = AsmTypes.parseSignature("StringBuffer append(String)");
    private static final Signature APPEND_INT = AsmTypes.parseSignature("StringBuffer append(int)");
    private static final Signature APPEND_DOUBLE = AsmTypes.parseSignature("StringBuffer append(double)");
    private static final Signature APPEND_FLOAT = AsmTypes.parseSignature("StringBuffer append(float)");
    private static final Signature APPEND_CHAR = AsmTypes.parseSignature("StringBuffer append(char)");
    private static final Signature APPEND_LONG = AsmTypes.parseSignature("StringBuffer append(long)");
    private static final Signature APPEND_BOOLEAN = AsmTypes.parseSignature("StringBuffer append(boolean)");
    private static final Signature LENGTH = AsmTypes.parseSignature("int length()");
    private static final Signature SET_LENGTH = AsmTypes.parseSignature("void setLength(int)");
    private static final Signature GET_DECLARED_METHOD = AsmTypes.parseSignature("java.lang.reflect.Method getDeclaredMethod(String, Class[])");
    public static final ArrayDelimiters DEFAULT_DELIMITERS = new ArrayDelimiters("{", ", ", "}");

    private Emitters() {
    }

    public static void factory_method(ClassEmitter ce, Signature sig) {
        CodeEmitter e = ce.begin_method(1, sig, null);
        e.new_instance_this();
        e.dup();
        e.load_args();
        e.invoke_constructor_this(AsmTypes.parseConstructor(sig.getArgumentTypes()));
        e.return_value();
        e.end_method();
    }

    public static void null_constructor(ClassEmitter ce) {
        CodeEmitter e = ce.begin_method(1, CSTRUCT_NULL, null);
        e.load_this();
        e.super_invoke_constructor();
        e.return_value();
        e.end_method();
    }

    public static void process_array(CodeEmitter e, Type type, ProcessArrayCallback callback) {
        Type componentType = AsmTypes.getComponentType(type);
        Local array = e.make_local();
        Local loopvar = e.make_local(Type.INT_TYPE);
        Label loopbody = e.make_label();
        Label checkloop = e.make_label();
        e.store_local(array);
        e.push(0);
        e.store_local(loopvar);
        e.goTo(checkloop);
        e.mark(loopbody);
        e.load_local(array);
        e.load_local(loopvar);
        e.array_load(componentType);
        callback.processElement(componentType);
        e.iinc(loopvar, 1);
        e.mark(checkloop);
        e.load_local(loopvar);
        e.load_local(array);
        e.arraylength();
        e.if_icmp(155, loopbody);
    }

    public static void process_arrays(CodeEmitter e, Type type, ProcessArrayCallback callback) {
        Type componentType = AsmTypes.getComponentType(type);
        Local array1 = e.make_local();
        Local array2 = e.make_local();
        Local loopvar = e.make_local(Type.INT_TYPE);
        Label loopbody = e.make_label();
        Label checkloop = e.make_label();
        e.store_local(array1);
        e.store_local(array2);
        e.push(0);
        e.store_local(loopvar);
        e.goTo(checkloop);
        e.mark(loopbody);
        e.load_local(array1);
        e.load_local(loopvar);
        e.array_load(componentType);
        e.load_local(array2);
        e.load_local(loopvar);
        e.array_load(componentType);
        callback.processElement(componentType);
        e.iinc(loopvar, 1);
        e.mark(checkloop);
        e.load_local(loopvar);
        e.load_local(array1);
        e.arraylength();
        e.if_icmp(155, loopbody);
    }

    public static void string_switch(CodeEmitter e, String[] strings, int switchStyle, ObjectSwitchCallback callback) {
        try {
            switch (switchStyle) {
                case 0: {
                    Emitters.string_switch_trie(e, strings, callback);
                    break;
                }
                case 1: {
                    Emitters.string_switch_hash(e, strings, callback, false);
                    break;
                }
                case 2: {
                    Emitters.string_switch_hash(e, strings, callback, true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown switch style " + switchStyle);
                }
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Error ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BytecodeOperationException(ex);
        }
    }

    private static void string_switch_trie(final CodeEmitter e, String[] strings, final ObjectSwitchCallback callback) throws Exception {
        final Label def = e.make_label();
        final Label end = e.make_label();
        final Map buckets = AsmCollections.bucket(Arrays.asList(strings), new Transformer(){

            @Override
            public Object transform(Object value) {
                return ((String)value).length();
            }
        });
        e.dup();
        e.invoke_virtual(AsmConsts.TYPE_STRING, STRING_LENGTH);
        e.process_switch(Emitters.getSwitchKeys(buckets), new ProcessSwitchCallback(){

            @Override
            public void processCase(int key, Label ignore_end) throws Exception {
                List bucket = (List)buckets.get(key);
                Emitters.stringSwitchHelper(e, bucket, callback, def, end, 0);
            }

            @Override
            public void processDefault() {
                e.goTo(def);
            }
        });
        e.mark(def);
        e.pop();
        callback.processDefault();
        e.mark(end);
    }

    private static void stringSwitchHelper(final CodeEmitter e, List strings, final ObjectSwitchCallback callback, final Label def, final Label end, final int index) throws Exception {
        final int len = ((String)strings.get(0)).length();
        final Map buckets = AsmCollections.bucket(strings, new Transformer(){

            @Override
            public Object transform(Object value) {
                return (int)((String)value).charAt(index);
            }
        });
        e.dup();
        e.push(index);
        e.invoke_virtual(AsmConsts.TYPE_STRING, STRING_CHAR_AT);
        e.process_switch(Emitters.getSwitchKeys(buckets), new ProcessSwitchCallback(){

            @Override
            public void processCase(int key, Label ignore_end) throws Exception {
                List bucket = (List)buckets.get(key);
                if (index + 1 == len) {
                    e.pop();
                    callback.processCase(bucket.get(0), end);
                } else {
                    Emitters.stringSwitchHelper(e, bucket, callback, def, end, index + 1);
                }
            }

            @Override
            public void processDefault() {
                e.goTo(def);
            }
        });
    }

    static int[] getSwitchKeys(Map buckets) {
        int[] keys = new int[buckets.size()];
        int index = 0;
        Iterator it = buckets.keySet().iterator();
        while (it.hasNext()) {
            keys[index++] = (Integer)it.next();
        }
        Arrays.sort(keys);
        return keys;
    }

    private static void string_switch_hash(final CodeEmitter e, String[] strings, final ObjectSwitchCallback callback, final boolean skipEquals) throws Exception {
        final Map buckets = AsmCollections.bucket(Arrays.asList(strings), new Transformer(){

            @Override
            public Object transform(Object value) {
                return value.hashCode();
            }
        });
        final Label def = e.make_label();
        final Label end = e.make_label();
        e.dup();
        e.invoke_virtual(AsmConsts.TYPE_OBJECT, HASH_CODE);
        e.process_switch(Emitters.getSwitchKeys(buckets), new ProcessSwitchCallback(){

            @Override
            public void processCase(int key, Label ignore_end) throws Exception {
                List bucket = (List)buckets.get(key);
                Label next = null;
                if (skipEquals && bucket.size() == 1) {
                    if (skipEquals) {
                        e.pop();
                    }
                    callback.processCase((String)bucket.get(0), end);
                } else {
                    Iterator it = bucket.iterator();
                    while (it.hasNext()) {
                        String string = (String)it.next();
                        if (next != null) {
                            e.mark(next);
                        }
                        if (it.hasNext()) {
                            e.dup();
                        }
                        e.push(string);
                        e.invoke_virtual(AsmConsts.TYPE_OBJECT, EQUALS);
                        if (it.hasNext()) {
                            next = e.make_label();
                            e.if_jump(153, next);
                            e.pop();
                        } else {
                            e.if_jump(153, def);
                        }
                        callback.processCase(string, end);
                    }
                }
            }

            @Override
            public void processDefault() {
                e.pop();
            }
        });
        e.mark(def);
        callback.processDefault();
        e.mark(end);
    }

    public static void load_class_this(CodeEmitter e) {
        Emitters.load_class_helper(e, e.getClassEmitter().getClassType());
    }

    public static void load_class(CodeEmitter e, Type type) {
        if (AsmTypes.isPrimitive(type)) {
            if (type == Type.VOID_TYPE) {
                throw new IllegalArgumentException("cannot load void type");
            }
            e.getstatic(AsmTypes.getBoxedType(type), "TYPE", AsmConsts.TYPE_CLASS);
        } else {
            Emitters.load_class_helper(e, type);
        }
    }

    private static void load_class_helper(CodeEmitter e, Type type) {
        if (e.isStaticHook()) {
            e.push(AsmTypes.emulateClassGetName(type));
            e.invoke_static(AsmConsts.TYPE_CLASS, FOR_NAME);
        } else {
            ClassEmitter ce = e.getClassEmitter();
            String typeName = AsmTypes.emulateClassGetName(type);
            String fieldName = "$ASM$load_class$" + AsmTypes.escapeType(typeName);
            if (!ce.isFieldDeclared(fieldName)) {
                ce.declare_field(26, fieldName, AsmConsts.TYPE_CLASS, null);
                CodeEmitter hook = ce.getStaticHook();
                hook.push(typeName);
                hook.invoke_static(AsmConsts.TYPE_CLASS, FOR_NAME);
                hook.putstatic(ce.getClassType(), fieldName, AsmConsts.TYPE_CLASS);
            }
            e.getfield(fieldName);
        }
    }

    public static void push_array(CodeEmitter e, Object[] array) {
        e.push(array.length);
        e.newarray(Type.getType(Emitters.remapComponentType(array.getClass().getComponentType())));
        for (int i = 0; i < array.length; ++i) {
            e.dup();
            e.push(i);
            Emitters.push_object(e, array[i]);
            e.aastore();
        }
    }

    private static Class remapComponentType(Class componentType) {
        if (componentType.equals(Type.class)) {
            return Class.class;
        }
        return componentType;
    }

    public static void push_object(CodeEmitter e, Object obj) {
        if (obj == null) {
            e.aconst_null();
        } else {
            Class<?> type = obj.getClass();
            if (type.isArray()) {
                Emitters.push_array(e, (Object[])obj);
            } else if (obj instanceof String) {
                e.push((String)obj);
            } else if (obj instanceof Type) {
                Emitters.load_class(e, (Type)obj);
            } else if (obj instanceof Class) {
                Emitters.load_class(e, Type.getType((Class)obj));
            } else if (obj instanceof BigInteger) {
                e.new_instance(AsmConsts.TYPE_BIG_INTEGER);
                e.dup();
                e.push(obj.toString());
                e.invoke_constructor(AsmConsts.TYPE_BIG_INTEGER);
            } else if (obj instanceof BigDecimal) {
                e.new_instance(AsmConsts.TYPE_BIG_DECIMAL);
                e.dup();
                e.push(obj.toString());
                e.invoke_constructor(AsmConsts.TYPE_BIG_DECIMAL);
            } else {
                throw new IllegalArgumentException("unknown type: " + obj.getClass());
            }
        }
    }

    private static void hash_primitive(CodeEmitter e, Type type) {
        switch (type.getSort()) {
            case 1: {
                e.push(1);
                e.math(130, Type.INT_TYPE);
                break;
            }
            case 6: {
                e.invoke_static(AsmConsts.TYPE_FLOAT, FLOAT_TO_INT_BITS);
                break;
            }
            case 8: {
                e.invoke_static(AsmConsts.TYPE_DOUBLE, DOUBLE_TO_LONG_BITS);
            }
            case 7: {
                Emitters.hash_long(e);
            }
        }
    }

    private static void hash_long(CodeEmitter e) {
        e.dup2();
        e.push(32);
        e.math(124, Type.LONG_TYPE);
        e.math(130, Type.LONG_TYPE);
        e.cast_numeric(Type.LONG_TYPE, Type.INT_TYPE);
    }

    private static void nullcmp(CodeEmitter e, Label oneNull, Label bothNull) {
        e.dup2();
        Label nonNull = e.make_label();
        Label oneNullHelper = e.make_label();
        Label end = e.make_label();
        e.ifnonnull(nonNull);
        e.ifnonnull(oneNullHelper);
        e.pop2();
        e.goTo(bothNull);
        e.mark(nonNull);
        e.ifnull(oneNullHelper);
        e.goTo(end);
        e.mark(oneNullHelper);
        e.pop2();
        e.goTo(oneNull);
        e.mark(end);
    }

    private static void shrinkStringBuffer(CodeEmitter e, int amt) {
        e.dup();
        e.dup();
        e.invoke_virtual(AsmConsts.TYPE_STRING_BUFFER, LENGTH);
        e.push(amt);
        e.math(100, Type.INT_TYPE);
        e.invoke_virtual(AsmConsts.TYPE_STRING_BUFFER, SET_LENGTH);
    }

    public static void load_method(CodeEmitter e, MethodInfo method) {
        Emitters.load_class(e, method.getClassInfo().getType());
        e.push(method.getSignature().getName());
        Emitters.push_object(e, method.getSignature().getArgumentTypes());
        e.invoke_virtual(AsmConsts.TYPE_CLASS, GET_DECLARED_METHOD);
    }

    public static void method_switch(CodeEmitter e, List methods, ObjectSwitchCallback callback) {
        Emitters.member_switch_helper(e, methods, callback, true);
    }

    public static void constructor_switch(CodeEmitter e, List constructors, ObjectSwitchCallback callback) {
        Emitters.member_switch_helper(e, constructors, callback, false);
    }

    private static void member_switch_helper(final CodeEmitter e, List members, final ObjectSwitchCallback callback, boolean useName) {
        try {
            final HashMap cache = new HashMap();
            final ParameterTyper cached = new ParameterTyper(){

                @Override
                public Type[] getParameterTypes(MethodInfo member) {
                    Type[] types = (Type[])cache.get(member);
                    if (types == null) {
                        types = member.getSignature().getArgumentTypes();
                        cache.put(member, types);
                    }
                    return types;
                }
            };
            final Label def = e.make_label();
            final Label end = e.make_label();
            if (useName) {
                e.swap();
                final Map buckets = AsmCollections.bucket(members, new Transformer(){

                    @Override
                    public Object transform(Object value) {
                        return ((MethodInfo)value).getSignature().getName();
                    }
                });
                String[] names = buckets.keySet().toArray(new String[buckets.size()]);
                Emitters.string_switch(e, names, 1, new ObjectSwitchCallback(){

                    @Override
                    public void processCase(Object key, Label dontUseEnd) throws Exception {
                        Emitters.member_helper_size(e, (List)buckets.get(key), callback, cached, def, end);
                    }

                    @Override
                    public void processDefault() throws Exception {
                        e.goTo(def);
                    }
                });
            } else {
                Emitters.member_helper_size(e, members, callback, cached, def, end);
            }
            e.mark(def);
            e.pop();
            callback.processDefault();
            e.mark(end);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Error ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BytecodeOperationException(ex);
        }
    }

    private static void member_helper_size(final CodeEmitter e, List members, final ObjectSwitchCallback callback, final ParameterTyper typer, final Label def, final Label end) throws Exception {
        final Map buckets = AsmCollections.bucket(members, new Transformer(){

            @Override
            public Object transform(Object value) {
                return typer.getParameterTypes((MethodInfo)value).length;
            }
        });
        e.dup();
        e.arraylength();
        e.process_switch(Emitters.getSwitchKeys(buckets), new ProcessSwitchCallback(){

            @Override
            public void processCase(int key, Label dontUseEnd) throws Exception {
                List bucket = (List)buckets.get(key);
                Emitters.member_helper_type(e, bucket, callback, typer, def, end, new BitSet());
            }

            @Override
            public void processDefault() throws Exception {
                e.goTo(def);
            }
        });
    }

    private static void member_helper_type(final CodeEmitter e, List members, final ObjectSwitchCallback callback, final ParameterTyper typer, final Label def, final Label end, final BitSet checked) throws Exception {
        if (members.size() == 1) {
            MethodInfo member = (MethodInfo)members.get(0);
            Type[] types = typer.getParameterTypes(member);
            for (int i = 0; i < types.length; ++i) {
                if (checked != null && checked.get(i)) continue;
                e.dup();
                e.aaload(i);
                e.invoke_virtual(AsmConsts.TYPE_CLASS, GET_NAME);
                e.push(AsmTypes.emulateClassGetName(types[i]));
                e.invoke_virtual(AsmConsts.TYPE_OBJECT, EQUALS);
                e.if_jump(153, def);
            }
            e.pop();
            callback.processCase(member, end);
        } else {
            Type[] example = typer.getParameterTypes((MethodInfo)members.get(0));
            Map buckets = null;
            int index = -1;
            for (int i = 0; i < example.length; ++i) {
                final int j = i;
                Map test = AsmCollections.bucket(members, new Transformer(){

                    @Override
                    public Object transform(Object value) {
                        return AsmTypes.emulateClassGetName(typer.getParameterTypes((MethodInfo)value)[j]);
                    }
                });
                if (buckets != null && test.size() <= buckets.size()) continue;
                buckets = test;
                index = i;
            }
            if (buckets == null || buckets.size() == 1) {
                e.goTo(def);
            } else {
                checked.set(index);
                e.dup();
                e.aaload(index);
                e.invoke_virtual(AsmConsts.TYPE_CLASS, GET_NAME);
                final Map fbuckets = buckets;
                String[] names = buckets.keySet().toArray(new String[buckets.size()]);
                Emitters.string_switch(e, names, 1, new ObjectSwitchCallback(){

                    @Override
                    public void processCase(Object key, Label dontUseEnd) throws Exception {
                        Emitters.member_helper_type(e, (List)fbuckets.get(key), callback, typer, def, end, checked);
                    }

                    @Override
                    public void processDefault() throws Exception {
                        e.goTo(def);
                    }
                });
            }
        }
    }

    public static void wrap_throwable(Block block, Type wrapper) {
        CodeEmitter e = block.getCodeEmitter();
        e.catch_exception(block, AsmConsts.TYPE_THROWABLE);
        e.new_instance(wrapper);
        e.dup_x1();
        e.swap();
        e.invoke_constructor(wrapper, CSTRUCT_THROWABLE);
        e.athrow();
    }

    public static void add_properties(ClassEmitter ce, String[] names, Type[] types) {
        for (int i = 0; i < names.length; ++i) {
            String fieldName = "$ASM$prop_" + names[i];
            ce.declare_field(2, fieldName, types[i], null);
            Emitters.add_property(ce, names[i], types[i], fieldName);
        }
    }

    public static void add_property(ClassEmitter ce, String name, Type type, String fieldName) {
        String property = AsmTypes.upperFirst(name);
        CodeEmitter e = ce.begin_method(1, new Signature("get" + property, type, AsmConsts.TYPES_EMPTY), null);
        e.load_this();
        e.getfield(fieldName);
        e.return_value();
        e.end_method();
        e = ce.begin_method(1, new Signature("set" + property, Type.VOID_TYPE, new Type[]{type}), null);
        e.load_this();
        e.load_arg(0);
        e.putfield(fieldName);
        e.return_value();
        e.end_method();
    }

    public static void wrap_undeclared_throwable(CodeEmitter e, Block handler, Type[] exceptions, Type wrapper) {
        boolean needThrow;
        Set<Object> set;
        Set<Object> set2 = set = exceptions == null ? Collections.EMPTY_SET : new HashSet<Type>(Arrays.asList(exceptions));
        if (set.contains(AsmConsts.TYPE_THROWABLE)) {
            return;
        }
        boolean bl = needThrow = exceptions != null;
        if (!set.contains(AsmConsts.TYPE_RUNTIME_EXCEPTION)) {
            e.catch_exception(handler, AsmConsts.TYPE_RUNTIME_EXCEPTION);
            needThrow = true;
        }
        if (!set.contains(AsmConsts.TYPE_ERROR)) {
            e.catch_exception(handler, AsmConsts.TYPE_ERROR);
            needThrow = true;
        }
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                e.catch_exception(handler, exceptions[i]);
            }
        }
        if (needThrow) {
            e.athrow();
        }
        e.catch_exception(handler, AsmConsts.TYPE_THROWABLE);
        e.new_instance(wrapper);
        e.dup_x1();
        e.swap();
        e.invoke_constructor(wrapper, CSTRUCT_THROWABLE);
        e.athrow();
    }

    public static CodeEmitter begin_method(ClassEmitter e, MethodInfo method) {
        return Emitters.begin_method(e, method, method.getModifiers());
    }

    public static CodeEmitter begin_method(ClassEmitter e, MethodInfo method, int access) {
        return e.begin_method(access, method.getSignature(), method.getExceptionTypes());
    }

    private static interface ParameterTyper {
        public Type[] getParameterTypes(MethodInfo var1);
    }

    public static class ArrayDelimiters {
        private String before;
        private String inside;
        private String after;

        public ArrayDelimiters(String before, String inside, String after) {
            this.before = before;
            this.inside = inside;
            this.after = after;
        }
    }
}

