/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.reflect;

import io.polaris.core.asm.reflect.BeanAccess;
import io.polaris.core.asm.reflect.BeanCopier;
import io.polaris.core.asm.reflect.BeanLambdaAccess;
import io.polaris.core.asm.reflect.ClassAccess;
import io.polaris.core.asm.reflect.ClassLambdaAccess;
import io.polaris.core.asm.reflect.ConstructorAccess;
import io.polaris.core.asm.reflect.FieldAccess;
import io.polaris.core.asm.reflect.MethodAccess;
import io.polaris.core.asm.reflect.PublicConstructorAccess;
import io.polaris.core.io.IO;
import io.polaris.core.map.Maps;
import io.polaris.core.string.Strings;
import java.io.File;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class AccessClassLoader
extends ClassLoader {
    private static final Map<ClassLoader, AccessClassLoader> accessClassLoaders = Maps.newSoftMap(new ConcurrentHashMap());
    private static final ClassLoader selfContextParentClassLoader = AccessClassLoader.getParentClassLoader(AccessClassLoader.class);
    private static volatile AccessClassLoader selfContextAccessClassLoader = new AccessClassLoader(selfContextParentClassLoader);
    private static volatile Method defineClassMethod;
    private final Set<String> localClassNames = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Map<String, Class<?>> baseClasses;
    private static final String classBytesCacheDir;
    private static final boolean classBytesCacheEnabled;

    private AccessClassLoader(ClassLoader parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadOrDefineClass(String name, Supplier<byte[]> byteGenerator) {
        Class c = this.loadAccessClass(name);
        if (c == null) {
            AccessClassLoader accessClassLoader = this;
            synchronized (accessClassLoader) {
                c = this.loadAccessClass(name);
                if (c == null) {
                    c = this.defineAccessClass(name, byteGenerator.get());
                }
            }
        }
        return c;
    }

    Class loadAccessClass(String name) {
        if (this.localClassNames.contains(name)) {
            try {
                return this.loadClass(name, false);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        return null;
    }

    Class defineAccessClass(String name, byte[] bytes) throws ClassFormatError {
        this.localClassNames.add(name);
        if (classBytesCacheEnabled) {
            try {
                IO.writeBytes(new File(classBytesCacheDir + "/" + name.replace(".", "/") + ".class"), bytes);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.defineClass(name, bytes);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = baseClasses.get(name);
        if (c != null) {
            return c;
        }
        return super.loadClass(name, resolve);
    }

    Class<?> defineClass(String name, byte[] bytes) throws ClassFormatError {
        try {
            return (Class)AccessClassLoader.getDefineClassMethod().invoke((Object)this.getParent(), name, bytes, 0, bytes.length, this.getClass().getProtectionDomain());
        }
        catch (Exception exception) {
            return this.defineClass(name, bytes, 0, bytes.length, this.getClass().getProtectionDomain());
        }
    }

    public static boolean areInSameRuntimeClassLoader(Class type1, Class type2) {
        if (type1.getPackage() != type2.getPackage()) {
            return false;
        }
        ClassLoader loader1 = type1.getClassLoader();
        ClassLoader loader2 = type2.getClassLoader();
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        if (loader1 == null) {
            return loader2 == null || loader2 == systemClassLoader;
        }
        if (loader2 == null) {
            return loader1 == systemClassLoader;
        }
        return loader1 == loader2;
    }

    public static void registerBaseClass(Class<?> ... classes) {
        for (Class<?> c : classes) {
            baseClasses.put(c.getName(), c);
        }
    }

    public static String buildAccessClassName(Class<?> type, Class<?> baseAccessClass) {
        String className = type.getName();
        String accessClassName = className + "$$" + baseAccessClass.getSimpleName() + "$";
        if (accessClassName.startsWith("java.")) {
            accessClassName = "javax." + accessClassName.substring(5);
        }
        return accessClassName;
    }

    private static ClassLoader getParentClassLoader(Class type) {
        ClassLoader parent = type.getClassLoader();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Method getDefineClassMethod() throws Exception {
        if (defineClassMethod == null) {
            Map<ClassLoader, AccessClassLoader> map = accessClassLoaders;
            synchronized (map) {
                if (defineClassMethod == null) {
                    defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                    try {
                        defineClassMethod.setAccessible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return defineClassMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessClassLoader get(Class type) {
        ClassLoader parent = AccessClassLoader.getParentClassLoader(type);
        if (selfContextParentClassLoader.equals(parent)) {
            if (selfContextAccessClassLoader == null) {
                Map<ClassLoader, AccessClassLoader> map = accessClassLoaders;
                synchronized (map) {
                    if (selfContextAccessClassLoader == null) {
                        selfContextAccessClassLoader = new AccessClassLoader(selfContextParentClassLoader);
                    }
                }
            }
            return selfContextAccessClassLoader;
        }
        return accessClassLoaders.computeIfAbsent(parent, k -> new AccessClassLoader(parent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(ClassLoader parent) {
        if (selfContextParentClassLoader.equals(parent)) {
            selfContextAccessClassLoader = null;
        } else {
            Map<ClassLoader, AccessClassLoader> map = accessClassLoaders;
            synchronized (map) {
                accessClassLoaders.remove(parent);
            }
        }
    }

    public static int activeAccessClassLoaders() {
        int sz = accessClassLoaders.size();
        if (selfContextAccessClassLoader != null) {
            ++sz;
        }
        return sz;
    }

    static {
        baseClasses = new ConcurrentHashMap();
        AccessClassLoader.registerBaseClass(ClassAccess.class, ClassLambdaAccess.class, BeanCopier.class, BeanAccess.class, BeanLambdaAccess.class, MethodAccess.class, ConstructorAccess.class, PublicConstructorAccess.class, FieldAccess.class);
        String tmpdir = System.getProperty("java.class.bytes.tmpdir");
        if (Strings.isNotBlank(tmpdir)) {
            File dir = new File(tmpdir.trim());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            classBytesCacheDir = dir.getAbsolutePath();
            classBytesCacheEnabled = dir.exists();
        } else {
            classBytesCacheDir = null;
            classBytesCacheEnabled = false;
        }
    }
}

