/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.reflect;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

class AccessClassPool<K, V> {
    private final LimitedLinkedHashMap<K, V> raw;
    private final Map<K, V> pool;

    public AccessClassPool(int maxCapacity, int initialCapacity) {
        this.raw = new LimitedLinkedHashMap(maxCapacity, true, initialCapacity);
        this.pool = Collections.synchronizedMap(this.raw);
    }

    public AccessClassPool(int maxCapacity) {
        this(maxCapacity, 128);
    }

    public AccessClassPool() {
        this(10240);
    }

    public V get(K key) {
        return this.pool.get(key);
    }

    public V put(K key, V value) {
        return this.pool.put(key, value);
    }

    public V remove(Object key) {
        return this.pool.remove(key);
    }

    public V putIfAbsent(K key, V value) {
        return this.pool.putIfAbsent(key, value);
    }

    public boolean remove(Object key, Object value) {
        return this.pool.remove(key, value);
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.pool.computeIfAbsent((K)key, mappingFunction);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.pool.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.pool.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    public void clear() {
        this.pool.clear();
    }

    public int size() {
        return this.pool.size();
    }

    public int getMaxCapacity() {
        return this.raw.getMaxCapacity();
    }

    public void setMaxCapacity(int maxCapacity) {
        this.raw.setMaxCapacity(maxCapacity);
    }

    static class LimitedLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private int maxCapacity = 0;

        public LimitedLinkedHashMap(int maxCapacity) {
            this(maxCapacity, true);
        }

        public LimitedLinkedHashMap(int maxCapacity, boolean accessOrder) {
            this(maxCapacity, accessOrder, 128, 0.75f);
        }

        public LimitedLinkedHashMap(int maxCapacity, boolean accessOrder, int initialCapacity) {
            this(maxCapacity, accessOrder, initialCapacity, 0.75f);
        }

        public LimitedLinkedHashMap(int maxCapacity, boolean accessOrder, int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, accessOrder);
            this.maxCapacity = maxCapacity;
        }

        public void setMaxCapacity(int maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public int getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxCapacity;
        }
    }
}

