/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.reflect;

import io.polaris.core.asm.internal.AsmUtils;
import io.polaris.core.asm.reflect.AccessClassLoader;
import io.polaris.core.asm.reflect.AccessClassPool;
import io.polaris.core.asm.reflect.BeanAccess;
import io.polaris.core.asm.reflect.BeanDirectCopier;
import io.polaris.core.asm.reflect.BeanOptionsCopier;
import io.polaris.core.asm.reflect.BeanPropertyInfo;
import io.polaris.core.lang.JavaType;
import io.polaris.core.lang.TypeRef;
import io.polaris.core.lang.Types;
import io.polaris.core.lang.copier.CopyOptions;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.map.CaseInsensitiveMap;
import io.polaris.core.map.Maps;
import io.polaris.core.reflect.SerializableBiFunction;
import io.polaris.core.reflect.SerializableConsumer;
import io.polaris.core.reflect.SerializableConsumerWithArgs4;
import io.polaris.core.reflect.SerializableConsumerWithArgs5;
import io.polaris.core.reflect.SerializableConsumerWithArgs6;
import io.polaris.core.reflect.SerializableConsumerWithArgs7;
import io.polaris.core.reflect.SerializableFunction;
import io.polaris.core.reflect.SerializableFunctionWithArgs4;
import io.polaris.core.reflect.SerializableTriConsumer;
import io.polaris.core.reflect.SerializableTriFunction;
import io.polaris.core.string.StringCases;
import io.polaris.core.tuple.Tuple2;
import io.polaris.dependency.org.objectweb.asm.ClassWriter;
import io.polaris.dependency.org.objectweb.asm.FieldVisitor;
import io.polaris.dependency.org.objectweb.asm.Label;
import io.polaris.dependency.org.objectweb.asm.MethodVisitor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public abstract class BeanCopier<S> {
    private static ILogger log = ILoggers.of(BeanCopier.class);
    private static final AccessClassPool<Class<?>, BeanCopier> pool = new AccessClassPool();
    public static final String FIELD_PREFIX_TYPE = "type_";
    public static final String FIELD_PREFIX_CLASS = "class_";
    private final Map<Class<?>, BeanDirectCopier> fastCopiers = new ConcurrentHashMap();
    private final Map<Class<?>, BeanOptionsCopier> optionsCopiers = new ConcurrentHashMap();
    protected Class<S> sourceType;
    protected Map<String, BeanPropertyInfo> properties;

    protected BeanCopier() {
    }

    protected abstract void initTypeFields();

    public abstract void copyBeanToMap(@Nonnull S var1, @Nonnull Map<String, Object> var2);

    public final <K, V> void copyBeanToMap(@Nonnull S source, @Nonnull Type targetType, @Nonnull Map<K, V> target, BiFunction<Type, Object, Object> converter) {
        JavaType javaType = JavaType.of(targetType);
        JavaType keyType = JavaType.of(javaType.getActualType(Map.class, 0));
        JavaType valueType = JavaType.of(javaType.getActualType(Map.class, 1));
        this.copyBeanToMapByConverter(source, target, converter, keyType, valueType);
    }

    protected abstract void copyBeanToMapByConverter(@Nonnull Object var1, @Nonnull Map var2, BiFunction<Type, Object, Object> var3, @Nonnull JavaType var4, @Nonnull JavaType var5);

    public abstract void copyMapToBean(@Nonnull Map<String, Object> var1, @Nonnull S var2);

    public abstract void copyMapToBean(@Nonnull Map<String, Object> var1, @Nonnull S var2, BiFunction<Type, Object, Object> var3);

    public final <T> void copyBeanToBean(@Nonnull S source, @Nonnull T target) {
        this.copyBeanToBean(source, target.getClass(), target);
    }

    public final <T> void copyBeanToBean(@Nonnull S source, Class<T> type, @Nonnull T target) {
        Class<Object> targetType;
        Class<Object> clazz = targetType = type == null ? target.getClass() : type;
        if (this.sourceType.equals(targetType)) {
            this.copyBeanToBeanBySameType(source, target);
        } else {
            BeanDirectCopier copier = this.fastCopiers.computeIfAbsent(targetType, k -> BeanDirectCopier.create(this, targetType));
            copier.copy(source, target);
        }
    }

    protected abstract void copyBeanToBeanBySameType(@Nonnull S var1, @Nonnull S var2);

    public final void copyBeanToMap(@Nonnull S source, @Nonnull Map<String, Object> target, @Nonnull CopyOptions options) {
        this.copyBeanToMap(source, new TypeRef<Map<String, Object>>(){}.getType(), target, options);
    }

    public final <K, V> void copyBeanToMap(@Nonnull S source, @Nonnull Type targetType, @Nonnull Map<K, V> target, @Nonnull CopyOptions options) {
        JavaType javaType = JavaType.of(targetType);
        JavaType keyType = JavaType.of(javaType.getActualType(Map.class, 0));
        JavaType valueType = JavaType.of(javaType.getActualType(Map.class, 1));
        this.copyBeanToMapByOptions(source, target, options, keyType, valueType);
    }

    protected abstract <K, V> void copyBeanToMapByOptions(@Nonnull S var1, @Nonnull Map<K, V> var2, @Nonnull CopyOptions var3, @Nonnull JavaType var4, @Nonnull JavaType var5);

    protected final void copyBeanToMapWithKeyByOptions(@Nonnull Map target, @Nonnull CopyOptions options, @Nonnull JavaType keyType, @Nonnull JavaType valueType, String sourceKey, Object sourceValue) {
        Object orig;
        if (sourceValue == null && options.ignoreNull()) {
            return;
        }
        Object k = options.editKey(sourceKey);
        if (k == null) {
            return;
        }
        k = options.convert(keyType.getRawType(), k);
        if (k == null) {
            return;
        }
        if ((sourceValue = options.editValue(sourceKey, sourceValue)) == null && options.ignoreNull()) {
            return;
        }
        if (!options.override() && (orig = target.get(k)) != null) {
            return;
        }
        sourceValue = options.convert(valueType.getRawType(), sourceValue);
        if (sourceValue == null && options.ignoreNull()) {
            return;
        }
        target.put(k, sourceValue);
    }

    public final void copyMapToBean(@Nonnull Map<String, Object> source, @Nonnull S target, @Nonnull CopyOptions options) {
        LinkedHashSet<String> targetKeys = new LinkedHashSet<String>(this.properties.size());
        this.properties.forEach((k, v) -> {
            if (v.hasSetter()) {
                targetKeys.add(v.getPropertyName());
            }
        });
        if (!options.hasKeyMapping()) {
            this.copyMapToBeanWithSameKeys(source, target, options, targetKeys);
        } else {
            HashMap<String, String> keyMapping = new HashMap<String, String>();
            for (String string : source.keySet()) {
                String mapKey = options.editKey(string);
                if (!targetKeys.contains(mapKey)) continue;
                keyMapping.putIfAbsent(mapKey, string);
            }
            this.copyMapToBeanWithCustomKeys(source, target, options, targetKeys, keyMapping);
        }
        if (options.ignoreCapitalize() && !targetKeys.isEmpty()) {
            this.copyMapToBeanWithCapitalizeKeys(source, target, options, targetKeys);
        }
        if (options.enableUnderlineToCamelCase() && !targetKeys.isEmpty()) {
            this.copyMapToBeanWithUnderlineToCamelKeys(source, target, options, targetKeys);
        }
        if (options.enableCamelToUnderlineCase() && !targetKeys.isEmpty()) {
            this.copyMapToBeanWithCamelToUnderlineKeys(source, target, options, targetKeys);
        }
        if (options.ignoreCase() && !targetKeys.isEmpty()) {
            CaseInsensitiveMap<String, Object> upperCaseSource = null;
            if (!options.hasKeyMapping()) {
                if (upperCaseSource == null) {
                    upperCaseSource = new CaseInsensitiveMap<String, Object>(HashMap::new, source);
                }
                this.copyMapToBeanWithSameKeys(upperCaseSource, target, options, targetKeys);
            } else {
                CaseInsensitiveMap<String, String> upperCaseTarget = new CaseInsensitiveMap<String, String>(HashMap::new);
                for (String key : targetKeys) {
                    upperCaseTarget.put(key, key);
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (String key : source.keySet()) {
                    String mapKey = options.editKey(key);
                    String targetKey = (String)upperCaseTarget.get(mapKey);
                    if (targetKey == null) continue;
                    hashMap.putIfAbsent(targetKey, key);
                }
                this.copyMapToBeanWithCustomKeys(source, target, options, targetKeys, hashMap);
            }
            if (options.enableUnderlineToCamelCase() && !targetKeys.isEmpty()) {
                if (upperCaseSource == null) {
                    upperCaseSource = new CaseInsensitiveMap<String, Object>(HashMap::new, source);
                }
                this.copyMapToBeanWithUnderlineToCamelKeys(upperCaseSource, target, options, targetKeys);
            }
            if (options.enableCamelToUnderlineCase() && !targetKeys.isEmpty()) {
                if (upperCaseSource == null) {
                    upperCaseSource = new CaseInsensitiveMap<String, Object>(HashMap::new, source);
                }
                this.copyMapToBeanWithCamelToUnderlineKeys(upperCaseSource, target, options, targetKeys);
            }
        }
    }

    protected abstract void copyMapToBeanWithCustomKeys(@Nonnull Map<String, Object> var1, @Nonnull Object var2, @Nonnull CopyOptions var3, @Nonnull Set<String> var4, @Nonnull Map<String, String> var5);

    protected abstract void copyMapToBeanWithSameKeys(@Nonnull Map<String, Object> var1, @Nonnull Object var2, @Nonnull CopyOptions var3, @Nonnull Set<String> var4);

    protected abstract void copyMapToBeanWithCapitalizeKeys(@Nonnull Map<String, Object> var1, @Nonnull Object var2, @Nonnull CopyOptions var3, @Nonnull Set<String> var4);

    protected abstract void copyMapToBeanWithUnderlineToCamelKeys(@Nonnull Map<String, Object> var1, @Nonnull Object var2, @Nonnull CopyOptions var3, @Nonnull Set<String> var4);

    protected abstract void copyMapToBeanWithCamelToUnderlineKeys(@Nonnull Map<String, Object> var1, @Nonnull Object var2, @Nonnull CopyOptions var3, @Nonnull Set<String> var4);

    public final <T> void copyBeanToBean(@Nonnull S source, @Nonnull T target, @Nonnull CopyOptions options) {
        this.copyBeanToBean(source, target.getClass(), target, options);
    }

    public final <T> void copyBeanToBean(@Nonnull S source, @Nonnull Class<T> targetType, @Nonnull T target, @Nonnull CopyOptions options) {
        if (!options.hasKeyMapping()) {
            BeanOptionsCopier copier = this.optionsCopiers.computeIfAbsent(targetType, k -> BeanOptionsCopier.create(this, targetType));
            copier.copy(source, target, options);
        } else {
            BeanAccess<S> sourceBeanAccess = BeanAccess.get(this.sourceType);
            BeanAccess<T> targetBeanAccess = BeanAccess.get(targetType);
            Map<String, BeanPropertyInfo> sourceProperties = sourceBeanAccess.properties();
            Map<String, BeanPropertyInfo> targetProperties = targetBeanAccess.properties();
            LinkedHashSet<String> targetKeys = new LinkedHashSet<String>(targetBeanAccess.allPropertyNames());
            List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> sameKeyMapping = BeanOptionsCopier.buildCustomKeyMapping(sourceProperties, targetProperties, options.keyMapping(), false);
            this.copyBeanToBeanWithDynamicKeyMappings(sourceBeanAccess, source, targetBeanAccess, target, options, targetKeys, sameKeyMapping);
            if (options.ignoreCapitalize() && !targetKeys.isEmpty()) {
                List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> capitalizeKeyMapping = BeanOptionsCopier.buildCapitalizeKeyMapping(sourceProperties, targetProperties);
                this.copyBeanToBeanWithDynamicKeyMappings(sourceBeanAccess, source, targetBeanAccess, target, options, targetKeys, capitalizeKeyMapping);
            }
            if (options.enableUnderlineToCamelCase() && !targetKeys.isEmpty()) {
                List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> underlineToCamelKeyMapping = BeanOptionsCopier.buildUnderlineToCamelKeyMapping(sourceProperties, targetProperties, false);
                this.copyBeanToBeanWithDynamicKeyMappings(sourceBeanAccess, source, targetBeanAccess, target, options, targetKeys, underlineToCamelKeyMapping);
            }
            if (options.enableCamelToUnderlineCase() && !targetKeys.isEmpty()) {
                List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> camelToUnderlineKeyMapping = BeanOptionsCopier.buildCamelToUnderlineKeyMapping(sourceProperties, targetProperties, false);
                this.copyBeanToBeanWithDynamicKeyMappings(sourceBeanAccess, source, targetBeanAccess, target, options, targetKeys, camelToUnderlineKeyMapping);
            }
            if (options.ignoreCase() && !targetKeys.isEmpty()) {
                Map<String, BeanPropertyInfo> sourceUpperProperties = Maps.newUpperCaseHashMap();
                sourceUpperProperties.putAll(sourceProperties);
                List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> sameKeyMappingIgnoreCase = BeanOptionsCopier.buildSameKeyMapping(sourceUpperProperties, targetProperties, true);
                this.copyBeanToBeanWithDynamicKeyMappings(sourceBeanAccess, source, targetBeanAccess, target, options, targetKeys, sameKeyMappingIgnoreCase);
                if (options.enableUnderlineToCamelCase()) {
                    List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> underlineToCamelKeyMappingIgnoreCase = BeanOptionsCopier.buildUnderlineToCamelKeyMapping(sourceUpperProperties, targetProperties, true);
                    this.copyBeanToBeanWithDynamicKeyMappings(sourceBeanAccess, source, targetBeanAccess, target, options, targetKeys, underlineToCamelKeyMappingIgnoreCase);
                }
                if (options.enableCamelToUnderlineCase()) {
                    List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> camelToUnderlineKeyMappingIgnoreCase = BeanOptionsCopier.buildCamelToUnderlineKeyMapping(sourceUpperProperties, targetProperties, true);
                    this.copyBeanToBeanWithDynamicKeyMappings(sourceBeanAccess, source, targetBeanAccess, target, options, targetKeys, camelToUnderlineKeyMappingIgnoreCase);
                }
            }
        }
    }

    protected final <T> void copyBeanToBeanWithDynamicKeyMappings(@Nonnull BeanAccess<S> sourceBeanAccess, @Nonnull S source, @Nonnull BeanAccess<T> targetBeanAccess, @Nonnull T target, @Nonnull CopyOptions options, @Nonnull Set<String> targetKeys, @Nonnull List<Tuple2<BeanPropertyInfo, BeanPropertyInfo>> mapping) {
        for (Tuple2<BeanPropertyInfo, BeanPropertyInfo> tuple : mapping) {
            String sourceKey = tuple.getFirst().getPropertyName();
            String targetKey = tuple.getSecond().getPropertyName();
            try {
                this.copyBeanToBeanWithDynamicKeyMapping(targetBeanAccess, target, sourceKey, targetKey, () -> sourceBeanAccess.getPropertyOrField(source, sourceKey), options, targetKeys);
            }
            catch (Throwable e) {
                this.resolveCopyError(sourceKey + "->" + targetKey, e, options);
            }
        }
    }

    protected final <T> void copyBeanToBeanWithDynamicKeyMapping(@Nonnull BeanAccess<T> targetBeanAccess, @Nonnull T target, @Nonnull String sourceKey, @Nonnull String targetKey, @Nonnull Supplier<Object> valueSupplier, @Nonnull CopyOptions options, @Nonnull Set<String> targetKeys) {
        if (options.isIgnoredKey(sourceKey) || !targetKeys.contains(targetKey)) {
            return;
        }
        Map<String, BeanPropertyInfo> map = targetBeanAccess.properties();
        BeanPropertyInfo info = map.get(targetKey);
        if (info == null) {
            return;
        }
        if (info.getField() != null) {
            Object orig;
            if (!options.override() && (orig = targetBeanAccess.getField(target, targetKey)) != null) {
                return;
            }
            Object value = valueSupplier.get();
            if (value == null && options.ignoreNull()) {
                return;
            }
            Type type = info.getPropertyGenericType();
            value = options.editValue(sourceKey, value);
            if ((value = options.convert(type, value)) == null) {
                if (options.ignoreNull()) {
                    return;
                }
                if (info.getPropertyType().isPrimitive()) {
                    return;
                }
            }
            targetBeanAccess.setField(target, targetKey, value);
            targetKeys.remove(targetKey);
        } else {
            Object orig;
            if (info.getWriteMethod() == null) {
                return;
            }
            if (!options.override() && info.getReadMethod() != null && (orig = targetBeanAccess.getProperty(target, targetKey)) != null) {
                return;
            }
            Object value = valueSupplier.get();
            if (value == null && options.ignoreNull()) {
                return;
            }
            Type type = info.getPropertyGenericType();
            value = options.editValue(sourceKey, value);
            if ((value = options.convert(type, value)) == null) {
                if (options.ignoreNull()) {
                    return;
                }
                if (info.getPropertyType().isPrimitive()) {
                    return;
                }
            }
            targetBeanAccess.setProperty(target, targetKey, value);
            targetKeys.remove(targetKey);
        }
    }

    protected final void resolveCopyError(String propertyName, Throwable e) {
        if (log.isDebugEnabled()) {
            log.debug("\u590d\u5236\u5c5e\u6027[" + propertyName + "]\u5931\u8d25", e);
        }
    }

    protected final void resolveCopyError(@Nonnull String propertyName, @Nonnull Throwable e, @Nonnull CopyOptions options) {
        String msg = "\u590d\u5236\u5c5e\u6027[" + propertyName + "]\u5931\u8d25";
        if (options.ignoreError()) {
            log.warn(msg + ": " + e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug(msg, e);
            }
        } else {
            throw new IllegalArgumentException(msg, e);
        }
    }

    protected final Type getPropertyGenericType(@Nonnull String propertyName) {
        return this.properties.get(propertyName).getPropertyGenericType();
    }

    protected final Class<?> getPropertyType(@Nonnull String propertyName) {
        return this.properties.get(propertyName).getPropertyType();
    }

    protected final Object convert(@Nonnull Type type, Object value, BiFunction<Type, Object, Object> converter) {
        if (value == null) {
            return null;
        }
        if (JavaType.of(type).isInstance(value)) {
            return value;
        }
        if (converter == null) {
            return null;
        }
        return converter.apply(type, value);
    }

    public static <T> BeanCopier<T> get(@Nonnull Class<T> type) {
        return pool.computeIfAbsent(type, BeanCopier::create);
    }

    public static <T> BeanCopier<T> create(@Nonnull Class<T> type) {
        BeanPropertyInfo.Classification classification = BeanPropertyInfo.classify(type);
        String accessClassName = AccessClassLoader.buildAccessClassName(type, BeanCopier.class);
        AccessClassLoader loader = AccessClassLoader.get(type);
        Class accessClass = loader.loadOrDefineClass(accessClassName, () -> BeanCopier.buildAccessClass(loader, accessClassName, type, classification));
        try {
            BeanCopier access = (BeanCopier)accessClass.newInstance();
            access.sourceType = type;
            access.properties = Collections.unmodifiableMap(classification.properties);
            access.initTypeFields();
            return access;
        }
        catch (Throwable t) {
            throw new IllegalStateException("\u521b\u5efa\u8bbf\u95ee\u7c7b\u5931\u8d25: " + accessClassName, t);
        }
    }

    private static <T> byte[] buildAccessClass(AccessClassLoader loader, String accessClassName, Class<T> type, BeanPropertyInfo.Classification classification) {
        String accessClassNameInternal = accessClassName.replace('.', '/');
        ClassWriter cw = new ClassWriter(2);
        String superClassNameInternal = BeanCopier.class.getName().replace('.', '/');
        cw.visit(52, 33, accessClassNameInternal, "L" + superClassNameInternal + "<L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";>;", superClassNameInternal, null);
        cw.visitInnerClass("java/lang/invoke/MethodHandles$Lookup", "java/lang/invoke/MethodHandles", "Lookup", 25);
        AsmUtils.insertDefaultConstructor(cw, superClassNameInternal);
        BeanCopier.insertInitTypeFields(cw, superClassNameInternal, accessClassNameInternal, type, classification);
        BeanCopier.insertBeanToMap(cw, superClassNameInternal, accessClassNameInternal, type, classification);
        BeanCopier.insertBeanToMapByConverter(cw, superClassNameInternal, accessClassNameInternal, type, classification);
        BeanCopier.insertMapToBean(cw, superClassNameInternal, accessClassNameInternal, type, classification);
        BeanCopier.insertMapToBeanByConverter(cw, superClassNameInternal, accessClassNameInternal, type, classification);
        BeanCopier.insertBeanToBeanBySameType(cw, superClassNameInternal, accessClassNameInternal, type, classification);
        BeanCopier.insertBeanToMapByOptions(cw, superClassNameInternal, accessClassNameInternal, type, classification);
        BeanCopier.insertMapToBeanWithSourceKeyAll(cw, superClassNameInternal, accessClassNameInternal, type, classification);
        BeanCopier.insertMapToBeanWithCustomKeys(cw, accessClassNameInternal, type, classification);
        BeanCopier.insertMapToBeanWithSourceKeys(cw, accessClassNameInternal, type, classification, BeanCopier::copyMapToBeanWithSameKeys, key -> key);
        BeanCopier.insertMapToBeanWithSourceKeys(cw, accessClassNameInternal, type, classification, BeanCopier::copyMapToBeanWithCapitalizeKeys, key -> {
            if (key.length() > 1) {
                String mapKey = Character.isUpperCase(key.charAt(0)) ? Character.toLowerCase(key.charAt(0)) + key.substring(1) : Character.toUpperCase(key.charAt(0)) + key.substring(1);
                return mapKey;
            }
            return null;
        });
        BeanCopier.insertMapToBeanWithSourceKeys(cw, accessClassNameInternal, type, classification, BeanCopier::copyMapToBeanWithUnderlineToCamelKeys, key -> {
            String mapKey = StringCases.camelToUnderlineCase(key);
            if (!key.equals(mapKey)) {
                return mapKey;
            }
            return null;
        });
        BeanCopier.insertMapToBeanWithSourceKeys(cw, accessClassNameInternal, type, classification, BeanCopier::copyMapToBeanWithCamelToUnderlineKeys, key -> {
            if (key.indexOf(95) >= 0) {
                String mapKey = StringCases.underlineToCamelCase(key);
                return mapKey;
            }
            return null;
        });
        cw.visitEnd();
        byte[] byteArray = cw.toByteArray();
        return byteArray;
    }

    private static <T> void insertInitTypeFields(ClassWriter cw, String superClassNameInternal, String accessClassNameInternal, Class<T> type, BeanPropertyInfo.Classification classification) {
        SerializableConsumer init = BeanCopier::initTypeFields;
        SerializableBiFunction getPropertyGenericType = BeanCopier::getPropertyGenericType;
        SerializableBiFunction getPropertyType = BeanCopier::getPropertyType;
        BeanCopier.insertInitTypes(cw, superClassNameInternal, accessClassNameInternal, classification, init.serialized().getImplMethodName(), getPropertyGenericType.serialized().getImplMethodName(), getPropertyType.serialized().getImplMethodName());
    }

    static void insertInitTypes(ClassWriter cw, String superClassNameInternal, String accessClassNameInternal, BeanPropertyInfo.Classification classification, String initTypesMethodName, String getPropertyGenericTypeMethodName, String getPropertyTypeMethodName) {
        classification.properties.forEach((name, info) -> {
            FieldVisitor fieldVisitor = cw.visitField(4, FIELD_PREFIX_TYPE + name, "Ljava/lang/reflect/Type;", null, null);
            fieldVisitor.visitEnd();
            fieldVisitor = cw.visitField(4, FIELD_PREFIX_CLASS + name, "Ljava/lang/Class;", null, null);
            fieldVisitor.visitEnd();
        });
        MethodVisitor methodVisitor = cw.visitMethod(4, initTypesMethodName, "()V", null, null);
        methodVisitor.visitCode();
        classification.properties.forEach((name, info) -> {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitLdcInsn(name);
            methodVisitor.visitMethodInsn(183, superClassNameInternal, getPropertyGenericTypeMethodName, "(Ljava/lang/String;)Ljava/lang/reflect/Type;", false);
            methodVisitor.visitFieldInsn(181, accessClassNameInternal, FIELD_PREFIX_TYPE + name, "Ljava/lang/reflect/Type;");
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitLdcInsn(name);
            methodVisitor.visitMethodInsn(183, superClassNameInternal, getPropertyTypeMethodName, "(Ljava/lang/String;)Ljava/lang/Class;", false);
            methodVisitor.visitFieldInsn(181, accessClassNameInternal, FIELD_PREFIX_CLASS + name, "Ljava/lang/Class;");
        });
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static <T> void insertBeanToMap(ClassWriter cw, String superClassNameInternal, String accessClassNameInternal, Class<T> type, BeanPropertyInfo.Classification classification) {
        SerializableTriConsumer<BeanCopier, String, Throwable> resolveCopyError = BeanCopier::resolveCopyError;
        SerializableTriConsumer<BeanCopier, Object, Map> copyBeanToMap = BeanCopier::copyBeanToMap;
        String copyBeanToMapName = copyBeanToMap.serialized().getImplMethodName();
        MethodVisitor methodVisitor = cw.visitMethod(1, copyBeanToMapName, "(L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";Ljava/util/Map;)V", "(L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;)V", null);
        methodVisitor.visitCode();
        classification.properties.forEach((name, info) -> {
            if (info.getField() != null) {
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitLdcInsn(name);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitFieldInsn(180, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(info.getField().getDeclaringClass()), (String)name, io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(info.getField().getType()));
                AsmUtils.autoBoxing(methodVisitor, info.getField().getType());
                methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
                methodVisitor.visitInsn(87);
            } else if (info.getReadMethod() != null) {
                Method readMethod;
                Class<?> declaringClass;
                boolean isInterface;
                boolean hasThrows = info.getReadMethod().getExceptionTypes().length > 0;
                Label labelStart = new Label();
                Label labelEnd = new Label();
                Label labelCatch = new Label();
                if (hasThrows) {
                    methodVisitor.visitTryCatchBlock(labelStart, labelEnd, labelCatch, "java/lang/Throwable");
                    methodVisitor.visitLabel(labelStart);
                }
                int invokeOpcode = (isInterface = (declaringClass = (readMethod = info.getReadMethod()).getDeclaringClass()).isInterface()) ? 185 : (Modifier.isStatic(readMethod.getModifiers()) ? 184 : 182);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitLdcInsn(name);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitMethodInsn(invokeOpcode, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(declaringClass), readMethod.getName(), io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(readMethod), isInterface);
                Class<?> returnType = readMethod.getReturnType();
                AsmUtils.autoBoxing(methodVisitor, returnType);
                methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
                methodVisitor.visitInsn(87);
                methodVisitor.visitLabel(labelEnd);
                Label labelFinal = new Label();
                methodVisitor.visitJumpInsn(167, labelFinal);
                methodVisitor.visitLabel(labelCatch);
                methodVisitor.visitVarInsn(58, 3);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitLdcInsn(name);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitMethodInsn(183, superClassNameInternal, resolveCopyError.serialized().getImplMethodName(), "(Ljava/lang/String;Ljava/lang/Throwable;)V", false);
                methodVisitor.visitLabel(labelFinal);
            }
        });
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = cw.visitMethod(4161, copyBeanToMapName, "(Ljava/lang/Object;Ljava/util/Map;)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitMethodInsn(182, accessClassNameInternal, copyBeanToMapName, "(L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";Ljava/util/Map;)V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 3);
        methodVisitor.visitEnd();
    }

    private static <T> void insertBeanToMapByConverter(ClassWriter cw, String superClassNameInternal, String accessClassNameInternal, Class<T> type, BeanPropertyInfo.Classification classification) {
        SerializableTriConsumer<BeanCopier, String, Throwable> resolveCopyError = BeanCopier::resolveCopyError;
        SerializableConsumerWithArgs6<BeanCopier, Object, Map, BiFunction, JavaType, JavaType> copyBeanToMap = BeanCopier::copyBeanToMapByConverter;
        SerializableFunctionWithArgs4<BeanCopier, Type, Object, BiFunction, Object> convert = BeanCopier::convert;
        MethodVisitor methodVisitor = cw.visitMethod(4, copyBeanToMap.serialized().getImplMethodName(), "(Ljava/lang/Object;Ljava/util/Map;Ljava/util/function/BiFunction;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(JavaType.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(JavaType.class) + ")V", "(Ljava/lang/Object;Ljava/util/Map;Ljava/util/function/BiFunction<Ljava/lang/reflect/Type;Ljava/lang/Object;Ljava/lang/Object;>;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(JavaType.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(JavaType.class) + ")V", null);
        methodVisitor.visitCode();
        classification.properties.forEach((name, info) -> {
            if (!info.hasGetter()) {
                return;
            }
            Label label0 = new Label();
            Label label1 = new Label();
            Label label2 = new Label();
            methodVisitor.visitTryCatchBlock(label0, label1, label2, "java/lang/Throwable");
            methodVisitor.visitLabel(label0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
            if (info.getField() != null) {
                methodVisitor.visitFieldInsn(180, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(info.getField().getDeclaringClass()), (String)name, io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(info.getField().getType()));
                AsmUtils.autoBoxing(methodVisitor, info.getField().getType());
            } else {
                Method readMethod = info.getReadMethod();
                Class<?> declaringClass = readMethod.getDeclaringClass();
                boolean isInterface = declaringClass.isInterface();
                int invokeOpcode = isInterface ? 185 : (Modifier.isStatic(readMethod.getModifiers()) ? 184 : 182);
                methodVisitor.visitMethodInsn(invokeOpcode, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(declaringClass), readMethod.getName(), io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(readMethod), isInterface);
                Class<?> returnType = readMethod.getReturnType();
                AsmUtils.autoBoxing(methodVisitor, returnType);
            }
            methodVisitor.visitVarInsn(58, 6);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 5);
            methodVisitor.visitVarInsn(25, 6);
            methodVisitor.visitVarInsn(25, 3);
            methodVisitor.visitMethodInsn(183, superClassNameInternal, convert.serialized().getImplMethodName(), "(Ljava/lang/reflect/Type;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", false);
            methodVisitor.visitVarInsn(58, 6);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 4);
            methodVisitor.visitLdcInsn(info.getPropertyName());
            methodVisitor.visitVarInsn(25, 3);
            methodVisitor.visitMethodInsn(183, superClassNameInternal, convert.serialized().getImplMethodName(), "(Ljava/lang/reflect/Type;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", false);
            methodVisitor.visitVarInsn(58, 7);
            methodVisitor.visitVarInsn(25, 7);
            methodVisitor.visitJumpInsn(198, label1);
            methodVisitor.visitVarInsn(25, 6);
            methodVisitor.visitJumpInsn(198, label1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitVarInsn(25, 7);
            methodVisitor.visitVarInsn(25, 6);
            methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
            methodVisitor.visitInsn(87);
            methodVisitor.visitLabel(label1);
            Label label3 = new Label();
            methodVisitor.visitJumpInsn(167, label3);
            methodVisitor.visitLabel(label2);
            methodVisitor.visitVarInsn(58, 6);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitLdcInsn(info.getPropertyName());
            methodVisitor.visitVarInsn(25, 6);
            methodVisitor.visitMethodInsn(183, superClassNameInternal, resolveCopyError.serialized().getImplMethodName(), "(Ljava/lang/String;Ljava/lang/Throwable;)V", false);
            methodVisitor.visitLabel(label3);
        });
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private static <T> void insertMapToBean(ClassWriter cw, String superClassNameInternal, String accessClassNameInternal, Class<T> type, BeanPropertyInfo.Classification classification) {
        SerializableTriConsumer<BeanCopier, String, Throwable> resolveCopyError = BeanCopier::resolveCopyError;
        SerializableTriConsumer<BeanCopier, Map, Object> copyMapToBean = BeanCopier::copyMapToBean;
        String copyMapToBeanName = copyMapToBean.serialized().getImplMethodName();
        MethodVisitor methodVisitor = cw.visitMethod(1, copyMapToBeanName, "(Ljava/util/Map;L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";)V", "(LLjava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";)V", null);
        methodVisitor.visitCode();
        classification.properties.forEach((name, info) -> {
            if (info.getField() != null) {
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitLdcInsn(name);
                methodVisitor.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                methodVisitor.visitVarInsn(58, 3);
                methodVisitor.visitVarInsn(25, 3);
                Label labelIf = new Label();
                methodVisitor.visitJumpInsn(198, labelIf);
                methodVisitor.visitLdcInsn(io.polaris.dependency.org.objectweb.asm.Type.getType(Types.getWrapperClass(info.getField().getType())));
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitMethodInsn(182, "java/lang/Class", "isInstance", "(Ljava/lang/Object;)Z", false);
                methodVisitor.visitJumpInsn(153, labelIf);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitVarInsn(25, 3);
                AsmUtils.autoUnBoxing(methodVisitor, info.getField().getType());
                methodVisitor.visitFieldInsn(181, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(info.getField().getDeclaringClass()), (String)name, io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(info.getField().getType()));
                methodVisitor.visitLabel(labelIf);
            } else if (info.getWriteMethod() != null) {
                Method method;
                Class<?> declaringClass;
                boolean isInterface;
                boolean hasThrows = info.getWriteMethod().getExceptionTypes().length > 0;
                Label labelStart = new Label();
                Label labelEnd = new Label();
                Label labelCatch = new Label();
                if (hasThrows) {
                    methodVisitor.visitTryCatchBlock(labelStart, labelEnd, labelCatch, "java/lang/Throwable");
                    methodVisitor.visitLabel(labelStart);
                }
                int invokeOpcode = (isInterface = (declaringClass = (method = info.getWriteMethod()).getDeclaringClass()).isInterface()) ? 185 : (Modifier.isStatic(method.getModifiers()) ? 184 : 182);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitLdcInsn(name);
                methodVisitor.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                methodVisitor.visitVarInsn(58, 3);
                methodVisitor.visitVarInsn(25, 3);
                Label labelIf = new Label();
                methodVisitor.visitJumpInsn(198, labelIf);
                methodVisitor.visitLdcInsn(io.polaris.dependency.org.objectweb.asm.Type.getType(Types.getWrapperClass(method.getParameterTypes()[0])));
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitMethodInsn(182, "java/lang/Class", "isInstance", "(Ljava/lang/Object;)Z", false);
                methodVisitor.visitJumpInsn(153, labelIf);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitVarInsn(25, 3);
                io.polaris.dependency.org.objectweb.asm.Type paramType = io.polaris.dependency.org.objectweb.asm.Type.getType(method.getParameterTypes()[0]);
                AsmUtils.autoUnBoxing(methodVisitor, paramType);
                methodVisitor.visitMethodInsn(invokeOpcode, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(declaringClass), method.getName(), io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(method), isInterface);
                methodVisitor.visitLabel(labelIf);
                methodVisitor.visitLabel(labelEnd);
                Label labelFinal = new Label();
                methodVisitor.visitJumpInsn(167, labelFinal);
                methodVisitor.visitLabel(labelCatch);
                methodVisitor.visitVarInsn(58, 3);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitLdcInsn(name);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitMethodInsn(183, superClassNameInternal, resolveCopyError.serialized().getImplMethodName(), "(Ljava/lang/String;Ljava/lang/Throwable;)V", false);
                methodVisitor.visitLabel(labelFinal);
            }
        });
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = cw.visitMethod(4161, copyMapToBeanName, "(Ljava/util/Map;Ljava/lang/Object;)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
        methodVisitor.visitMethodInsn(182, accessClassNameInternal, copyMapToBeanName, "(Ljava/util/Map;L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";)V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 3);
        methodVisitor.visitEnd();
    }

    private static <T> void insertMapToBeanByConverter(ClassWriter cw, String superClassNameInternal, String accessClassNameInternal, Class<T> type, BeanPropertyInfo.Classification classification) {
        SerializableConsumerWithArgs4<BeanCopier, Map, Object, BiFunction> copyMapToBean = BeanCopier::copyMapToBean;
        SerializableFunctionWithArgs4<BeanCopier, Type, Object, BiFunction, Object> convert = BeanCopier::convert;
        SerializableTriConsumer<BeanCopier, String, Throwable> resolveCopyError = BeanCopier::resolveCopyError;
        String copyMapToBeanName = copyMapToBean.serialized().getImplMethodName();
        MethodVisitor methodVisitor = cw.visitMethod(4, copyMapToBeanName, "(Ljava/util/Map;L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";Ljava/util/function/BiFunction;)V", "(Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";Ljava/util/function/BiFunction<Ljava/lang/reflect/Type;Ljava/lang/Object;Ljava/lang/Object;>;)V", null);
        methodVisitor.visitCode();
        classification.properties.forEach((name, info) -> {
            if (info.getField() != null) {
                Label labelStart = new Label();
                Label labelEnd = new Label();
                Label labelCatch = new Label();
                methodVisitor.visitTryCatchBlock(labelStart, labelEnd, labelCatch, "java/lang/Throwable");
                methodVisitor.visitLabel(labelStart);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitLdcInsn(name);
                methodVisitor.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                methodVisitor.visitVarInsn(58, 4);
                methodVisitor.visitVarInsn(25, 4);
                Label labelIf = new Label();
                methodVisitor.visitJumpInsn(198, labelIf);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, accessClassNameInternal, FIELD_PREFIX_TYPE + name, "Ljava/lang/reflect/Type;");
                methodVisitor.visitVarInsn(25, 4);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitMethodInsn(183, superClassNameInternal, convert.serialized().getImplMethodName(), "(Ljava/lang/reflect/Type;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", false);
                methodVisitor.visitVarInsn(58, 4);
                methodVisitor.visitVarInsn(25, 4);
                methodVisitor.visitJumpInsn(198, labelIf);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitVarInsn(25, 4);
                AsmUtils.autoUnBoxing(methodVisitor, io.polaris.dependency.org.objectweb.asm.Type.getType(info.getField().getType()));
                methodVisitor.visitFieldInsn(181, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(info.getField().getDeclaringClass()), (String)name, io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(info.getField().getType()));
                methodVisitor.visitLabel(labelIf);
                methodVisitor.visitLabel(labelEnd);
                Label labelFinal = new Label();
                methodVisitor.visitJumpInsn(167, labelFinal);
                methodVisitor.visitLabel(labelCatch);
                methodVisitor.visitVarInsn(58, 4);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitLdcInsn(name);
                methodVisitor.visitVarInsn(25, 4);
                methodVisitor.visitMethodInsn(183, superClassNameInternal, resolveCopyError.serialized().getImplMethodName(), "(Ljava/lang/String;Ljava/lang/Throwable;)V", false);
                methodVisitor.visitLabel(labelFinal);
            } else if (info.getWriteMethod() != null) {
                Label labelStart = new Label();
                Label labelEnd = new Label();
                Label labelCatch = new Label();
                methodVisitor.visitTryCatchBlock(labelStart, labelEnd, labelCatch, "java/lang/Throwable");
                methodVisitor.visitLabel(labelStart);
                Method method = info.getWriteMethod();
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitLdcInsn(name);
                methodVisitor.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                methodVisitor.visitVarInsn(58, 4);
                methodVisitor.visitVarInsn(25, 4);
                Label labelIf = new Label();
                methodVisitor.visitJumpInsn(198, labelIf);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, accessClassNameInternal, FIELD_PREFIX_TYPE + name, "Ljava/lang/reflect/Type;");
                methodVisitor.visitVarInsn(25, 4);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitMethodInsn(183, superClassNameInternal, convert.serialized().getImplMethodName(), "(Ljava/lang/reflect/Type;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", false);
                methodVisitor.visitVarInsn(58, 4);
                methodVisitor.visitVarInsn(25, 4);
                methodVisitor.visitJumpInsn(198, labelIf);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitVarInsn(25, 4);
                AsmUtils.autoUnBoxing(methodVisitor, io.polaris.dependency.org.objectweb.asm.Type.getType(method.getParameterTypes()[0]));
                Class<?> declaringClass = method.getDeclaringClass();
                boolean isInterface = declaringClass.isInterface();
                int invokeOpcode = isInterface ? 185 : (Modifier.isStatic(method.getModifiers()) ? 184 : 182);
                methodVisitor.visitMethodInsn(invokeOpcode, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(declaringClass), method.getName(), io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(method), isInterface);
                methodVisitor.visitLabel(labelIf);
                methodVisitor.visitLabel(labelEnd);
                Label labelFinal = new Label();
                methodVisitor.visitJumpInsn(167, labelFinal);
                methodVisitor.visitLabel(labelCatch);
                methodVisitor.visitVarInsn(58, 4);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitLdcInsn(name);
                methodVisitor.visitVarInsn(25, 4);
                methodVisitor.visitMethodInsn(183, superClassNameInternal, resolveCopyError.serialized().getImplMethodName(), "(Ljava/lang/String;Ljava/lang/Throwable;)V", false);
                methodVisitor.visitLabel(labelFinal);
            }
        });
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = cw.visitMethod(4164, copyMapToBeanName, "(Ljava/util/Map;Ljava/lang/Object;Ljava/util/function/BiFunction;)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(182, accessClassNameInternal, copyMapToBeanName, "(Ljava/util/Map;L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";Ljava/util/function/BiFunction;)V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(4, 4);
        methodVisitor.visitEnd();
    }

    private static <T> void insertBeanToBeanBySameType(ClassWriter cw, String superClassNameInternal, String accessClassNameInternal, Class<T> type, BeanPropertyInfo.Classification classification) {
        SerializableTriConsumer<BeanCopier, Object, Object> copyBeanToBeanBySameType = BeanCopier::copyBeanToBeanBySameType;
        SerializableTriConsumer<BeanCopier, String, Throwable> resolveCopyError = BeanCopier::resolveCopyError;
        String copyBeanToSameName = copyBeanToBeanBySameType.serialized().getImplMethodName();
        MethodVisitor methodVisitor = cw.visitMethod(4, copyBeanToSameName, "(L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";)V", null, null);
        methodVisitor.visitCode();
        classification.properties.forEach((name, info) -> {
            if (info.getField() != null) {
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitFieldInsn(180, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(info.getField().getDeclaringClass()), (String)name, io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(info.getField().getType()));
                AsmUtils.storeVar(methodVisitor, info.getPropertyType(), 3);
                Label labelIf = null;
                if (!Types.isPrimitive(info.getPropertyType())) {
                    labelIf = new Label();
                    AsmUtils.loadVar(methodVisitor, info.getPropertyType(), 3);
                    methodVisitor.visitJumpInsn(198, labelIf);
                }
                methodVisitor.visitVarInsn(25, 2);
                AsmUtils.loadVar(methodVisitor, info.getPropertyType(), 3);
                methodVisitor.visitFieldInsn(181, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(info.getField().getDeclaringClass()), (String)name, io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(info.getField().getType()));
                if (labelIf != null) {
                    methodVisitor.visitLabel(labelIf);
                }
            } else if (info.getReadMethod() != null && info.getWriteMethod() != null) {
                boolean hasThrows = info.getReadMethod().getExceptionTypes().length > 0 || info.getWriteMethod().getExceptionTypes().length > 0;
                Label labelStart = new Label();
                Label labelEnd = new Label();
                Label labelCatch = new Label();
                if (hasThrows) {
                    methodVisitor.visitTryCatchBlock(labelStart, labelEnd, labelCatch, "java/lang/Throwable");
                    methodVisitor.visitLabel(labelStart);
                }
                methodVisitor.visitVarInsn(25, 1);
                Class<?> declaringClass = info.getReadMethod().getDeclaringClass();
                boolean isInterface = declaringClass.isInterface();
                int invokeOpcode = isInterface ? 185 : (Modifier.isStatic(info.getReadMethod().getModifiers()) ? 184 : 182);
                methodVisitor.visitMethodInsn(invokeOpcode, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(declaringClass), info.getReadMethod().getName(), io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(info.getReadMethod()), isInterface);
                AsmUtils.storeVar(methodVisitor, info.getPropertyType(), 3);
                Label labelIf = null;
                if (!Types.isPrimitive(info.getPropertyType())) {
                    labelIf = new Label();
                    AsmUtils.loadVar(methodVisitor, info.getPropertyType(), 3);
                    methodVisitor.visitJumpInsn(198, labelIf);
                }
                methodVisitor.visitVarInsn(25, 2);
                AsmUtils.loadVar(methodVisitor, info.getPropertyType(), 3);
                Class<?> declaringClass2 = info.getWriteMethod().getDeclaringClass();
                boolean isInterface2 = declaringClass2.isInterface();
                int invokeOpcode2 = isInterface2 ? 185 : (Modifier.isStatic(info.getWriteMethod().getModifiers()) ? 184 : 182);
                methodVisitor.visitMethodInsn(invokeOpcode2, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(declaringClass2), info.getWriteMethod().getName(), io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(info.getWriteMethod()), isInterface2);
                if (labelIf != null) {
                    methodVisitor.visitLabel(labelIf);
                }
                if (hasThrows) {
                    methodVisitor.visitLabel(labelEnd);
                    Label labelFinal = new Label();
                    methodVisitor.visitJumpInsn(167, labelFinal);
                    methodVisitor.visitLabel(labelCatch);
                    methodVisitor.visitVarInsn(58, 3);
                    methodVisitor.visitVarInsn(25, 0);
                    methodVisitor.visitLdcInsn(name);
                    methodVisitor.visitVarInsn(25, 3);
                    methodVisitor.visitMethodInsn(183, superClassNameInternal, resolveCopyError.serialized().getImplMethodName(), "(Ljava/lang/String;Ljava/lang/Throwable;)V", false);
                    methodVisitor.visitLabel(labelFinal);
                }
            }
        });
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = cw.visitMethod(4164, copyBeanToSameName, "(Ljava/lang/Object;Ljava/lang/Object;)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
        methodVisitor.visitMethodInsn(182, accessClassNameInternal, copyBeanToSameName, "(L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";L" + io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type) + ";)V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 3);
        methodVisitor.visitEnd();
    }

    private static <T> void insertBeanToMapByOptions(ClassWriter cw, String superClassNameInternal, String accessClassNameInternal, Class<T> type, BeanPropertyInfo.Classification classification) {
        String subMethodPrefix = "copyBeanToMapWithKeyByOptions$";
        ArrayList<String> subMethods = new ArrayList<String>();
        for (Map.Entry<String, BeanPropertyInfo> entry : classification.properties.entrySet()) {
            BeanPropertyInfo info = entry.getValue();
            if (!info.hasGetter()) continue;
            String subMethod = subMethodPrefix + info.getPropertyName();
            BeanCopier.insertBeanToMapWithKeyByOptions(cw, superClassNameInternal, accessClassNameInternal, type, info, subMethod);
            subMethods.add(subMethod);
        }
        SerializableConsumerWithArgs6<BeanCopier, Object, Map, CopyOptions, JavaType, JavaType> copyBeanToMapByOptions = BeanCopier::copyBeanToMapByOptions;
        MethodVisitor methodVisitor = cw.visitMethod(4, copyBeanToMapByOptions.serialized().getImplMethodName(), "(" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(type) + "Ljava/util/Map;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(JavaType.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(JavaType.class) + ")V", "<K:Ljava/lang/Object;V:Ljava/lang/Object;>(" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(type) + "Ljava/util/Map<TK;TV;>;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(JavaType.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(JavaType.class) + ")V", null);
        methodVisitor.visitCode();
        for (String subMethod : subMethods) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitVarInsn(25, 3);
            methodVisitor.visitVarInsn(25, 4);
            methodVisitor.visitVarInsn(25, 5);
            methodVisitor.visitMethodInsn(182, accessClassNameInternal, subMethod, "(" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(type) + "Ljava/util/Map;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(JavaType.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(JavaType.class) + ")V", false);
        }
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(6, 6);
        methodVisitor.visitEnd();
        methodVisitor = cw.visitMethod(4164, copyBeanToMapByOptions.serialized().getImplMethodName(), "(Ljava/lang/Object;Ljava/util/Map;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(JavaType.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(JavaType.class) + ")V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitVarInsn(25, 5);
        methodVisitor.visitMethodInsn(182, accessClassNameInternal, copyBeanToMapByOptions.serialized().getImplMethodName(), "(" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(type) + "Ljava/util/Map;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(JavaType.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(JavaType.class) + ")V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(6, 6);
        methodVisitor.visitEnd();
    }

    private static <T> void insertBeanToMapWithKeyByOptions(ClassWriter cw, String superClassNameInternal, String accessClassNameInternal, Class<T> type, BeanPropertyInfo info, String subMethod) {
        Class<?> var7Class;
        MethodVisitor methodVisitor = cw.visitMethod(2, subMethod, "(" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(type) + "Ljava/util/Map;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(JavaType.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(JavaType.class) + ")V", null, null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        Label label1 = new Label();
        Label label2 = new Label();
        methodVisitor.visitTryCatchBlock(label0, label1, label2, "java/lang/Throwable");
        Label label3 = new Label();
        Label label4 = new Label();
        methodVisitor.visitTryCatchBlock(label3, label4, label2, "java/lang/Throwable");
        methodVisitor.visitLabel(label0);
        methodVisitor.visitLdcInsn(info.getPropertyName());
        methodVisitor.visitVarInsn(58, 6);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitVarInsn(25, 6);
        SerializableBiFunction isIgnoredKey = CopyOptions::isIgnoredKey;
        methodVisitor.visitMethodInsn(182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(CopyOptions.class), isIgnoredKey.serialized().getImplMethodName(), "(Ljava/lang/String;)Z", false);
        methodVisitor.visitJumpInsn(153, label3);
        methodVisitor.visitLabel(label1);
        methodVisitor.visitInsn(177);
        methodVisitor.visitLabel(label3);
        methodVisitor.visitVarInsn(25, 1);
        if (info.getField() != null) {
            var7Class = info.getField().getType();
            methodVisitor.visitFieldInsn(180, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(info.getField().getDeclaringClass()), info.getField().getName(), io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(var7Class));
            AsmUtils.autoBoxing(methodVisitor, var7Class);
        } else {
            var7Class = info.getReadMethod().getReturnType();
            boolean isInterface = info.getReadMethod().getDeclaringClass().isInterface();
            methodVisitor.visitMethodInsn(isInterface ? 185 : 182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(info.getReadMethod().getDeclaringClass()), info.getReadMethod().getName(), io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(info.getReadMethod()), isInterface);
            AsmUtils.autoBoxing(methodVisitor, var7Class);
        }
        methodVisitor.visitVarInsn(58, 7);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitVarInsn(25, 5);
        methodVisitor.visitVarInsn(25, 6);
        methodVisitor.visitVarInsn(25, 7);
        SerializableConsumerWithArgs7<BeanCopier, Map, CopyOptions, JavaType, JavaType, String, Object> copyBeanToMapWithKey = BeanCopier::copyBeanToMapWithKeyByOptions;
        methodVisitor.visitMethodInsn(182, accessClassNameInternal, copyBeanToMapWithKey.serialized().getImplMethodName(), "(Ljava/util/Map;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(JavaType.class) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(JavaType.class) + "Ljava/lang/String;Ljava/lang/Object;)V", false);
        methodVisitor.visitLabel(label4);
        Label label5 = new Label();
        methodVisitor.visitJumpInsn(167, label5);
        methodVisitor.visitLabel(label2);
        methodVisitor.visitVarInsn(58, 6);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn(info.getPropertyName());
        methodVisitor.visitVarInsn(25, 6);
        methodVisitor.visitVarInsn(25, 3);
        SerializableTriConsumer<BeanCopier, String, Throwable> resolveCopyError = BeanCopier::resolveCopyError;
        methodVisitor.visitMethodInsn(183, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(BeanCopier.class), resolveCopyError.serialized().getImplMethodName(), "(Ljava/lang/String;Ljava/lang/Throwable;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + ")V", false);
        methodVisitor.visitLabel(label5);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(7, 8);
        methodVisitor.visitEnd();
    }

    private static <T> void insertMapToBeanWithCustomKeys(ClassWriter cw, String accessClassNameInternal, Class<T> type, BeanPropertyInfo.Classification classification) {
        SerializableConsumerWithArgs6<BeanCopier, Map, Object, CopyOptions, Set, Map> copyMapToBeanWithCustomKeys = BeanCopier::copyMapToBeanWithCustomKeys;
        MethodVisitor methodVisitor = cw.visitMethod(4, copyMapToBeanWithCustomKeys.serialized().getImplMethodName(), "(Ljava/util/Map;Ljava/lang/Object;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + "Ljava/util/Set;Ljava/util/Map;)V", "(Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;Ljava/lang/Object;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + "Ljava/util/Set<Ljava/lang/String;>;Ljava/util/Map<Ljava/lang/String;Ljava/lang/String;>;)V", null);
        methodVisitor.visitCode();
        classification.properties.forEach((key, info) -> {
            if (info.hasSetter()) {
                methodVisitor.visitVarInsn(25, 4);
                methodVisitor.visitMethodInsn(185, "java/util/Set", "isEmpty", "()Z", true);
                Label label0 = new Label();
                methodVisitor.visitJumpInsn(154, label0);
                Label label1 = new Label();
                methodVisitor.visitJumpInsn(167, label1);
                methodVisitor.visitLabel(label0);
                methodVisitor.visitInsn(177);
                methodVisitor.visitLabel(label1);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitVarInsn(25, 4);
                methodVisitor.visitVarInsn(25, 5);
                methodVisitor.visitLdcInsn(info.getPropertyName());
                methodVisitor.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                methodVisitor.visitTypeInsn(192, "java/lang/String");
                String methodName = "copyMapToBeanWithSourceKeys$" + info.getPropertyName();
                methodVisitor.visitMethodInsn(183, accessClassNameInternal, methodName, "(Ljava/util/Map;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(type) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + "Ljava/util/Set;Ljava/lang/String;)V", false);
            }
        });
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(7, 7);
        methodVisitor.visitEnd();
    }

    private static <T> void insertMapToBeanWithSourceKeys(ClassWriter cw, String accessClassNameInternal, Class<T> type, BeanPropertyInfo.Classification classification, SerializableConsumerWithArgs5<BeanCopier, Map<String, Object>, Object, CopyOptions, Set<String>> copyMethod, Function<String, String> keyMapper) {
        MethodVisitor methodVisitor = cw.visitMethod(1, copyMethod.serialized().getImplMethodName(), "(Ljava/util/Map;Ljava/lang/Object;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + "Ljava/util/Set;)V", "(Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;Ljava/lang/Object;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + "Ljava/util/Set<Ljava/lang/String;>;)V", null);
        methodVisitor.visitCode();
        classification.properties.forEach((key, info) -> {
            if (info.hasSetter()) {
                String sourceKey = (String)keyMapper.apply(info.getPropertyName());
                if (sourceKey == null) {
                    return;
                }
                Label label0 = new Label();
                methodVisitor.visitVarInsn(25, 4);
                methodVisitor.visitMethodInsn(185, "java/util/Set", "isEmpty", "()Z", true);
                Label label1 = new Label();
                methodVisitor.visitJumpInsn(153, label1);
                methodVisitor.visitLabel(label0);
                methodVisitor.visitInsn(177);
                methodVisitor.visitLabel(label1);
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitTypeInsn(192, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(type));
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitVarInsn(25, 4);
                methodVisitor.visitLdcInsn(sourceKey);
                String methodName = "copyMapToBeanWithSourceKeys$" + info.getPropertyName();
                methodVisitor.visitMethodInsn(183, accessClassNameInternal, methodName, "(Ljava/util/Map;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(type) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + "Ljava/util/Set;Ljava/lang/String;)V", false);
            }
        });
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 6);
        methodVisitor.visitEnd();
    }

    private static <T> void insertMapToBeanWithSourceKeyAll(ClassWriter cw, String superClassNameInternal, String accessClassNameInternal, Class<T> type, BeanPropertyInfo.Classification classification) {
        classification.properties.forEach((key, info) -> {
            if (info.hasSetter()) {
                BeanCopier.insertMapToBeanWithSourceKey(cw, superClassNameInternal, accessClassNameInternal, type, info);
            }
        });
    }

    private static <T> void insertMapToBeanWithSourceKey(ClassWriter cw, String superClassNameInternal, String accessClassNameInternal, Class<T> type, BeanPropertyInfo info) {
        String methodName = "copyMapToBeanWithSourceKeys$" + info.getPropertyName();
        String targetKey = info.getPropertyName();
        MethodVisitor methodVisitor = cw.visitMethod(2, methodName, "(Ljava/util/Map;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(type) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + "Ljava/util/Set;Ljava/lang/String;)V", "(Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(type) + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + "Ljava/util/Set<Ljava/lang/String;>;Ljava/lang/String;)V", null);
        methodVisitor.visitCode();
        Label label0 = new Label();
        Label label1 = new Label();
        Label label2 = new Label();
        methodVisitor.visitTryCatchBlock(label0, label1, label2, "java/lang/Throwable");
        Label label3 = new Label();
        Label label4 = new Label();
        methodVisitor.visitTryCatchBlock(label3, label4, label2, "java/lang/Throwable");
        Label label5 = new Label();
        Label label6 = new Label();
        methodVisitor.visitTryCatchBlock(label5, label6, label2, "java/lang/Throwable");
        Label label7 = new Label();
        Label label8 = new Label();
        methodVisitor.visitTryCatchBlock(label7, label8, label2, "java/lang/Throwable");
        Label label9 = new Label();
        Label label10 = new Label();
        methodVisitor.visitTryCatchBlock(label9, label10, label2, "java/lang/Throwable");
        Label label11 = new Label();
        Label label12 = new Label();
        methodVisitor.visitTryCatchBlock(label11, label12, label2, "java/lang/Throwable");
        methodVisitor.visitLdcInsn(targetKey);
        methodVisitor.visitVarInsn(58, 6);
        methodVisitor.visitLabel(label0);
        methodVisitor.visitVarInsn(25, 5);
        methodVisitor.visitJumpInsn(198, label1);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitVarInsn(25, 5);
        SerializableBiFunction isIgnoredKey = CopyOptions::isIgnoredKey;
        methodVisitor.visitMethodInsn(182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(CopyOptions.class), isIgnoredKey.serialized().getImplMethodName(), "(Ljava/lang/String;)Z", false);
        methodVisitor.visitJumpInsn(153, label3);
        methodVisitor.visitLabel(label1);
        methodVisitor.visitInsn(177);
        methodVisitor.visitLabel(label3);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitVarInsn(25, 6);
        methodVisitor.visitMethodInsn(185, "java/util/Set", "contains", "(Ljava/lang/Object;)Z", true);
        methodVisitor.visitJumpInsn(154, label5);
        methodVisitor.visitLabel(label4);
        methodVisitor.visitInsn(177);
        methodVisitor.visitLabel(label5);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(CopyOptions.class), "override", "()Z", false);
        methodVisitor.visitJumpInsn(154, label7);
        if (info.getField() != null) {
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitFieldInsn(180, io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(info.getField().getDeclaringClass()), info.getField().getName(), io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(info.getField().getType()));
            AsmUtils.autoBoxing(methodVisitor, info.getField().getType());
            methodVisitor.visitVarInsn(58, 7);
            methodVisitor.visitVarInsn(25, 7);
            methodVisitor.visitJumpInsn(198, label7);
        } else if (info.getReadMethod() != null) {
            methodVisitor.visitVarInsn(25, 2);
            boolean isInterface = info.getReadMethod().getDeclaringClass().isInterface();
            methodVisitor.visitMethodInsn(isInterface ? 185 : 182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(info.getReadMethod().getDeclaringClass()), info.getReadMethod().getName(), io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(info.getReadMethod()), isInterface);
            AsmUtils.autoBoxing(methodVisitor, info.getReadMethod().getReturnType());
            methodVisitor.visitVarInsn(58, 7);
            methodVisitor.visitVarInsn(25, 7);
            methodVisitor.visitJumpInsn(198, label7);
        } else {
            methodVisitor.visitJumpInsn(167, label7);
        }
        methodVisitor.visitLabel(label6);
        methodVisitor.visitInsn(177);
        methodVisitor.visitLabel(label7);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 5);
        methodVisitor.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
        methodVisitor.visitVarInsn(58, 7);
        methodVisitor.visitVarInsn(25, 7);
        methodVisitor.visitJumpInsn(199, label9);
        methodVisitor.visitVarInsn(25, 3);
        SerializableFunction ignoreNull = CopyOptions::ignoreNull;
        methodVisitor.visitMethodInsn(182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(CopyOptions.class), ignoreNull.serialized().getImplMethodName(), "()Z", false);
        methodVisitor.visitJumpInsn(153, label9);
        methodVisitor.visitLabel(label8);
        methodVisitor.visitInsn(177);
        methodVisitor.visitLabel(label9);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitVarInsn(25, 5);
        methodVisitor.visitVarInsn(25, 7);
        SerializableTriFunction<CopyOptions, String, Object, Object> editValue = CopyOptions::editValue;
        methodVisitor.visitMethodInsn(182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(CopyOptions.class), editValue.serialized().getImplMethodName(), "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", false);
        methodVisitor.visitVarInsn(58, 7);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, accessClassNameInternal, FIELD_PREFIX_TYPE + info.getPropertyName(), "Ljava/lang/reflect/Type;");
        methodVisitor.visitVarInsn(25, 7);
        SerializableTriFunction<CopyOptions, Type, Object, Object> convert = CopyOptions::convert;
        methodVisitor.visitMethodInsn(182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(CopyOptions.class), convert.serialized().getImplMethodName(), "(Ljava/lang/reflect/Type;Ljava/lang/Object;)Ljava/lang/Object;", false);
        methodVisitor.visitVarInsn(58, 7);
        methodVisitor.visitVarInsn(25, 7);
        methodVisitor.visitJumpInsn(199, label11);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitMethodInsn(182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(CopyOptions.class), ignoreNull.serialized().getImplMethodName(), "()Z", false);
        methodVisitor.visitJumpInsn(154, label10);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, accessClassNameInternal, FIELD_PREFIX_CLASS + info.getPropertyName(), "Ljava/lang/Class;");
        methodVisitor.visitMethodInsn(182, "java/lang/Class", "isPrimitive", "()Z", false);
        methodVisitor.visitJumpInsn(153, label11);
        methodVisitor.visitLabel(label10);
        methodVisitor.visitInsn(177);
        methodVisitor.visitLabel(label11);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, accessClassNameInternal, FIELD_PREFIX_CLASS + info.getPropertyName(), "Ljava/lang/Class;");
        SerializableFunction getWrapperClass = Types::getWrapperClass;
        methodVisitor.visitMethodInsn(184, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(Types.class), getWrapperClass.serialized().getImplMethodName(), "(Ljava/lang/Class;)Ljava/lang/Class;", false);
        methodVisitor.visitVarInsn(25, 7);
        methodVisitor.visitMethodInsn(182, "java/lang/Class", "isInstance", "(Ljava/lang/Object;)Z", false);
        methodVisitor.visitJumpInsn(153, label12);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(25, 7);
        AsmUtils.autoUnBoxing(methodVisitor, info.getPropertyType());
        if (info.getField() != null) {
            methodVisitor.visitFieldInsn(181, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(info.getField().getDeclaringClass()), info.getField().getName(), io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(info.getField().getType()));
        } else {
            boolean isInterface = info.getWriteMethod().getDeclaringClass().isInterface();
            methodVisitor.visitMethodInsn(isInterface ? 185 : 182, io.polaris.dependency.org.objectweb.asm.Type.getInternalName(info.getWriteMethod().getDeclaringClass()), info.getWriteMethod().getName(), io.polaris.dependency.org.objectweb.asm.Type.getMethodDescriptor(info.getWriteMethod()), isInterface);
        }
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitVarInsn(25, 6);
        methodVisitor.visitMethodInsn(185, "java/util/Set", "remove", "(Ljava/lang/Object;)Z", true);
        methodVisitor.visitInsn(87);
        methodVisitor.visitLabel(label12);
        Label label13 = new Label();
        methodVisitor.visitJumpInsn(167, label13);
        methodVisitor.visitLabel(label2);
        methodVisitor.visitVarInsn(58, 7);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitTypeInsn(187, "java/lang/StringBuilder");
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        methodVisitor.visitVarInsn(25, 5);
        methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        methodVisitor.visitLdcInsn("->" + targetKey);
        methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        methodVisitor.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        methodVisitor.visitVarInsn(25, 7);
        methodVisitor.visitVarInsn(25, 3);
        SerializableConsumerWithArgs4<BeanCopier, String, Throwable, CopyOptions> resolveCopyError = BeanCopier::resolveCopyError;
        methodVisitor.visitMethodInsn(183, superClassNameInternal, resolveCopyError.serialized().getImplMethodName(), "(Ljava/lang/String;Ljava/lang/Throwable;" + io.polaris.dependency.org.objectweb.asm.Type.getDescriptor(CopyOptions.class) + ")V", false);
        methodVisitor.visitLabel(label13);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(3, 8);
        methodVisitor.visitEnd();
    }
}

