/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.reflect;

import io.polaris.core.reflect.Reflects;
import io.polaris.core.string.Strings;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BeanPropertyInfo {
    private final String propertyName;
    private final Type propertyGenericType;
    private final Class<?> propertyType;
    private final Method writeMethod;
    private final Method readMethod;
    private final Field field;

    private BeanPropertyInfo(String propertyName, Type propertyGenericType, Class<?> propertyType, Method writeMethod, Method readMethod, Field field) {
        this.propertyName = propertyName;
        this.propertyGenericType = propertyGenericType;
        this.propertyType = propertyType;
        this.writeMethod = writeMethod;
        this.readMethod = readMethod;
        this.field = field;
    }

    public boolean hasSetter() {
        return this.writeMethod != null || this.field != null;
    }

    public boolean hasGetter() {
        return this.readMethod != null || this.field != null;
    }

    public static BeanPropertyInfo of(PropertyDescriptor propertyDescriptor) {
        return BeanPropertyInfo.of(propertyDescriptor.getName(), propertyDescriptor.getWriteMethod(), propertyDescriptor.getReadMethod(), null);
    }

    private static BeanPropertyInfo of(String propertyName, Type propertyGenericType, Class<?> propertyType, Method writeMethod, Method readMethod, Field field) {
        return new BeanPropertyInfo(propertyName, propertyGenericType, propertyType, writeMethod, readMethod, field);
    }

    private static BeanPropertyInfo of(String propertyName, Method writeMethod, Method readMethod, Field field) {
        if ((propertyName = Strings.trimToNull(propertyName)) == null) {
            throw new IllegalArgumentException("propertyName is required");
        }
        if (readMethod == null && writeMethod == null && field == null) {
            throw new IllegalArgumentException("readMethodName or writeMethodName or field is required");
        }
        if (field != null) {
            if (!field.getName().equals(propertyName)) {
                throw new IllegalArgumentException("field name must be same as propertyName");
            }
            if (writeMethod != null || readMethod != null) {
                throw new IllegalArgumentException("field must be null when writeMethod or readMethod exists");
            }
        }
        Class<Object> propertyGenericType = null;
        Class<Object> propertyType = null;
        if (writeMethod != null) {
            propertyGenericType = writeMethod.getGenericParameterTypes()[0];
            propertyType = writeMethod.getParameterTypes()[0];
        } else if (field != null) {
            propertyGenericType = field.getGenericType();
            propertyType = field.getType();
        } else {
            propertyGenericType = readMethod.getGenericReturnType();
            propertyType = readMethod.getReturnType();
        }
        if (propertyType == null) {
            propertyType = Object.class;
        }
        if (propertyGenericType == null) {
            propertyGenericType = propertyType;
        }
        return BeanPropertyInfo.of(propertyName, propertyGenericType, propertyType, writeMethod, readMethod, field);
    }

    public static List<BeanPropertyInfo> listOf(Class<?> beanType) {
        Map<String, BeanPropertyInfo> map = BeanPropertyInfo.mapOf(beanType);
        ArrayList<BeanPropertyInfo> list = new ArrayList<BeanPropertyInfo>(map.size());
        list.addAll(map.values());
        return list;
    }

    public static Map<String, BeanPropertyInfo> mapOf(Class<?> beanType) {
        PropertyDescriptor[] pds;
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanType);
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        LinkedHashMap<String, BeanPropertyInfo> rs = new LinkedHashMap<String, BeanPropertyInfo>();
        for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
            Method writeMethod = pd.getWriteMethod();
            Method readMethod = pd.getReadMethod();
            if (Reflects.isGetClassMethod(pd.getReadMethod()) || writeMethod == null && readMethod == null) continue;
            BeanPropertyInfo info = BeanPropertyInfo.of(pd.getName(), writeMethod, readMethod, null);
            rs.put(info.getPropertyName(), info);
        }
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        for (Class<?> nextClass = beanType; nextClass != null && nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            for (Field field : nextClass.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers)) continue;
                fields.putIfAbsent(field.getName(), field);
            }
        }
        for (Map.Entry entry : fields.entrySet()) {
            String name = (String)entry.getKey();
            if (rs.containsKey(name)) continue;
            BeanPropertyInfo info = BeanPropertyInfo.of(name, null, null, (Field)entry.getValue());
            rs.put(info.getPropertyName(), info);
        }
        return rs;
    }

    public static Classification classify(Class<?> beanType) {
        Map<String, BeanPropertyInfo> properties = BeanPropertyInfo.mapOf(beanType);
        ArrayList<BeanPropertyInfo> setters = new ArrayList<BeanPropertyInfo>();
        ArrayList<BeanPropertyInfo> getters = new ArrayList<BeanPropertyInfo>();
        ArrayList<BeanPropertyInfo> fields = new ArrayList<BeanPropertyInfo>();
        for (Map.Entry<String, BeanPropertyInfo> entry : properties.entrySet()) {
            BeanPropertyInfo beanPropertyInfo = entry.getValue();
            if (beanPropertyInfo.getWriteMethod() != null) {
                setters.add(beanPropertyInfo);
            }
            if (beanPropertyInfo.getReadMethod() != null) {
                getters.add(beanPropertyInfo);
            }
            if (beanPropertyInfo.getField() == null) continue;
            fields.add(beanPropertyInfo);
        }
        Classification rs = new Classification();
        rs.properties = properties;
        rs.setters = setters;
        rs.getters = getters;
        rs.fields = fields;
        return rs;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Type getPropertyGenericType() {
        return this.propertyGenericType;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Field getField() {
        return this.field;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BeanPropertyInfo)) {
            return false;
        }
        BeanPropertyInfo other = (BeanPropertyInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$propertyName = this.propertyName;
        String other$propertyName = other.propertyName;
        if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
            return false;
        }
        Type this$propertyGenericType = this.propertyGenericType;
        Type other$propertyGenericType = other.propertyGenericType;
        if (this$propertyGenericType == null ? other$propertyGenericType != null : !this$propertyGenericType.equals(other$propertyGenericType)) {
            return false;
        }
        Class<?> this$propertyType = this.propertyType;
        Class<?> other$propertyType = other.propertyType;
        if (this$propertyType == null ? other$propertyType != null : !this$propertyType.equals(other$propertyType)) {
            return false;
        }
        Method this$writeMethod = this.writeMethod;
        Method other$writeMethod = other.writeMethod;
        if (this$writeMethod == null ? other$writeMethod != null : !((Object)this$writeMethod).equals(other$writeMethod)) {
            return false;
        }
        Method this$readMethod = this.readMethod;
        Method other$readMethod = other.readMethod;
        if (this$readMethod == null ? other$readMethod != null : !((Object)this$readMethod).equals(other$readMethod)) {
            return false;
        }
        Field this$field = this.field;
        Field other$field = other.field;
        return !(this$field == null ? other$field != null : !((Object)this$field).equals(other$field));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BeanPropertyInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $propertyName = this.propertyName;
        result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
        Type $propertyGenericType = this.propertyGenericType;
        result = result * 59 + ($propertyGenericType == null ? 43 : $propertyGenericType.hashCode());
        Class<?> $propertyType = this.propertyType;
        result = result * 59 + ($propertyType == null ? 43 : $propertyType.hashCode());
        Method $writeMethod = this.writeMethod;
        result = result * 59 + ($writeMethod == null ? 43 : ((Object)$writeMethod).hashCode());
        Method $readMethod = this.readMethod;
        result = result * 59 + ($readMethod == null ? 43 : ((Object)$readMethod).hashCode());
        Field $field = this.field;
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        return result;
    }

    public String toString() {
        return "BeanPropertyInfo(propertyName=" + this.propertyName + ", propertyGenericType=" + this.propertyGenericType + ", propertyType=" + this.propertyType + ", writeMethod=" + this.writeMethod + ", readMethod=" + this.readMethod + ", field=" + this.field + ")";
    }

    public static class Classification {
        public Map<String, BeanPropertyInfo> properties;
        public List<BeanPropertyInfo> setters;
        public List<BeanPropertyInfo> getters;
        public List<BeanPropertyInfo> fields;
    }
}

