/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.reflect;

import io.polaris.core.asm.internal.AsmUtils;
import io.polaris.core.asm.reflect.AccessClassLoader;
import io.polaris.core.asm.reflect.AccessClassPool;
import io.polaris.core.lang.Types;
import io.polaris.core.log.ILogger;
import io.polaris.core.log.ILoggers;
import io.polaris.core.reflect.Reflects;
import io.polaris.core.reflect.SerializableFunction;
import io.polaris.core.tuple.Tuple2;
import io.polaris.dependency.org.objectweb.asm.ClassWriter;
import io.polaris.dependency.org.objectweb.asm.Handle;
import io.polaris.dependency.org.objectweb.asm.Label;
import io.polaris.dependency.org.objectweb.asm.MethodVisitor;
import io.polaris.dependency.org.objectweb.asm.Type;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class ClassLambdaAccess<T> {
    private static final AccessClassPool<Class, ClassLambdaAccess> pool = new AccessClassPool();
    private static ILogger log = ILoggers.of(ClassLambdaAccess.class);
    private int constructorIndex = -1;
    private Class[][] constructorParamTypes = this.buildConstructorParamTypes();
    private Function<Object[], Object>[] constructors = this.buildConstructors();
    private Map<String, Tuple2<Class[], BiFunction<Object, Object[], Object>>[]> methods = this.buildMethods();
    private Map<String, Tuple2<Function<Object, Object>, BiConsumer<Object, Object>>> fields = this.buildFields();

    protected ClassLambdaAccess() {
        for (int i = 0; i < this.constructorParamTypes.length; ++i) {
            if (this.constructorParamTypes[i].length != 0) continue;
            this.constructorIndex = i;
            break;
        }
    }

    protected Map<String, Tuple2<Function<Object, Object>, BiConsumer<Object, Object>>> buildFields() {
        return Collections.emptyMap();
    }

    protected Map<String, Tuple2<Class[], BiFunction<Object, Object[], Object>>[]> buildMethods() {
        return Collections.emptyMap();
    }

    protected Class[][] buildConstructorParamTypes() {
        return new Class[0][0];
    }

    protected Function<Object[], Object>[] buildConstructors() {
        return new Function[0];
    }

    public boolean containsDefaultConstructor() {
        return this.constructorIndex >= 0;
    }

    public boolean containsConstructor(Class ... types) {
        Class[] constructorParamType;
        int i;
        if (types == null || types.length == 0) {
            return this.containsDefaultConstructor();
        }
        for (i = 0; i < this.constructorParamTypes.length; ++i) {
            constructorParamType = this.constructorParamTypes[i];
            if (!Types.isEquals(constructorParamType, types)) continue;
            return true;
        }
        for (i = 0; i < this.constructorParamTypes.length; ++i) {
            constructorParamType = this.constructorParamTypes[i];
            if (!Types.isAssignable(constructorParamType, types)) continue;
            return true;
        }
        return false;
    }

    public T newInstance() {
        if (this.constructorIndex >= 0) {
            try {
                return (T)this.constructors[this.constructorIndex].apply(new Object[0]);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException("Constructor not found");
    }

    public T newInstance(Class<?>[] types, Object ... args) {
        Class[] constructorParamType;
        int i;
        if (types == null || types.length == 0) {
            return this.newInstance();
        }
        for (i = 0; i < this.constructorParamTypes.length; ++i) {
            constructorParamType = this.constructorParamTypes[i];
            if (!Types.isEquals(constructorParamType, types)) continue;
            try {
                return (T)this.constructors[i].apply(args);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
        for (i = 0; i < this.constructorParamTypes.length; ++i) {
            constructorParamType = this.constructorParamTypes[i];
            if (!Types.isAssignable(constructorParamType, types)) continue;
            try {
                return (T)this.constructors[i].apply(args);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException("Constructor not found");
    }

    public T newInstance(Object ... args) {
        if (args.length == 0) {
            return this.newInstance();
        }
        for (int i = 0; i < this.constructorParamTypes.length; ++i) {
            Class[] constructorParamType = this.constructorParamTypes[i];
            if (args.length != constructorParamType.length) continue;
            boolean matched = true;
            for (int j = 0; j < args.length; ++j) {
                if (args[j] == null) continue;
                if (constructorParamType[j].isPrimitive()) {
                    if (constructorParamType[j].isInstance(args[j]) || Types.getWrapperClass(constructorParamType[j]).isInstance(args[j])) continue;
                    matched = false;
                    break;
                }
                if (constructorParamType[j].isInstance(args[j])) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            try {
                return (T)this.constructors[i].apply(args);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException("Constructor not found");
    }

    public T newInstanceOrNoop() {
        if (this.constructorIndex >= 0) {
            try {
                return (T)this.constructors[this.constructorIndex].apply(new Object[0]);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    public T newInstanceOrNoop(Class<?>[] types, Object ... args) {
        Class[] constructorParamType;
        int i;
        if (types == null || types.length == 0) {
            return this.newInstance();
        }
        for (i = 0; i < this.constructorParamTypes.length; ++i) {
            constructorParamType = this.constructorParamTypes[i];
            if (!Types.isEquals(constructorParamType, types)) continue;
            try {
                return (T)this.constructors[i].apply(args);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
        for (i = 0; i < this.constructorParamTypes.length; ++i) {
            constructorParamType = this.constructorParamTypes[i];
            if (!Types.isAssignable(constructorParamType, types)) continue;
            try {
                return (T)this.constructors[i].apply(args);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    public T newInstanceOrNoop(Object ... args) {
        if (args.length == 0) {
            return this.newInstance();
        }
        for (int i = 0; i < this.constructorParamTypes.length; ++i) {
            Class[] constructorParamType = this.constructorParamTypes[i];
            if (args.length != constructorParamType.length) continue;
            boolean matched = true;
            for (int j = 0; j < args.length; ++j) {
                if (args[j] == null) continue;
                if (constructorParamType[j].isPrimitive()) {
                    if (constructorParamType[j].isInstance(args[j]) || Types.getWrapperClass(constructorParamType[j]).isInstance(args[j])) continue;
                    matched = false;
                    break;
                }
                if (constructorParamType[j].isInstance(args[j])) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            try {
                return (T)this.constructors[i].apply(args);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    public Set<String> getMethodNames() {
        return new LinkedHashSet<String>(this.methods.keySet());
    }

    public boolean containsMethod(String methodName) {
        return this.methods.containsKey(methodName);
    }

    public boolean containsMethod(String methodName, Class ... paramTypes) {
        Class[] definedTypes;
        Tuple2<Class[], BiFunction<Object, Object[], Object>>[] tuples = this.methods.get(methodName);
        if (tuples == null) {
            return false;
        }
        for (Tuple2<Class[], BiFunction<Object, Object[], Object>> tuple : tuples) {
            definedTypes = tuple.getFirst();
            if (!Types.isEquals(definedTypes, paramTypes)) continue;
            return true;
        }
        for (Tuple2<Class[], BiFunction<Object, Object[], Object>> tuple : tuples) {
            definedTypes = tuple.getFirst();
            if (!Types.isAssignable(definedTypes, paramTypes)) continue;
            return true;
        }
        return true;
    }

    public Object invokeMethod(Object object, String methodName, Class[] paramTypes, Object ... args) {
        Class[] definedTypes;
        Tuple2<Class[], BiFunction<Object, Object[], Object>>[] tuples = this.methods.get(methodName);
        if (tuples == null) {
            throw new IllegalArgumentException("Method not found\uff1a" + methodName + " " + Arrays.toString(paramTypes));
        }
        for (Tuple2<Class[], BiFunction<Object, Object[], Object>> tuple : tuples) {
            definedTypes = tuple.getFirst();
            if (!Types.isEquals(definedTypes, paramTypes)) continue;
            try {
                return tuple.getSecond().apply(object, args);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
        for (Tuple2<Class[], BiFunction<Object, Object[], Object>> tuple : tuples) {
            definedTypes = tuple.getFirst();
            if (!Types.isAssignable(definedTypes, paramTypes)) continue;
            try {
                return tuple.getSecond().apply(object, args);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException("Method not found\uff1a" + methodName + " " + Arrays.toString(paramTypes));
    }

    public Object invokeMethod(Object object, String methodName, Object ... args) {
        Tuple2<Class[], BiFunction<Object, Object[], Object>>[] tuples = this.methods.get(methodName);
        if (tuples == null) {
            throw new IllegalArgumentException("Method not found\uff1a" + methodName);
        }
        for (Tuple2<Class[], BiFunction<Object, Object[], Object>> tuple : tuples) {
            Class[] definedTypes = tuple.getFirst();
            if (args.length != definedTypes.length) continue;
            boolean matched = true;
            for (int j = 0; j < args.length; ++j) {
                if (args[j] == null) continue;
                if (definedTypes[j].isPrimitive()) {
                    if (definedTypes[j].isInstance(args[j]) || Types.getWrapperClass(definedTypes[j]).isInstance(args[j])) continue;
                    matched = false;
                    break;
                }
                if (definedTypes[j].isInstance(args[j])) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            try {
                return tuple.getSecond().apply(object, args);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException("Method not found\uff1a" + methodName);
    }

    public Object invokeMethodOrNoop(Object object, String methodName, Class[] paramTypes, Object ... args) {
        Class[] definedTypes;
        Tuple2<Class[], BiFunction<Object, Object[], Object>>[] tuples = this.methods.get(methodName);
        if (tuples == null) {
            return null;
        }
        for (Tuple2<Class[], BiFunction<Object, Object[], Object>> tuple : tuples) {
            definedTypes = tuple.getFirst();
            if (!Types.isEquals(definedTypes, paramTypes)) continue;
            try {
                return tuple.getSecond().apply(object, args);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
        for (Tuple2<Class[], BiFunction<Object, Object[], Object>> tuple : tuples) {
            definedTypes = tuple.getFirst();
            if (!Types.isAssignable(definedTypes, paramTypes)) continue;
            try {
                return tuple.getSecond().apply(object, args);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    public Object invokeMethodOrNoop(Object object, String methodName, Object ... args) {
        Tuple2<Class[], BiFunction<Object, Object[], Object>>[] tuples = this.methods.get(methodName);
        if (tuples == null) {
            return null;
        }
        for (Tuple2<Class[], BiFunction<Object, Object[], Object>> tuple : tuples) {
            Class[] definedTypes = tuple.getFirst();
            if (args.length != definedTypes.length) continue;
            boolean matched = true;
            for (int j = 0; j < args.length; ++j) {
                if (args[j] == null) continue;
                if (definedTypes[j].isPrimitive()) {
                    if (definedTypes[j].isInstance(args[j]) || Types.getWrapperClass(definedTypes[j]).isInstance(args[j])) continue;
                    matched = false;
                    break;
                }
                if (definedTypes[j].isInstance(args[j])) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            try {
                return tuple.getSecond().apply(object, args);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    public Set<String> getFieldNames() {
        return new LinkedHashSet<String>(this.fields.keySet());
    }

    public boolean containsField(String fieldName) {
        return this.fields.containsKey(fieldName);
    }

    public void setField(Object object, String fieldName, Object value) {
        Tuple2<Function<Object, Object>, BiConsumer<Object, Object>> tuple = this.fields.get(fieldName);
        if (tuple == null) {
            throw new IllegalArgumentException("Field not found\uff1a" + fieldName);
        }
        tuple.getSecond().accept(object, value);
    }

    public Object getField(Object object, String fieldName) {
        Tuple2<Function<Object, Object>, BiConsumer<Object, Object>> tuple = this.fields.get(fieldName);
        if (tuple == null) {
            throw new IllegalArgumentException("Field not found\uff1a" + fieldName);
        }
        return tuple.getFirst().apply(object);
    }

    public void setFieldOrNoop(Object object, String fieldName, Object value) {
        Tuple2<Function<Object, Object>, BiConsumer<Object, Object>> tuple = this.fields.get(fieldName);
        if (tuple == null) {
            return;
        }
        tuple.getSecond().accept(object, value);
    }

    public Object getFieldOrNoop(Object object, String fieldName) {
        Tuple2<Function<Object, Object>, BiConsumer<Object, Object>> tuple = this.fields.get(fieldName);
        if (tuple == null) {
            return null;
        }
        return tuple.getFirst().apply(object);
    }

    public static <T> ClassLambdaAccess<T> get(Class<T> type) {
        return pool.computeIfAbsent(type, ClassLambdaAccess::create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ClassLambdaAccess<T> create(Class<T> type) {
        ClassLambdaAccess access;
        Class accessClass;
        AccessClassLoader loader;
        String accessClassName = AccessClassLoader.buildAccessClassName(type, ClassLambdaAccess.class);
        AccessClassLoader accessClassLoader = loader = AccessClassLoader.get(type);
        synchronized (accessClassLoader) {
            accessClass = loader.loadAccessClass(accessClassName);
            if (accessClass == null) {
                accessClass = ClassLambdaAccess.buildAccessClass(loader, accessClassName, type);
            }
        }
        try {
            access = (ClassLambdaAccess)accessClass.newInstance();
        }
        catch (Throwable t) {
            throw new IllegalStateException("\u521b\u5efa\u8bbf\u95ee\u7c7b\u5931\u8d25: " + accessClassName, t);
        }
        return access;
    }

    private static <T> Class buildAccessClass(AccessClassLoader loader, String accessClassName, Class<T> type) {
        String accessClassNameInternal = accessClassName.replace('.', '/');
        String classNameInternal = type.getName().replace('.', '/');
        ClassWriter cw = new ClassWriter(2);
        String superClassNameInternal = ClassLambdaAccess.class.getName().replace('.', '/');
        cw.visit(52, 33, accessClassNameInternal, null, superClassNameInternal, null);
        cw.visitInnerClass("java/lang/invoke/MethodHandles$Lookup", "java/lang/invoke/MethodHandles", "Lookup", 25);
        AsmUtils.insertDefaultConstructor(cw, superClassNameInternal);
        ClassLambdaAccess.insertConstructorInvokers(cw, accessClassNameInternal, type);
        ClassLambdaAccess.insertMethodInvokers(cw, accessClassNameInternal, type);
        ClassLambdaAccess.insertFieldInvokers(cw, accessClassNameInternal, type);
        cw.visitEnd();
        byte[] byteArray = cw.toByteArray();
        return loader.defineAccessClass(accessClassName, byteArray);
    }

    private static <T> void insertConstructorInvokers(ClassWriter cw, String accessClassNameInternal, Class<T> type) {
        ArrayList constructorList = new ArrayList();
        for (Constructor<?> declaredConstructor : type.getDeclaredConstructors()) {
            if (Modifier.isPrivate(declaredConstructor.getModifiers())) continue;
            constructorList.add(declaredConstructor);
        }
        int size = constructorList.size();
        SerializableFunction buildConstructors = ClassLambdaAccess::buildConstructors;
        String lambdaPrefixOfConstructors = "lambda$" + buildConstructors.serialized().getImplMethodName() + "$";
        SerializableFunction fetchConstructorParamTypes = ClassLambdaAccess::buildConstructorParamTypes;
        MethodVisitor methodVisitor = cw.visitMethod(4, fetchConstructorParamTypes.serialized().getImplMethodName(), "()[[Ljava/lang/Class;", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitLdcInsn(size);
        methodVisitor.visitTypeInsn(189, "[Ljava/lang/Class;");
        methodVisitor.visitVarInsn(58, 1);
        for (int i = 0; i < size; ++i) {
            Constructor constructor = (Constructor)constructorList.get(i);
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            int len = parameterTypes.length;
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitIntInsn(16, i);
            methodVisitor.visitIntInsn(16, len);
            methodVisitor.visitTypeInsn(189, "java/lang/Class");
            for (int j = 0; j < len; ++j) {
                Class<?> parameterType = parameterTypes[j];
                methodVisitor.visitInsn(89);
                methodVisitor.visitIntInsn(16, j);
                if (parameterType.isPrimitive()) {
                    methodVisitor.visitFieldInsn(178, Type.getInternalName(Types.getWrapperClass(parameterType)), "TYPE", "Ljava/lang/Class;");
                } else {
                    methodVisitor.visitLdcInsn(Type.getType(parameterType));
                }
                methodVisitor.visitInsn(83);
            }
            methodVisitor.visitInsn(83);
        }
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        MethodVisitor methodVisitor2 = cw.visitMethod(4, buildConstructors.serialized().getImplMethodName(), "()[Ljava/util/function/Function;", "()[Ljava/util/function/Function<[Ljava/lang/Object;Ljava/lang/Object;>;", null);
        methodVisitor2.visitCode();
        methodVisitor2.visitLdcInsn(size);
        methodVisitor2.visitTypeInsn(189, "java/util/function/Function");
        methodVisitor2.visitVarInsn(58, 1);
        for (int i = 0; i < size; ++i) {
            Constructor constructor = (Constructor)constructorList.get(i);
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            int len = parameterTypes.length;
            methodVisitor2.visitVarInsn(25, 1);
            methodVisitor2.visitIntInsn(16, i);
            methodVisitor2.visitInvokeDynamicInsn("apply", "()Ljava/util/function/Function;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), Type.getType("(Ljava/lang/Object;)Ljava/lang/Object;"), new Handle(6, accessClassNameInternal, lambdaPrefixOfConstructors + i, "([Ljava/lang/Object;)Ljava/lang/Object;", false), Type.getType("([Ljava/lang/Object;)Ljava/lang/Object;"));
            methodVisitor2.visitInsn(83);
        }
        methodVisitor2.visitVarInsn(25, 1);
        methodVisitor2.visitInsn(176);
        methodVisitor2.visitMaxs(0, 0);
        methodVisitor2.visitEnd();
        for (int i = 0; i < size; ++i) {
            Constructor constructor = (Constructor)constructorList.get(i);
            boolean hasThrows = constructor.getExceptionTypes().length > 0;
            MethodVisitor mv = cw.visitMethod(4106, lambdaPrefixOfConstructors + i, "([Ljava/lang/Object;)Ljava/lang/Object;", null, null);
            mv.visitCode();
            Label label0 = new Label();
            Label label1 = new Label();
            Label label2 = new Label();
            if (hasThrows) {
                mv.visitTryCatchBlock(label0, label1, label2, "java/lang/Throwable");
                mv.visitLabel(label0);
            }
            mv.visitTypeInsn(187, Type.getInternalName(type));
            mv.visitInsn(89);
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            int len = parameterTypes.length;
            for (int j = 0; j < len; ++j) {
                Class<?> parameterType = parameterTypes[j];
                mv.visitVarInsn(25, 0);
                mv.visitIntInsn(16, j);
                mv.visitInsn(50);
                Type paramType = Type.getType(parameterType);
                AsmUtils.autoUnBoxing(mv, paramType);
            }
            String constructorDescriptor = Type.getConstructorDescriptor(constructor);
            mv.visitMethodInsn(183, Type.getInternalName(type), "<init>", constructorDescriptor, false);
            if (hasThrows) {
                mv.visitLabel(label1);
            }
            mv.visitInsn(176);
            if (hasThrows) {
                mv.visitLabel(label2);
                mv.visitVarInsn(58, 2);
                mv.visitTypeInsn(187, Type.getInternalName(IllegalArgumentException.class));
                mv.visitInsn(89);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(183, Type.getInternalName(IllegalArgumentException.class), "<init>", "(Ljava/lang/Throwable;)V", false);
                mv.visitInsn(191);
            }
            mv.visitMaxs(2, 1);
            mv.visitEnd();
        }
    }

    private static <T> void insertMethodInvokers(ClassWriter cw, String accessClassNameInternal, Class<T> type) {
        SerializableFunction buildMethods = ClassLambdaAccess::buildMethods;
        Map<String, List<Method>> declaredMethods = ClassLambdaAccess.getDeclaredMethods(type);
        String lambdaPrefixOfMethods = "lambda$" + buildMethods.serialized().getImplMethodName() + "$";
        MethodVisitor methodVisitor = cw.visitMethod(4, buildMethods.serialized().getImplMethodName(), "()Ljava/util/Map;", "()Ljava/util/Map<Ljava/lang/String;[L" + Type.getInternalName(Tuple2.class) + "<[Ljava/lang/Class;Ljava/util/function/BiFunction<Ljava/lang/Object;[Ljava/lang/Object;Ljava/lang/Object;>;>;>;", null);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, "java/util/HashMap");
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
        methodVisitor.visitVarInsn(58, 1);
        int nameIdx = 0;
        for (Map.Entry<String, List<Method>> entry : declaredMethods.entrySet()) {
            List<Method> methods = entry.getValue();
            String methodName = entry.getKey();
            int methodCount = methods.size();
            methodVisitor.visitLdcInsn(methodCount);
            methodVisitor.visitTypeInsn(189, Type.getInternalName(Tuple2.class));
            methodVisitor.visitVarInsn(58, 2);
            for (int i = 0; i < methodCount; ++i) {
                Method method = methods.get(i);
                Class<?>[] parameterTypes = method.getParameterTypes();
                int len = parameterTypes.length;
                String lambdaName = lambdaPrefixOfMethods + methodName + "$" + i;
                methodVisitor.visitIntInsn(16, len);
                methodVisitor.visitTypeInsn(189, "java/lang/Class");
                for (int j = 0; j < len; ++j) {
                    Class<?> parameterType = parameterTypes[j];
                    methodVisitor.visitInsn(89);
                    methodVisitor.visitIntInsn(16, j);
                    if (parameterType.isPrimitive()) {
                        methodVisitor.visitFieldInsn(178, Type.getInternalName(Types.getWrapperClass(parameterType)), "TYPE", "Ljava/lang/Class;");
                    } else {
                        methodVisitor.visitLdcInsn(Type.getType(parameterType));
                    }
                    methodVisitor.visitInsn(83);
                }
                methodVisitor.visitVarInsn(58, 3);
                methodVisitor.visitInvokeDynamicInsn("apply", "()Ljava/util/function/BiFunction;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), Type.getType("(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"), new Handle(6, accessClassNameInternal, lambdaName, "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", false), Type.getType("(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;"));
                methodVisitor.visitVarInsn(58, 4);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitIntInsn(17, i);
                methodVisitor.visitTypeInsn(187, Type.getInternalName(Tuple2.class));
                methodVisitor.visitInsn(89);
                methodVisitor.visitVarInsn(25, 3);
                methodVisitor.visitVarInsn(25, 4);
                methodVisitor.visitMethodInsn(183, Type.getInternalName(Tuple2.class), "<init>", "(Ljava/lang/Object;Ljava/lang/Object;)V", false);
                methodVisitor.visitInsn(83);
            }
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitLdcInsn(methodName);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
            methodVisitor.visitInsn(87);
            ++nameIdx;
        }
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        int nameIdx2 = 0;
        for (Map.Entry<String, List<Method>> entry : declaredMethods.entrySet()) {
            List<Method> methods = entry.getValue();
            String methodName = entry.getKey();
            int methodCount = methods.size();
            for (int i = 0; i < methodCount; ++i) {
                Method method = methods.get(i);
                Class<?>[] parameterTypes = method.getParameterTypes();
                int len = parameterTypes.length;
                String lambdaName = lambdaPrefixOfMethods + methodName + "$" + i;
                boolean hasThrows = method.getExceptionTypes().length > 0;
                MethodVisitor mv = cw.visitMethod(4106, lambdaName, "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", null, null);
                mv.visitCode();
                Label labelStart = new Label();
                Label labelEnd = new Label();
                Label labelCatch = new Label();
                if (hasThrows) {
                    mv.visitTryCatchBlock(labelStart, labelEnd, labelCatch, "java/lang/Throwable");
                    mv.visitLabel(labelStart);
                }
                mv.visitVarInsn(25, 0);
                mv.visitTypeInsn(192, Type.getInternalName(type));
                if (Modifier.isStatic(method.getModifiers())) {
                    mv.visitInsn(87);
                }
                for (int j = 0; j < len; ++j) {
                    Class<?> parameterType = parameterTypes[j];
                    mv.visitVarInsn(25, 1);
                    mv.visitIntInsn(16, j);
                    mv.visitInsn(50);
                    Type paramType = Type.getType(parameterType);
                    AsmUtils.autoUnBoxing(mv, paramType);
                }
                Class<?> declaringClass = method.getDeclaringClass();
                boolean isInterface = declaringClass.isInterface();
                int invokeOpcode = isInterface ? 185 : (Modifier.isStatic(method.getModifiers()) ? 184 : 182);
                mv.visitMethodInsn(invokeOpcode, Type.getInternalName(declaringClass), methodName, Type.getMethodDescriptor(method), isInterface);
                Class<?> returnType = method.getReturnType();
                if (returnType.equals(Void.TYPE)) {
                    mv.visitInsn(1);
                } else {
                    AsmUtils.autoBoxing(mv, returnType);
                }
                if (hasThrows) {
                    mv.visitLabel(labelEnd);
                }
                mv.visitInsn(176);
                if (hasThrows) {
                    mv.visitLabel(labelCatch);
                    mv.visitVarInsn(58, 2);
                    mv.visitTypeInsn(187, Type.getInternalName(IllegalArgumentException.class));
                    mv.visitInsn(89);
                    mv.visitVarInsn(25, 2);
                    mv.visitMethodInsn(183, Type.getInternalName(IllegalArgumentException.class), "<init>", "(Ljava/lang/Throwable;)V", false);
                    mv.visitInsn(191);
                }
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
            ++nameIdx2;
        }
    }

    private static Map<String, List<Method>> getDeclaredMethods(Class type) {
        HashMap<String, Method> allMethods = new HashMap<String, Method>();
        boolean isInterface = type.isInterface();
        if (!isInterface) {
            for (Class nextClass = type; nextClass != null; nextClass = nextClass.getSuperclass()) {
                ClassLambdaAccess.recursiveAddMethodsToMap(nextClass, allMethods);
            }
        } else {
            ClassLambdaAccess.recursiveAddMethodsToMap(type, allMethods);
        }
        HashMap<String, List<Method>> overloadMethods = new HashMap<String, List<Method>>();
        allMethods.forEach((k, v) -> {
            List list = overloadMethods.computeIfAbsent(v.getName(), name -> new ArrayList());
            list.add(v);
        });
        return overloadMethods;
    }

    private static void recursiveAddMethodsToMap(Class interfaceType, Map<String, Method> methods) {
        for (Method method : interfaceType.getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if (Modifier.isPrivate(modifiers) || Reflects.isFinalizeMethod(method) || Reflects.isNotifyMethod(method) || Reflects.isNotifyAllMethod(method) || Reflects.isWaitMethod(method) || Reflects.isCloneMethod(method) && method.getDeclaringClass() == Object.class) continue;
            methods.putIfAbsent(method.getName() + Type.getMethodDescriptor(method), method);
        }
        for (Class<?> nextInterface : interfaceType.getInterfaces()) {
            ClassLambdaAccess.recursiveAddMethodsToMap(nextInterface, methods);
        }
    }

    private static <T> void insertFieldInvokers(ClassWriter cw, String accessClassNameInternal, Class<T> type) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Class<T> nextClass = type; nextClass != null && nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            for (Field field : nextClass.getDeclaredFields()) {
                int n = field.getModifiers();
                if (Modifier.isPrivate(n)) continue;
                fields.putIfAbsent(field.getName(), field);
            }
        }
        SerializableFunction buildFields = ClassLambdaAccess::buildFields;
        String lambdaPrefixOfFields = "lambda$" + buildFields.serialized().getImplMethodName() + "$";
        MethodVisitor methodVisitor = cw.visitMethod(4, buildFields.serialized().getImplMethodName(), "()Ljava/util/Map;", "()Ljava/util/Map<Ljava/lang/String;Lcom/jcfc/stdk/core/tuple/Tuple2<Ljava/util/function/Function<Ljava/lang/Object;Ljava/lang/Object;>;Ljava/util/function/BiConsumer<Ljava/lang/Object;Ljava/lang/Object;>;>;>;", null);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, "java/util/HashMap");
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
        methodVisitor.visitVarInsn(58, 1);
        for (Map.Entry entry : fields.entrySet()) {
            String fieldName = (String)entry.getKey();
            Field field = (Field)entry.getValue();
            methodVisitor.visitInvokeDynamicInsn("apply", "()Ljava/util/function/Function;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), Type.getType("(Ljava/lang/Object;)Ljava/lang/Object;"), new Handle(6, accessClassNameInternal, lambdaPrefixOfFields + fieldName + "Getter", "(Ljava/lang/Object;)Ljava/lang/Object;", false), Type.getType("(Ljava/lang/Object;)Ljava/lang/Object;"));
            methodVisitor.visitVarInsn(58, 2);
            methodVisitor.visitInvokeDynamicInsn("accept", "()Ljava/util/function/BiConsumer;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), Type.getType("(Ljava/lang/Object;Ljava/lang/Object;)V"), new Handle(6, accessClassNameInternal, lambdaPrefixOfFields + fieldName + "Setter", "(Ljava/lang/Object;Ljava/lang/Object;)V", false), Type.getType("(Ljava/lang/Object;Ljava/lang/Object;)V"));
            methodVisitor.visitVarInsn(58, 3);
            methodVisitor.visitTypeInsn(187, Type.getInternalName(Tuple2.class));
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitVarInsn(25, 3);
            methodVisitor.visitMethodInsn(183, Type.getInternalName(Tuple2.class), "<init>", "(Ljava/lang/Object;Ljava/lang/Object;)V", false);
            methodVisitor.visitVarInsn(58, 4);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitLdcInsn(fieldName);
            methodVisitor.visitVarInsn(25, 4);
            methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
            methodVisitor.visitInsn(87);
        }
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(4, 5);
        methodVisitor.visitEnd();
        for (Map.Entry entry : fields.entrySet()) {
            String string = (String)entry.getKey();
            Field field = (Field)entry.getValue();
            MethodVisitor mv = cw.visitMethod(4106, lambdaPrefixOfFields + string + "Setter", "(Ljava/lang/Object;Ljava/lang/Object;)V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(192, Type.getInternalName(type));
            if (Modifier.isStatic(field.getModifiers())) {
                mv.visitInsn(87);
            }
            mv.visitVarInsn(25, 1);
            Type fieldType = Type.getType(field.getType());
            AsmUtils.autoUnBoxing(mv, fieldType);
            if (Modifier.isStatic(field.getModifiers())) {
                mv.visitFieldInsn(179, Type.getInternalName(field.getDeclaringClass()), string, fieldType.getDescriptor());
            } else {
                mv.visitFieldInsn(181, Type.getInternalName(field.getDeclaringClass()), string, fieldType.getDescriptor());
            }
            mv.visitInsn(177);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
            mv = cw.visitMethod(4106, lambdaPrefixOfFields + string + "Getter", "(Ljava/lang/Object;)Ljava/lang/Object;", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(192, Type.getInternalName(type));
            if (Modifier.isStatic(field.getModifiers())) {
                mv.visitInsn(87);
                mv.visitFieldInsn(178, Type.getInternalName(field.getDeclaringClass()), string, Type.getDescriptor(field.getType()));
            } else {
                mv.visitFieldInsn(180, Type.getInternalName(type), string, Type.getDescriptor(field.getType()));
            }
            fieldType = Type.getType(field.getType());
            AsmUtils.autoBoxing(mv, fieldType);
            mv.visitInsn(176);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
    }
}

