/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.core.asm.reflect;

import io.polaris.core.asm.internal.AsmUtils;
import io.polaris.core.asm.reflect.AccessClassLoader;
import io.polaris.core.asm.reflect.AccessClassPool;
import io.polaris.core.collection.Iterables;
import io.polaris.dependency.org.objectweb.asm.ClassWriter;
import io.polaris.dependency.org.objectweb.asm.Label;
import io.polaris.dependency.org.objectweb.asm.MethodVisitor;
import io.polaris.dependency.org.objectweb.asm.Type;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public abstract class FieldAccess {
    private static final AccessClassPool<Class, FieldAccess> pool = new AccessClassPool();
    private String[] fieldNames;
    private Class[] fieldTypes;
    private Field[] fields;
    private java.lang.reflect.Type[] fieldGenericTypes;

    public int getIndex(String fieldName) {
        int n = this.fieldNames.length;
        for (int i = 0; i < n; ++i) {
            if (!this.fieldNames[i].equals(fieldName)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unable to find non-private field: " + fieldName);
    }

    public int getIndex(Field field) {
        int n = this.fields.length;
        for (int i = 0; i < n; ++i) {
            if (!this.fields[i].equals(field)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unable to find non-private field: " + field);
    }

    public void set(Object instance, String fieldName, Object value) {
        this.set(instance, this.getIndex(fieldName), value);
    }

    public Object get(Object instance, String fieldName) {
        return this.get(instance, this.getIndex(fieldName));
    }

    public List<String> getFieldNames() {
        return Iterables.asList(this.fieldNames);
    }

    public List<Class> getFieldTypes() {
        return Iterables.asList(this.fieldTypes);
    }

    public List<java.lang.reflect.Type> getFieldGenericTypes() {
        return Iterables.asList(this.fieldGenericTypes);
    }

    public int getFieldCount() {
        return this.fieldTypes.length;
    }

    public List<Field> getFields() {
        return Iterables.asList(this.fields);
    }

    public abstract void set(Object var1, int var2, Object var3);

    public abstract void setBoolean(Object var1, int var2, boolean var3);

    public abstract void setByte(Object var1, int var2, byte var3);

    public abstract void setShort(Object var1, int var2, short var3);

    public abstract void setInt(Object var1, int var2, int var3);

    public abstract void setLong(Object var1, int var2, long var3);

    public abstract void setDouble(Object var1, int var2, double var3);

    public abstract void setFloat(Object var1, int var2, float var3);

    public abstract void setChar(Object var1, int var2, char var3);

    public abstract Object get(Object var1, int var2);

    public abstract String getString(Object var1, int var2);

    public abstract char getChar(Object var1, int var2);

    public abstract boolean getBoolean(Object var1, int var2);

    public abstract byte getByte(Object var1, int var2);

    public abstract short getShort(Object var1, int var2);

    public abstract int getInt(Object var1, int var2);

    public abstract long getLong(Object var1, int var2);

    public abstract double getDouble(Object var1, int var2);

    public abstract float getFloat(Object var1, int var2);

    public static FieldAccess get(Class type) {
        return pool.computeIfAbsent(type, FieldAccess::create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FieldAccess create(Class type) {
        Class accessClass;
        AccessClassLoader loader;
        if (type.getSuperclass() == null) {
            throw new IllegalArgumentException("\u7c7b\u578b\u4e0d\u80fd\u4e3aObject\u3001interface\u3001\u539f\u59cb\u7c7b\u578b\u6216void");
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class nextClass = type; nextClass != null && nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            for (Field field : nextClass.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers)) continue;
                fields.add(field);
            }
        }
        String[] fieldNames = new String[fields.size()];
        Class[] fieldTypes = new Class[fields.size()];
        Class[] fieldGenericTypes = new Class[fields.size()];
        int n = fieldNames.length;
        for (int i = 0; i < n; ++i) {
            fieldNames[i] = ((Field)fields.get(i)).getName();
            fieldTypes[i] = ((Field)fields.get(i)).getType();
            fieldGenericTypes[i] = ((Field)fields.get(i)).getGenericType();
        }
        String accessClassName = AccessClassLoader.buildAccessClassName(type, FieldAccess.class);
        AccessClassLoader accessClassLoader = loader = AccessClassLoader.get(type);
        synchronized (accessClassLoader) {
            accessClass = loader.loadAccessClass(accessClassName);
            if (accessClass == null) {
                String accessClassNameInternal = accessClassName.replace('.', '/');
                String classNameInternal = type.getName().replace('.', '/');
                ClassWriter cw = new ClassWriter(2);
                cw.visit(52, 33, accessClassNameInternal, null, FieldAccess.class.getName().replace('.', '/'), null);
                FieldAccess.insertConstructor(cw);
                FieldAccess.insertGetObject(cw, classNameInternal, fields);
                FieldAccess.insertSetObject(cw, classNameInternal, fields);
                FieldAccess.insertGetPrimitive(cw, classNameInternal, fields, Type.BOOLEAN_TYPE);
                FieldAccess.insertSetPrimitive(cw, classNameInternal, fields, Type.BOOLEAN_TYPE);
                FieldAccess.insertGetPrimitive(cw, classNameInternal, fields, Type.BYTE_TYPE);
                FieldAccess.insertSetPrimitive(cw, classNameInternal, fields, Type.BYTE_TYPE);
                FieldAccess.insertGetPrimitive(cw, classNameInternal, fields, Type.SHORT_TYPE);
                FieldAccess.insertSetPrimitive(cw, classNameInternal, fields, Type.SHORT_TYPE);
                FieldAccess.insertGetPrimitive(cw, classNameInternal, fields, Type.INT_TYPE);
                FieldAccess.insertSetPrimitive(cw, classNameInternal, fields, Type.INT_TYPE);
                FieldAccess.insertGetPrimitive(cw, classNameInternal, fields, Type.LONG_TYPE);
                FieldAccess.insertSetPrimitive(cw, classNameInternal, fields, Type.LONG_TYPE);
                FieldAccess.insertGetPrimitive(cw, classNameInternal, fields, Type.DOUBLE_TYPE);
                FieldAccess.insertSetPrimitive(cw, classNameInternal, fields, Type.DOUBLE_TYPE);
                FieldAccess.insertGetPrimitive(cw, classNameInternal, fields, Type.FLOAT_TYPE);
                FieldAccess.insertSetPrimitive(cw, classNameInternal, fields, Type.FLOAT_TYPE);
                FieldAccess.insertGetPrimitive(cw, classNameInternal, fields, Type.CHAR_TYPE);
                FieldAccess.insertSetPrimitive(cw, classNameInternal, fields, Type.CHAR_TYPE);
                FieldAccess.insertGetString(cw, classNameInternal, fields);
                cw.visitEnd();
                accessClass = loader.defineAccessClass(accessClassName, cw.toByteArray());
            }
        }
        try {
            FieldAccess access = (FieldAccess)accessClass.newInstance();
            access.fieldNames = fieldNames;
            access.fieldTypes = fieldTypes;
            access.fieldGenericTypes = fieldGenericTypes;
            access.fields = fields.toArray(new Field[fields.size()]);
            return access;
        }
        catch (Throwable t) {
            throw new IllegalStateException("\u521b\u5efa\u8bbf\u95ee\u7c7b\u5931\u8d25: " + accessClassName, t);
        }
    }

    private static void insertConstructor(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, FieldAccess.class.getName().replace('.', '/'), "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void insertSetObject(ClassWriter cw, String classNameInternal, ArrayList<Field> fields) {
        int maxStack = 6;
        MethodVisitor mv = cw.visitMethod(1, "set", "(Ljava/lang/Object;ILjava/lang/Object;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(21, 2);
        if (!fields.isEmpty()) {
            --maxStack;
            Label[] labels = new Label[fields.size()];
            int n = labels.length;
            for (int i = 0; i < n; ++i) {
                labels[i] = new Label();
            }
            Label defaultLabel = new Label();
            mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
            int n2 = labels.length;
            for (int i = 0; i < n2; ++i) {
                Field field = fields.get(i);
                Type fieldType = Type.getType(field.getType());
                mv.visitLabel(labels[i]);
                mv.visitFrame(3, 0, null, 0, null);
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(192, classNameInternal);
                mv.visitVarInsn(25, 3);
                AsmUtils.autoUnBoxing(mv, fieldType);
                mv.visitFieldInsn(181, field.getDeclaringClass().getName().replace('.', '/'), field.getName(), fieldType.getDescriptor());
                mv.visitInsn(177);
            }
            mv.visitLabel(defaultLabel);
            mv.visitFrame(3, 0, null, 0, null);
        }
        mv = FieldAccess.insertThrowExceptionForFieldNotFound(mv);
        mv.visitMaxs(maxStack, 4);
        mv.visitEnd();
    }

    private static void insertGetObject(ClassWriter cw, String classNameInternal, ArrayList<Field> fields) {
        int maxStack = 6;
        MethodVisitor mv = cw.visitMethod(1, "get", "(Ljava/lang/Object;I)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(21, 2);
        if (!fields.isEmpty()) {
            --maxStack;
            Label[] labels = new Label[fields.size()];
            int n = labels.length;
            for (int i = 0; i < n; ++i) {
                labels[i] = new Label();
            }
            Label defaultLabel = new Label();
            mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
            int n2 = labels.length;
            for (int i = 0; i < n2; ++i) {
                Field field = fields.get(i);
                mv.visitLabel(labels[i]);
                mv.visitFrame(3, 0, null, 0, null);
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(192, classNameInternal);
                mv.visitFieldInsn(180, field.getDeclaringClass().getName().replace('.', '/'), field.getName(), Type.getDescriptor(field.getType()));
                Type fieldType = Type.getType(field.getType());
                AsmUtils.autoBoxing(mv, fieldType);
                mv.visitInsn(176);
            }
            mv.visitLabel(defaultLabel);
            mv.visitFrame(3, 0, null, 0, null);
        }
        FieldAccess.insertThrowExceptionForFieldNotFound(mv);
        mv.visitMaxs(maxStack, 3);
        mv.visitEnd();
    }

    private static void insertGetString(ClassWriter cw, String classNameInternal, ArrayList<Field> fields) {
        int maxStack = 6;
        MethodVisitor mv = cw.visitMethod(1, "getString", "(Ljava/lang/Object;I)Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitVarInsn(21, 2);
        if (!fields.isEmpty()) {
            --maxStack;
            Label[] labels = new Label[fields.size()];
            Label labelForInvalidTypes = new Label();
            boolean hasAnyBadTypeLabel = false;
            int n = labels.length;
            for (int i = 0; i < n; ++i) {
                if (fields.get(i).getType().equals(String.class)) {
                    labels[i] = new Label();
                    continue;
                }
                labels[i] = labelForInvalidTypes;
                hasAnyBadTypeLabel = true;
            }
            Label defaultLabel = new Label();
            mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
            int n2 = labels.length;
            for (int i = 0; i < n2; ++i) {
                if (labels[i].equals(labelForInvalidTypes)) continue;
                Field field = fields.get(i);
                mv.visitLabel(labels[i]);
                mv.visitFrame(3, 0, null, 0, null);
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(192, classNameInternal);
                mv.visitFieldInsn(180, field.getDeclaringClass().getName().replace('.', '/'), field.getName(), "Ljava/lang/String;");
                mv.visitInsn(176);
            }
            if (hasAnyBadTypeLabel) {
                mv.visitLabel(labelForInvalidTypes);
                mv.visitFrame(3, 0, null, 0, null);
                FieldAccess.insertThrowExceptionForFieldType(mv, "String");
            }
            mv.visitLabel(defaultLabel);
            mv.visitFrame(3, 0, null, 0, null);
        }
        FieldAccess.insertThrowExceptionForFieldNotFound(mv);
        mv.visitMaxs(maxStack, 3);
        mv.visitEnd();
    }

    private static void insertSetPrimitive(ClassWriter cw, String classNameInternal, ArrayList<Field> fields, Type primitiveType) {
        int loadValueInstruction;
        String setterMethodName;
        int maxStack = 6;
        int maxLocals = 4;
        String typeNameInternal = primitiveType.getDescriptor();
        switch (primitiveType.getSort()) {
            case 1: {
                setterMethodName = "setBoolean";
                loadValueInstruction = 21;
                break;
            }
            case 3: {
                setterMethodName = "setByte";
                loadValueInstruction = 21;
                break;
            }
            case 2: {
                setterMethodName = "setChar";
                loadValueInstruction = 21;
                break;
            }
            case 4: {
                setterMethodName = "setShort";
                loadValueInstruction = 21;
                break;
            }
            case 5: {
                setterMethodName = "setInt";
                loadValueInstruction = 21;
                break;
            }
            case 6: {
                setterMethodName = "setFloat";
                loadValueInstruction = 23;
                break;
            }
            case 7: {
                setterMethodName = "setLong";
                loadValueInstruction = 22;
                ++maxLocals;
                break;
            }
            case 8: {
                setterMethodName = "setDouble";
                loadValueInstruction = 24;
                ++maxLocals;
                break;
            }
            default: {
                setterMethodName = "set";
                loadValueInstruction = 25;
            }
        }
        MethodVisitor mv = cw.visitMethod(1, setterMethodName, "(Ljava/lang/Object;I" + typeNameInternal + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(21, 2);
        if (!fields.isEmpty()) {
            --maxStack;
            Label[] labels = new Label[fields.size()];
            Label labelForInvalidTypes = new Label();
            boolean hasAnyBadTypeLabel = false;
            int n = labels.length;
            for (int i = 0; i < n; ++i) {
                if (Type.getType(fields.get(i).getType()).equals(primitiveType)) {
                    labels[i] = new Label();
                    continue;
                }
                labels[i] = labelForInvalidTypes;
                hasAnyBadTypeLabel = true;
            }
            Label defaultLabel = new Label();
            mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
            int n2 = labels.length;
            for (int i = 0; i < n2; ++i) {
                if (labels[i].equals(labelForInvalidTypes)) continue;
                Field field = fields.get(i);
                mv.visitLabel(labels[i]);
                mv.visitFrame(3, 0, null, 0, null);
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(192, classNameInternal);
                mv.visitVarInsn(loadValueInstruction, 3);
                mv.visitFieldInsn(181, field.getDeclaringClass().getName().replace('.', '/'), field.getName(), typeNameInternal);
                mv.visitInsn(177);
            }
            if (hasAnyBadTypeLabel) {
                mv.visitLabel(labelForInvalidTypes);
                mv.visitFrame(3, 0, null, 0, null);
                FieldAccess.insertThrowExceptionForFieldType(mv, primitiveType.getClassName());
            }
            mv.visitLabel(defaultLabel);
            mv.visitFrame(3, 0, null, 0, null);
        }
        mv = FieldAccess.insertThrowExceptionForFieldNotFound(mv);
        mv.visitMaxs(maxStack, maxLocals);
        mv.visitEnd();
    }

    private static void insertGetPrimitive(ClassWriter cw, String classNameInternal, ArrayList<Field> fields, Type primitiveType) {
        int returnValueInstruction;
        String getterMethodName;
        int maxStack = 6;
        String typeNameInternal = primitiveType.getDescriptor();
        switch (primitiveType.getSort()) {
            case 1: {
                getterMethodName = "getBoolean";
                returnValueInstruction = 172;
                break;
            }
            case 3: {
                getterMethodName = "getByte";
                returnValueInstruction = 172;
                break;
            }
            case 2: {
                getterMethodName = "getChar";
                returnValueInstruction = 172;
                break;
            }
            case 4: {
                getterMethodName = "getShort";
                returnValueInstruction = 172;
                break;
            }
            case 5: {
                getterMethodName = "getInt";
                returnValueInstruction = 172;
                break;
            }
            case 6: {
                getterMethodName = "getFloat";
                returnValueInstruction = 174;
                break;
            }
            case 7: {
                getterMethodName = "getLong";
                returnValueInstruction = 173;
                break;
            }
            case 8: {
                getterMethodName = "getDouble";
                returnValueInstruction = 175;
                break;
            }
            default: {
                getterMethodName = "get";
                returnValueInstruction = 176;
            }
        }
        MethodVisitor mv = cw.visitMethod(1, getterMethodName, "(Ljava/lang/Object;I)" + typeNameInternal, null, null);
        mv.visitCode();
        mv.visitVarInsn(21, 2);
        if (!fields.isEmpty()) {
            --maxStack;
            Label[] labels = new Label[fields.size()];
            Label labelForInvalidTypes = new Label();
            boolean hasAnyBadTypeLabel = false;
            int n = labels.length;
            for (int i = 0; i < n; ++i) {
                if (Type.getType(fields.get(i).getType()).equals(primitiveType)) {
                    labels[i] = new Label();
                    continue;
                }
                labels[i] = labelForInvalidTypes;
                hasAnyBadTypeLabel = true;
            }
            Label defaultLabel = new Label();
            mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
            int n2 = labels.length;
            for (int i = 0; i < n2; ++i) {
                Field field = fields.get(i);
                if (labels[i].equals(labelForInvalidTypes)) continue;
                mv.visitLabel(labels[i]);
                mv.visitFrame(3, 0, null, 0, null);
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(192, classNameInternal);
                mv.visitFieldInsn(180, field.getDeclaringClass().getName().replace('.', '/'), field.getName(), typeNameInternal);
                mv.visitInsn(returnValueInstruction);
            }
            if (hasAnyBadTypeLabel) {
                mv.visitLabel(labelForInvalidTypes);
                mv.visitFrame(3, 0, null, 0, null);
                FieldAccess.insertThrowExceptionForFieldType(mv, primitiveType.getClassName());
            }
            mv.visitLabel(defaultLabel);
            mv.visitFrame(3, 0, null, 0, null);
        }
        mv = FieldAccess.insertThrowExceptionForFieldNotFound(mv);
        mv.visitMaxs(maxStack, 3);
        mv.visitEnd();
    }

    private static MethodVisitor insertThrowExceptionForFieldNotFound(MethodVisitor mv) {
        mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        mv.visitInsn(89);
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitLdcInsn("Field not found: ");
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V");
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        return mv;
    }

    private static MethodVisitor insertThrowExceptionForFieldType(MethodVisitor mv, String fieldType) {
        mv.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        mv.visitInsn(89);
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitLdcInsn("Field not declared as " + fieldType + ": ");
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "(Ljava/lang/String;)V");
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        mv.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        return mv;
    }
}

